/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Data In Motion - initial API and implementation
 */

package org.eclipse.fennec.weather.sensinact.util;

import org.eclipse.fennec.qvt.osgi.annotations.ModuleName;
import org.eclipse.fennec.qvt.osgi.annotations.QvtBlackbox;
import org.eclipse.fennec.qvt.osgi.annotations.TemplatePath;
import org.eclipse.fennec.qvt.osgi.annotations.TransformatorId;
import org.eclipse.fennec.qvt.osgi.annotations.UnitQualifiedName;
import org.eclipse.m2m.qvt.oml.blackbox.java.Module;
import org.eclipse.m2m.qvt.oml.blackbox.java.Operation;
import org.eclipse.sensinact.gateway.geojson.GeoJsonObject;
import org.eclipse.sensinact.gateway.geojson.Point;
import org.eclipse.sensinact.model.core.provider.ProviderPackage;
import org.gecko.weather.model.weather.GeoPosition;
import org.gecko.weather.model.weather.WeatherPackage;
import org.osgi.annotation.bundle.Requirement;
import org.osgi.service.component.annotations.Component;


/**
 * 
 * @author mark
 * @since 24.11.2022
 */
@Requirement(namespace = "osgi.identity", filter = "(osgi.identity=org.gecko.weather.model)")
@Component(immediate = true, service = {LocationToGeoJsonBlackbox.class})
@QvtBlackbox
@TransformatorId("Weather2Sensinact")
@ModuleName("LocationToGeoJsonBlackbox")
@UnitQualifiedName("org.eclipse.fennec.weather.sensinact.util.LocationToGeoJsonBlackbox")
//@TemplatePath("org.eclipse.fennec.weather.sensinact.mmt/transformations/weather.qvto")
@Module(packageURIs={WeatherPackage.eNS_URI, ProviderPackage.eNS_URI})
public class LocationToGeoJsonBlackbox{
	
	@Operation(contextual = true, description = "Converts from UTM into degree latitude")
	public static GeoJsonObject toGeoJson(GeoPosition l) {
		return new Point(l.getLongitude(), l.getLatitude());
	}

}
