/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Data</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.airquality.AirQualityData#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.AirQualityData#getScd40 <em>Scd40</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.AirQualityData#getSht30 <em>Sht30</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.AirQualityData#getPir <em>Pir</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.AirQualityData#getSen55 <em>Sen55</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.AirQualityData#getStatus <em>Status</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.AirQualityData#getQmp6988 <em>Qmp6988</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData()
 * @model
 * @generated
 */
@ProviderType
public interface AirQualityData extends EObject {
	/**
	 * Returns the value of the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Timestamp</em>' attribute.
	 * @see #setTimestamp(String)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData_Timestamp()
	 * @model
	 * @generated
	 */
	String getTimestamp();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.AirQualityData#getTimestamp <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timestamp</em>' attribute.
	 * @see #getTimestamp()
	 * @generated
	 */
	void setTimestamp(String value);

	/**
	 * Returns the value of the '<em><b>Scd40</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Scd40</em>' containment reference.
	 * @see #setScd40(SCD40)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData_Scd40()
	 * @model containment="true"
	 * @generated
	 */
	SCD40 getScd40();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.AirQualityData#getScd40 <em>Scd40</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Scd40</em>' containment reference.
	 * @see #getScd40()
	 * @generated
	 */
	void setScd40(SCD40 value);

	/**
	 * Returns the value of the '<em><b>Sht30</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sht30</em>' containment reference.
	 * @see #setSht30(SHT30)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData_Sht30()
	 * @model containment="true"
	 * @generated
	 */
	SHT30 getSht30();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.AirQualityData#getSht30 <em>Sht30</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sht30</em>' containment reference.
	 * @see #getSht30()
	 * @generated
	 */
	void setSht30(SHT30 value);

	/**
	 * Returns the value of the '<em><b>Pir</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pir</em>' containment reference.
	 * @see #setPir(PIR)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData_Pir()
	 * @model containment="true"
	 * @generated
	 */
	PIR getPir();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.AirQualityData#getPir <em>Pir</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pir</em>' containment reference.
	 * @see #getPir()
	 * @generated
	 */
	void setPir(PIR value);

	/**
	 * Returns the value of the '<em><b>Sen55</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sen55</em>' containment reference.
	 * @see #setSen55(SEN55)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData_Sen55()
	 * @model containment="true"
	 * @generated
	 */
	SEN55 getSen55();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.AirQualityData#getSen55 <em>Sen55</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sen55</em>' containment reference.
	 * @see #getSen55()
	 * @generated
	 */
	void setSen55(SEN55 value);

	/**
	 * Returns the value of the '<em><b>Status</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Status</em>' containment reference.
	 * @see #setStatus(Status)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData_Status()
	 * @model containment="true"
	 * @generated
	 */
	Status getStatus();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.AirQualityData#getStatus <em>Status</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' containment reference.
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(Status value);

	/**
	 * Returns the value of the '<em><b>Qmp6988</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Qmp6988</em>' containment reference.
	 * @see #setQmp6988(QMP6988)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getAirQualityData_Qmp6988()
	 * @model containment="true"
	 * @generated
	 */
	QMP6988 getQmp6988();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.AirQualityData#getQmp6988 <em>Qmp6988</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Qmp6988</em>' containment reference.
	 * @see #getQmp6988()
	 * @generated
	 */
	void setQmp6988(QMP6988 value);

} // AirQualityData
