/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.gecko.mac.lorawan.LoRaWANPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.airquality.AirQualityFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel oSGiCompatible='true' resource='XMI' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motioni - initial API and implementation' basePackage='org.gecko.mac'"
 * @generated
 */
@ProviderType
@EPackage(uri = AirQualityPackage.eNS_URI, genModel = "/model/airquality-sensor.genmodel", genModelSourceLocations = {"model/airquality-sensor.genmodel","org.gecko.mac.airquality.sensor.model/model/airquality-sensor.genmodel"}, ecore="/model/airquality-sensor.ecore", ecoreSourceLocations="/model/airquality-sensor.ecore")
public interface AirQualityPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "airquality";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://datainmotion.com/mac/sensor/airquality/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "airquality";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AirQualityPackage eINSTANCE = org.gecko.mac.airquality.impl.AirQualityPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.AirQualitySensorImpl <em>Sensor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.AirQualitySensorImpl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getAirQualitySensor()
	 * @generated
	 */
	int AIR_QUALITY_SENSOR = 0;

	/**
	 * The feature id for the '<em><b>Deduplication Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__DEDUPLICATION_ID = LoRaWANPackage.UPLINK_MESSAGE__DEDUPLICATION_ID;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__TIME = LoRaWANPackage.UPLINK_MESSAGE__TIME;

	/**
	 * The feature id for the '<em><b>Adr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__ADR = LoRaWANPackage.UPLINK_MESSAGE__ADR;

	/**
	 * The feature id for the '<em><b>Dr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__DR = LoRaWANPackage.UPLINK_MESSAGE__DR;

	/**
	 * The feature id for the '<em><b>FCnt</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__FCNT = LoRaWANPackage.UPLINK_MESSAGE__FCNT;

	/**
	 * The feature id for the '<em><b>FPort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__FPORT = LoRaWANPackage.UPLINK_MESSAGE__FPORT;

	/**
	 * The feature id for the '<em><b>Confirmed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__CONFIRMED = LoRaWANPackage.UPLINK_MESSAGE__CONFIRMED;

	/**
	 * The feature id for the '<em><b>Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__DATA = LoRaWANPackage.UPLINK_MESSAGE__DATA;

	/**
	 * The feature id for the '<em><b>Device Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__DEVICE_INFO = LoRaWANPackage.UPLINK_MESSAGE__DEVICE_INFO;

	/**
	 * The feature id for the '<em><b>Rx Info</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__RX_INFO = LoRaWANPackage.UPLINK_MESSAGE__RX_INFO;

	/**
	 * The feature id for the '<em><b>Dev Addr</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__DEV_ADDR = LoRaWANPackage.UPLINK_MESSAGE__DEV_ADDR;

	/**
	 * The feature id for the '<em><b>Tx Info</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__TX_INFO = LoRaWANPackage.UPLINK_MESSAGE__TX_INFO;

	/**
	 * The feature id for the '<em><b>Object</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR__OBJECT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Sensor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR_FEATURE_COUNT = LoRaWANPackage.UPLINK_MESSAGE_FEATURE_COUNT + 1;

	/**
	 * The number of operations of the '<em>Sensor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_SENSOR_OPERATION_COUNT = LoRaWANPackage.UPLINK_MESSAGE_OPERATION_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.AirQualityDataImpl <em>Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.AirQualityDataImpl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getAirQualityData()
	 * @generated
	 */
	int AIR_QUALITY_DATA = 1;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA__TIMESTAMP = 0;

	/**
	 * The feature id for the '<em><b>Scd40</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA__SCD40 = 1;

	/**
	 * The feature id for the '<em><b>Sht30</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA__SHT30 = 2;

	/**
	 * The feature id for the '<em><b>Pir</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA__PIR = 3;

	/**
	 * The feature id for the '<em><b>Sen55</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA__SEN55 = 4;

	/**
	 * The feature id for the '<em><b>Status</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA__STATUS = 5;

	/**
	 * The feature id for the '<em><b>Qmp6988</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA__QMP6988 = 6;

	/**
	 * The number of structural features of the '<em>Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AIR_QUALITY_DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.SCD40Impl <em>SCD40</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.SCD40Impl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getSCD40()
	 * @generated
	 */
	int SCD40 = 2;

	/**
	 * The feature id for the '<em><b>Temperature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCD40__TEMPERATURE = 0;

	/**
	 * The feature id for the '<em><b>Humidity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCD40__HUMIDITY = 1;

	/**
	 * The feature id for the '<em><b>Co2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCD40__CO2 = 2;

	/**
	 * The number of structural features of the '<em>SCD40</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCD40_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>SCD40</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SCD40_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.SHT30Impl <em>SHT30</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.SHT30Impl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getSHT30()
	 * @generated
	 */
	int SHT30 = 3;

	/**
	 * The feature id for the '<em><b>Temperature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHT30__TEMPERATURE = 0;

	/**
	 * The feature id for the '<em><b>Humidity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHT30__HUMIDITY = 1;

	/**
	 * The number of structural features of the '<em>SHT30</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHT30_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>SHT30</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SHT30_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.PIRImpl <em>PIR</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.PIRImpl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getPIR()
	 * @generated
	 */
	int PIR = 4;

	/**
	 * The feature id for the '<em><b>Motion detected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PIR__MOTION_DETECTED = 0;

	/**
	 * The number of structural features of the '<em>PIR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PIR_FEATURE_COUNT = 1;

	/**
	 * The number of operations of the '<em>PIR</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PIR_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.SEN55Impl <em>SEN55</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.SEN55Impl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getSEN55()
	 * @generated
	 */
	int SEN55 = 5;

	/**
	 * The feature id for the '<em><b>Pm2p5</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__PM2P5 = 0;

	/**
	 * The feature id for the '<em><b>Pm10p0</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__PM10P0 = 1;

	/**
	 * The feature id for the '<em><b>Temperature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__TEMPERATURE = 2;

	/**
	 * The feature id for the '<em><b>Pm4p0</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__PM4P0 = 3;

	/**
	 * The feature id for the '<em><b>Humidity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__HUMIDITY = 4;

	/**
	 * The feature id for the '<em><b>Nox index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__NOX_INDEX = 5;

	/**
	 * The feature id for the '<em><b>Pm1p0</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__PM1P0 = 6;

	/**
	 * The feature id for the '<em><b>Voc index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55__VOC_INDEX = 7;

	/**
	 * The number of structural features of the '<em>SEN55</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>SEN55</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEN55_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.StatusImpl <em>Status</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.StatusImpl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getStatus()
	 * @generated
	 */
	int STATUS = 6;

	/**
	 * The feature id for the '<em><b>Connected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__CONNECTED = 0;

	/**
	 * The feature id for the '<em><b>Uptime</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS__UPTIME = 1;

	/**
	 * The number of structural features of the '<em>Status</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Status</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATUS_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.airquality.impl.QMP6988Impl <em>QMP6988</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.airquality.impl.QMP6988Impl
	 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getQMP6988()
	 * @generated
	 */
	int QMP6988 = 7;

	/**
	 * The feature id for the '<em><b>Pressure</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QMP6988__PRESSURE = 0;

	/**
	 * The feature id for the '<em><b>Pressure hpa</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QMP6988__PRESSURE_HPA = 1;

	/**
	 * The feature id for the '<em><b>Temperature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QMP6988__TEMPERATURE = 2;

	/**
	 * The number of structural features of the '<em>QMP6988</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QMP6988_FEATURE_COUNT = 3;

	/**
	 * The number of operations of the '<em>QMP6988</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int QMP6988_OPERATION_COUNT = 0;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.AirQualitySensor <em>Sensor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sensor</em>'.
	 * @see org.gecko.mac.airquality.AirQualitySensor
	 * @generated
	 */
	EClass getAirQualitySensor();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.airquality.AirQualitySensor#getObject <em>Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Object</em>'.
	 * @see org.gecko.mac.airquality.AirQualitySensor#getObject()
	 * @see #getAirQualitySensor()
	 * @generated
	 */
	EReference getAirQualitySensor_Object();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.AirQualityData <em>Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Data</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData
	 * @generated
	 */
	EClass getAirQualityData();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.AirQualityData#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData#getTimestamp()
	 * @see #getAirQualityData()
	 * @generated
	 */
	EAttribute getAirQualityData_Timestamp();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.airquality.AirQualityData#getScd40 <em>Scd40</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Scd40</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData#getScd40()
	 * @see #getAirQualityData()
	 * @generated
	 */
	EReference getAirQualityData_Scd40();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.airquality.AirQualityData#getSht30 <em>Sht30</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Sht30</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData#getSht30()
	 * @see #getAirQualityData()
	 * @generated
	 */
	EReference getAirQualityData_Sht30();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.airquality.AirQualityData#getPir <em>Pir</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Pir</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData#getPir()
	 * @see #getAirQualityData()
	 * @generated
	 */
	EReference getAirQualityData_Pir();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.airquality.AirQualityData#getSen55 <em>Sen55</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Sen55</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData#getSen55()
	 * @see #getAirQualityData()
	 * @generated
	 */
	EReference getAirQualityData_Sen55();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.airquality.AirQualityData#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Status</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData#getStatus()
	 * @see #getAirQualityData()
	 * @generated
	 */
	EReference getAirQualityData_Status();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.airquality.AirQualityData#getQmp6988 <em>Qmp6988</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Qmp6988</em>'.
	 * @see org.gecko.mac.airquality.AirQualityData#getQmp6988()
	 * @see #getAirQualityData()
	 * @generated
	 */
	EReference getAirQualityData_Qmp6988();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.SCD40 <em>SCD40</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SCD40</em>'.
	 * @see org.gecko.mac.airquality.SCD40
	 * @generated
	 */
	EClass getSCD40();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SCD40#getTemperature <em>Temperature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Temperature</em>'.
	 * @see org.gecko.mac.airquality.SCD40#getTemperature()
	 * @see #getSCD40()
	 * @generated
	 */
	EAttribute getSCD40_Temperature();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SCD40#getHumidity <em>Humidity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Humidity</em>'.
	 * @see org.gecko.mac.airquality.SCD40#getHumidity()
	 * @see #getSCD40()
	 * @generated
	 */
	EAttribute getSCD40_Humidity();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SCD40#getCo2 <em>Co2</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Co2</em>'.
	 * @see org.gecko.mac.airquality.SCD40#getCo2()
	 * @see #getSCD40()
	 * @generated
	 */
	EAttribute getSCD40_Co2();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.SHT30 <em>SHT30</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SHT30</em>'.
	 * @see org.gecko.mac.airquality.SHT30
	 * @generated
	 */
	EClass getSHT30();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SHT30#getTemperature <em>Temperature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Temperature</em>'.
	 * @see org.gecko.mac.airquality.SHT30#getTemperature()
	 * @see #getSHT30()
	 * @generated
	 */
	EAttribute getSHT30_Temperature();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SHT30#getHumidity <em>Humidity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Humidity</em>'.
	 * @see org.gecko.mac.airquality.SHT30#getHumidity()
	 * @see #getSHT30()
	 * @generated
	 */
	EAttribute getSHT30_Humidity();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.PIR <em>PIR</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>PIR</em>'.
	 * @see org.gecko.mac.airquality.PIR
	 * @generated
	 */
	EClass getPIR();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.PIR#isMotion_detected <em>Motion detected</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Motion detected</em>'.
	 * @see org.gecko.mac.airquality.PIR#isMotion_detected()
	 * @see #getPIR()
	 * @generated
	 */
	EAttribute getPIR_Motion_detected();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.SEN55 <em>SEN55</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>SEN55</em>'.
	 * @see org.gecko.mac.airquality.SEN55
	 * @generated
	 */
	EClass getSEN55();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getPm2p5 <em>Pm2p5</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pm2p5</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getPm2p5()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Pm2p5();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getPm10p0 <em>Pm10p0</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pm10p0</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getPm10p0()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Pm10p0();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getTemperature <em>Temperature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Temperature</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getTemperature()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Temperature();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getPm4p0 <em>Pm4p0</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pm4p0</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getPm4p0()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Pm4p0();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getHumidity <em>Humidity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Humidity</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getHumidity()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Humidity();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getNox_index <em>Nox index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Nox index</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getNox_index()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Nox_index();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getPm1p0 <em>Pm1p0</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pm1p0</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getPm1p0()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Pm1p0();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.SEN55#getVoc_index <em>Voc index</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Voc index</em>'.
	 * @see org.gecko.mac.airquality.SEN55#getVoc_index()
	 * @see #getSEN55()
	 * @generated
	 */
	EAttribute getSEN55_Voc_index();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.Status <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Status</em>'.
	 * @see org.gecko.mac.airquality.Status
	 * @generated
	 */
	EClass getStatus();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.Status#isConnected <em>Connected</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Connected</em>'.
	 * @see org.gecko.mac.airquality.Status#isConnected()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_Connected();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.Status#getUptime <em>Uptime</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Uptime</em>'.
	 * @see org.gecko.mac.airquality.Status#getUptime()
	 * @see #getStatus()
	 * @generated
	 */
	EAttribute getStatus_Uptime();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.airquality.QMP6988 <em>QMP6988</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>QMP6988</em>'.
	 * @see org.gecko.mac.airquality.QMP6988
	 * @generated
	 */
	EClass getQMP6988();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.QMP6988#getPressure <em>Pressure</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pressure</em>'.
	 * @see org.gecko.mac.airquality.QMP6988#getPressure()
	 * @see #getQMP6988()
	 * @generated
	 */
	EAttribute getQMP6988_Pressure();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.QMP6988#getPressure_hpa <em>Pressure hpa</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pressure hpa</em>'.
	 * @see org.gecko.mac.airquality.QMP6988#getPressure_hpa()
	 * @see #getQMP6988()
	 * @generated
	 */
	EAttribute getQMP6988_Pressure_hpa();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.airquality.QMP6988#getTemperature <em>Temperature</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Temperature</em>'.
	 * @see org.gecko.mac.airquality.QMP6988#getTemperature()
	 * @see #getQMP6988()
	 * @generated
	 */
	EAttribute getQMP6988_Temperature();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	AirQualityFactory getAirQualityFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.AirQualitySensorImpl <em>Sensor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.AirQualitySensorImpl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getAirQualitySensor()
		 * @generated
		 */
		EClass AIR_QUALITY_SENSOR = eINSTANCE.getAirQualitySensor();

		/**
		 * The meta object literal for the '<em><b>Object</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AIR_QUALITY_SENSOR__OBJECT = eINSTANCE.getAirQualitySensor_Object();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.AirQualityDataImpl <em>Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.AirQualityDataImpl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getAirQualityData()
		 * @generated
		 */
		EClass AIR_QUALITY_DATA = eINSTANCE.getAirQualityData();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AIR_QUALITY_DATA__TIMESTAMP = eINSTANCE.getAirQualityData_Timestamp();

		/**
		 * The meta object literal for the '<em><b>Scd40</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AIR_QUALITY_DATA__SCD40 = eINSTANCE.getAirQualityData_Scd40();

		/**
		 * The meta object literal for the '<em><b>Sht30</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AIR_QUALITY_DATA__SHT30 = eINSTANCE.getAirQualityData_Sht30();

		/**
		 * The meta object literal for the '<em><b>Pir</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AIR_QUALITY_DATA__PIR = eINSTANCE.getAirQualityData_Pir();

		/**
		 * The meta object literal for the '<em><b>Sen55</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AIR_QUALITY_DATA__SEN55 = eINSTANCE.getAirQualityData_Sen55();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AIR_QUALITY_DATA__STATUS = eINSTANCE.getAirQualityData_Status();

		/**
		 * The meta object literal for the '<em><b>Qmp6988</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AIR_QUALITY_DATA__QMP6988 = eINSTANCE.getAirQualityData_Qmp6988();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.SCD40Impl <em>SCD40</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.SCD40Impl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getSCD40()
		 * @generated
		 */
		EClass SCD40 = eINSTANCE.getSCD40();

		/**
		 * The meta object literal for the '<em><b>Temperature</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCD40__TEMPERATURE = eINSTANCE.getSCD40_Temperature();

		/**
		 * The meta object literal for the '<em><b>Humidity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCD40__HUMIDITY = eINSTANCE.getSCD40_Humidity();

		/**
		 * The meta object literal for the '<em><b>Co2</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SCD40__CO2 = eINSTANCE.getSCD40_Co2();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.SHT30Impl <em>SHT30</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.SHT30Impl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getSHT30()
		 * @generated
		 */
		EClass SHT30 = eINSTANCE.getSHT30();

		/**
		 * The meta object literal for the '<em><b>Temperature</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SHT30__TEMPERATURE = eINSTANCE.getSHT30_Temperature();

		/**
		 * The meta object literal for the '<em><b>Humidity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SHT30__HUMIDITY = eINSTANCE.getSHT30_Humidity();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.PIRImpl <em>PIR</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.PIRImpl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getPIR()
		 * @generated
		 */
		EClass PIR = eINSTANCE.getPIR();

		/**
		 * The meta object literal for the '<em><b>Motion detected</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PIR__MOTION_DETECTED = eINSTANCE.getPIR_Motion_detected();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.SEN55Impl <em>SEN55</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.SEN55Impl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getSEN55()
		 * @generated
		 */
		EClass SEN55 = eINSTANCE.getSEN55();

		/**
		 * The meta object literal for the '<em><b>Pm2p5</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__PM2P5 = eINSTANCE.getSEN55_Pm2p5();

		/**
		 * The meta object literal for the '<em><b>Pm10p0</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__PM10P0 = eINSTANCE.getSEN55_Pm10p0();

		/**
		 * The meta object literal for the '<em><b>Temperature</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__TEMPERATURE = eINSTANCE.getSEN55_Temperature();

		/**
		 * The meta object literal for the '<em><b>Pm4p0</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__PM4P0 = eINSTANCE.getSEN55_Pm4p0();

		/**
		 * The meta object literal for the '<em><b>Humidity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__HUMIDITY = eINSTANCE.getSEN55_Humidity();

		/**
		 * The meta object literal for the '<em><b>Nox index</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__NOX_INDEX = eINSTANCE.getSEN55_Nox_index();

		/**
		 * The meta object literal for the '<em><b>Pm1p0</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__PM1P0 = eINSTANCE.getSEN55_Pm1p0();

		/**
		 * The meta object literal for the '<em><b>Voc index</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute SEN55__VOC_INDEX = eINSTANCE.getSEN55_Voc_index();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.StatusImpl <em>Status</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.StatusImpl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getStatus()
		 * @generated
		 */
		EClass STATUS = eINSTANCE.getStatus();

		/**
		 * The meta object literal for the '<em><b>Connected</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__CONNECTED = eINSTANCE.getStatus_Connected();

		/**
		 * The meta object literal for the '<em><b>Uptime</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATUS__UPTIME = eINSTANCE.getStatus_Uptime();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.airquality.impl.QMP6988Impl <em>QMP6988</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.airquality.impl.QMP6988Impl
		 * @see org.gecko.mac.airquality.impl.AirQualityPackageImpl#getQMP6988()
		 * @generated
		 */
		EClass QMP6988 = eINSTANCE.getQMP6988();

		/**
		 * The meta object literal for the '<em><b>Pressure</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QMP6988__PRESSURE = eINSTANCE.getQMP6988_Pressure();

		/**
		 * The meta object literal for the '<em><b>Pressure hpa</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QMP6988__PRESSURE_HPA = eINSTANCE.getQMP6988_Pressure_hpa();

		/**
		 * The meta object literal for the '<em><b>Temperature</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute QMP6988__TEMPERATURE = eINSTANCE.getQMP6988_Temperature();

	}

} //AirQualityPackage
