/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>QMP6988</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.airquality.QMP6988#getPressure <em>Pressure</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.QMP6988#getPressure_hpa <em>Pressure hpa</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.QMP6988#getTemperature <em>Temperature</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.airquality.AirQualityPackage#getQMP6988()
 * @model
 * @generated
 */
@ProviderType
public interface QMP6988 extends EObject {
	/**
	 * Returns the value of the '<em><b>Pressure</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pressure</em>' attribute.
	 * @see #setPressure(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getQMP6988_Pressure()
	 * @model
	 * @generated
	 */
	double getPressure();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.QMP6988#getPressure <em>Pressure</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pressure</em>' attribute.
	 * @see #getPressure()
	 * @generated
	 */
	void setPressure(double value);

	/**
	 * Returns the value of the '<em><b>Pressure hpa</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pressure hpa</em>' attribute.
	 * @see #setPressure_hpa(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getQMP6988_Pressure_hpa()
	 * @model
	 * @generated
	 */
	double getPressure_hpa();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.QMP6988#getPressure_hpa <em>Pressure hpa</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pressure hpa</em>' attribute.
	 * @see #getPressure_hpa()
	 * @generated
	 */
	void setPressure_hpa(double value);

	/**
	 * Returns the value of the '<em><b>Temperature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Temperature</em>' attribute.
	 * @see #setTemperature(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getQMP6988_Temperature()
	 * @model
	 * @generated
	 */
	double getTemperature();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.QMP6988#getTemperature <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Temperature</em>' attribute.
	 * @see #getTemperature()
	 * @generated
	 */
	void setTemperature(double value);

} // QMP6988
