/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>SEN55</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getPm2p5 <em>Pm2p5</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getPm10p0 <em>Pm10p0</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getTemperature <em>Temperature</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getPm4p0 <em>Pm4p0</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getHumidity <em>Humidity</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getNox_index <em>Nox index</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getPm1p0 <em>Pm1p0</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.SEN55#getVoc_index <em>Voc index</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55()
 * @model
 * @generated
 */
@ProviderType
public interface SEN55 extends EObject {
	/**
	 * Returns the value of the '<em><b>Pm2p5</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pm2p5</em>' attribute.
	 * @see #setPm2p5(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Pm2p5()
	 * @model
	 * @generated
	 */
	double getPm2p5();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getPm2p5 <em>Pm2p5</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pm2p5</em>' attribute.
	 * @see #getPm2p5()
	 * @generated
	 */
	void setPm2p5(double value);

	/**
	 * Returns the value of the '<em><b>Pm10p0</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pm10p0</em>' attribute.
	 * @see #setPm10p0(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Pm10p0()
	 * @model
	 * @generated
	 */
	double getPm10p0();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getPm10p0 <em>Pm10p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pm10p0</em>' attribute.
	 * @see #getPm10p0()
	 * @generated
	 */
	void setPm10p0(double value);

	/**
	 * Returns the value of the '<em><b>Temperature</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Temperature</em>' attribute.
	 * @see #setTemperature(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Temperature()
	 * @model
	 * @generated
	 */
	double getTemperature();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getTemperature <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Temperature</em>' attribute.
	 * @see #getTemperature()
	 * @generated
	 */
	void setTemperature(double value);

	/**
	 * Returns the value of the '<em><b>Pm4p0</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pm4p0</em>' attribute.
	 * @see #setPm4p0(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Pm4p0()
	 * @model
	 * @generated
	 */
	double getPm4p0();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getPm4p0 <em>Pm4p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pm4p0</em>' attribute.
	 * @see #getPm4p0()
	 * @generated
	 */
	void setPm4p0(double value);

	/**
	 * Returns the value of the '<em><b>Humidity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Humidity</em>' attribute.
	 * @see #setHumidity(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Humidity()
	 * @model
	 * @generated
	 */
	double getHumidity();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getHumidity <em>Humidity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Humidity</em>' attribute.
	 * @see #getHumidity()
	 * @generated
	 */
	void setHumidity(double value);

	/**
	 * Returns the value of the '<em><b>Nox index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Nox index</em>' attribute.
	 * @see #setNox_index(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Nox_index()
	 * @model
	 * @generated
	 */
	double getNox_index();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getNox_index <em>Nox index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Nox index</em>' attribute.
	 * @see #getNox_index()
	 * @generated
	 */
	void setNox_index(double value);

	/**
	 * Returns the value of the '<em><b>Pm1p0</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Pm1p0</em>' attribute.
	 * @see #setPm1p0(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Pm1p0()
	 * @model
	 * @generated
	 */
	double getPm1p0();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getPm1p0 <em>Pm1p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Pm1p0</em>' attribute.
	 * @see #getPm1p0()
	 * @generated
	 */
	void setPm1p0(double value);

	/**
	 * Returns the value of the '<em><b>Voc index</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Voc index</em>' attribute.
	 * @see #setVoc_index(double)
	 * @see org.gecko.mac.airquality.AirQualityPackage#getSEN55_Voc_index()
	 * @model
	 * @generated
	 */
	double getVoc_index();

	/**
	 * Sets the value of the '{@link org.gecko.mac.airquality.SEN55#getVoc_index <em>Voc index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Voc index</em>' attribute.
	 * @see #getVoc_index()
	 * @generated
	 */
	void setVoc_index(double value);

} // SEN55
