/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality.configuration;

import java.util.Hashtable;

import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.resource.Resource.Factory;

import org.gecko.emf.osgi.configurator.EPackageConfigurator;

import org.gecko.mac.airquality.AirQualityFactory;
import org.gecko.mac.airquality.AirQualityPackage;

import org.gecko.mac.airquality.impl.AirQualityPackageImpl;

import org.gecko.mac.airquality.util.AirQualityResourceFactoryImpl;
import org.gecko.mac.governance.workflow.ModelInitializer;
import org.osgi.annotation.bundle.Capability;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

import org.osgi.service.condition.Condition;
/**
 * The <b>PackageConfiguration</b> for the model.
 * The package will be registered into a OSGi base model registry.
 * 
 * @generated
 */
@Component(name = "AirQualityConfigurator", immediate = true)
@Capability( namespace = "osgi.service", attribute = { "objectClass:List<String>=\"org.gecko.mac.airquality.util.AirQualityResourceFactoryImpl, org.eclipse.emf.ecore.resource.Resource$Factory\"" , "uses:=\"org.eclipse.emf.ecore.resource,org.gecko.mac.airquality.util\"" })
@Capability( namespace = "osgi.service", attribute = { "objectClass:List<String>=\"org.gecko.mac.airquality.AirQualityFactory, org.eclipse.emf.ecore.EFactory\"" , "uses:=\"org.eclipse.emf.ecore,org.gecko.mac.airquality\"" })
@Capability( namespace = "osgi.service", attribute = { "objectClass:List<String>=\"org.gecko.mac.airquality.AirQualityPackage, org.eclipse.emf.ecore.EPackage\"" , "uses:=\"org.eclipse.emf.ecore,org.gecko.mac.airquality\"" })
@Capability( namespace = "osgi.service", attribute = { "objectClass:List<String>=\"org.gecko.emf.osgi.configurator.EPackageConfigurator\"" , "uses:=\"org.eclipse.emf.ecore,org.gecko.mac.airquality\"" })
@Capability( namespace = "osgi.service", attribute = { "objectClass:List<String>=\"org.osgi.service.condition.Condition\"" , "uses:=org.osgi.service.condition" })
public class AirQualityConfigurationComponent implements ModelInitializer {
	
	private ServiceRegistration<?> packageRegistration = null;
	private ServiceRegistration<EPackageConfigurator> ePackageConfiguratorRegistration = null;
	private ServiceRegistration<?> eFactoryRegistration = null;
	private ServiceRegistration<?> conditionRegistration = null;
	private ServiceRegistration<?> resourceFactoryRegistration = null;
	private BundleContext ctx;

	/* 
	 * (non-Javadoc)
	 * @see org.gecko.mac.governance.workflow.ModelInitializer#doRegisterModel()
	 */
	@Override
	public String doRegisterModel() {
		AirQualityPackage ePackage = AirQualityPackageImpl.eINSTANCE;
		
		
		AirQualityEPackageConfigurator packageConfigurator = registerEPackageConfiguratorService(ePackage, ctx);
		registerResourceFactoryService(ctx);
		registerEPackageService(ePackage, packageConfigurator, ctx);
		registerEFactoryService(ePackage, packageConfigurator, ctx);
		registerConditionService(packageConfigurator, ctx);
		return ePackage.getNsURI();
	}
	
	/* 
	 * (non-Javadoc)
	 * @see org.gecko.mac.governance.workflow.ModelInitializer#doUnregisterModel()
	 */
	@Override
	public void doUnregisterModel() {
		conditionRegistration.unregister();
		eFactoryRegistration.unregister();
		packageRegistration.unregister();
		resourceFactoryRegistration.unregister();

		ePackageConfiguratorRegistration.unregister();
		EPackage.Registry.INSTANCE.remove(AirQualityPackage.eNS_URI);
	}
	/**
	 * Activates the Configuration Component.
	 *
	 * @generated
	 */
	@Activate
	public void activate(BundleContext ctx) {
		this.ctx = ctx;
//		AirQualityPackage ePackage = AirQualityPackageImpl.eINSTANCE;
//		
//		
//		AirQualityEPackageConfigurator packageConfigurator = registerEPackageConfiguratorService(ePackage, ctx);
//		registerResourceFactoryService(ctx);
//		registerEPackageService(ePackage, packageConfigurator, ctx);
//		registerEFactoryService(ePackage, packageConfigurator, ctx);
//		registerConditionService(packageConfigurator, ctx);
	}
	
	/**
	 * Registers the AirQualityEPackageConfigurator as a service.
	 *
	 * @generated
	 */
	private AirQualityEPackageConfigurator registerEPackageConfiguratorService(AirQualityPackage ePackage, BundleContext ctx){
		AirQualityEPackageConfigurator packageConfigurator = new AirQualityEPackageConfigurator(ePackage);
		// register the EPackageConfigurator
		Hashtable<String, Object> properties = new Hashtable<String, Object>();
		properties.putAll(packageConfigurator.getServiceProperties());
		ePackageConfiguratorRegistration = ctx.registerService(EPackageConfigurator.class, packageConfigurator, properties);

		return packageConfigurator;
	}

	/**
	 * Registers the AirQualityResourceFactoryImpl as a service.
	 *
	 * @generated
	 */
	private void registerResourceFactoryService(BundleContext ctx){
		AirQualityResourceFactoryImpl factory = new AirQualityResourceFactoryImpl();
		Hashtable<String, Object> properties = new Hashtable<String, Object>();
		properties.putAll(factory.getServiceProperties());
		String[] serviceClasses = new String[] {AirQualityResourceFactoryImpl.class.getName(), Factory.class.getName()};
		resourceFactoryRegistration = ctx.registerService(serviceClasses, factory, properties);
	}

	/**
	 * Registers the AirQualityPackage as a service.
	 *
	 * @generated
	 */
	private void registerEPackageService(AirQualityPackage ePackage, AirQualityEPackageConfigurator packageConfigurator, BundleContext ctx){
		Hashtable<String, Object> properties = new Hashtable<String, Object>();
		properties.putAll(packageConfigurator.getServiceProperties());
		String[] serviceClasses = new String[] {AirQualityPackage.class.getName(), EPackage.class.getName()};
		packageRegistration = ctx.registerService(serviceClasses, ePackage, properties);
	}

	/**
	 * Registers the AirQualityFactory as a service.
	 *
	 * @generated
	 */
	private void registerEFactoryService(AirQualityPackage ePackage, AirQualityEPackageConfigurator packageConfigurator, BundleContext ctx){
		Hashtable<String, Object> properties = new Hashtable<String, Object>();
		properties.putAll(packageConfigurator.getServiceProperties());
		String[] serviceClasses = new String[] {AirQualityFactory.class.getName(), EFactory.class.getName()};
		eFactoryRegistration = ctx.registerService(serviceClasses, ePackage.getAirQualityFactory(), properties);
	}

	private void registerConditionService(AirQualityEPackageConfigurator packageConfigurator, BundleContext ctx){
		// register the EPackage
		Hashtable<String, Object> properties = new Hashtable<String, Object>();
		properties.putAll(packageConfigurator.getServiceProperties());
		properties.put(Condition.CONDITION_ID, AirQualityPackage.eNS_URI);
		conditionRegistration = ctx.registerService(Condition.class, Condition.INSTANCE, properties);
	}

	/**
	 * Deactivates and unregisters everything.
	 *
	 * @generated
	 */
	@Deactivate
	public void deactivate() {
		doUnregisterModel();
//		conditionRegistration.unregister();
//		eFactoryRegistration.unregister();
//		packageRegistration.unregister();
//		resourceFactoryRegistration.unregister();
//
//		ePackageConfiguratorRegistration.unregister();
//		EPackage.Registry.INSTANCE.remove(AirQualityPackage.eNS_URI);
	}
}
