/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.airquality.AirQualityData;
import org.gecko.mac.airquality.AirQualityPackage;
import org.gecko.mac.airquality.PIR;
import org.gecko.mac.airquality.QMP6988;
import org.gecko.mac.airquality.SCD40;
import org.gecko.mac.airquality.SEN55;
import org.gecko.mac.airquality.SHT30;
import org.gecko.mac.airquality.Status;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.airquality.impl.AirQualityDataImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.AirQualityDataImpl#getScd40 <em>Scd40</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.AirQualityDataImpl#getSht30 <em>Sht30</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.AirQualityDataImpl#getPir <em>Pir</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.AirQualityDataImpl#getSen55 <em>Sen55</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.AirQualityDataImpl#getStatus <em>Status</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.AirQualityDataImpl#getQmp6988 <em>Qmp6988</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AirQualityDataImpl extends MinimalEObjectImpl.Container implements AirQualityData {
	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final String TIMESTAMP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected String timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The cached value of the '{@link #getScd40() <em>Scd40</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScd40()
	 * @generated
	 * @ordered
	 */
	protected SCD40 scd40;

	/**
	 * The cached value of the '{@link #getSht30() <em>Sht30</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSht30()
	 * @generated
	 * @ordered
	 */
	protected SHT30 sht30;

	/**
	 * The cached value of the '{@link #getPir() <em>Pir</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPir()
	 * @generated
	 * @ordered
	 */
	protected PIR pir;

	/**
	 * The cached value of the '{@link #getSen55() <em>Sen55</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSen55()
	 * @generated
	 * @ordered
	 */
	protected SEN55 sen55;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected Status status;

	/**
	 * The cached value of the '{@link #getQmp6988() <em>Qmp6988</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQmp6988()
	 * @generated
	 * @ordered
	 */
	protected QMP6988 qmp6988;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AirQualityDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AirQualityPackage.Literals.AIR_QUALITY_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimestamp(String newTimestamp) {
		String oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SCD40 getScd40() {
		return scd40;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetScd40(SCD40 newScd40, NotificationChain msgs) {
		SCD40 oldScd40 = scd40;
		scd40 = newScd40;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__SCD40, oldScd40, newScd40);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setScd40(SCD40 newScd40) {
		if (newScd40 != scd40) {
			NotificationChain msgs = null;
			if (scd40 != null)
				msgs = ((InternalEObject)scd40).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__SCD40, null, msgs);
			if (newScd40 != null)
				msgs = ((InternalEObject)newScd40).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__SCD40, null, msgs);
			msgs = basicSetScd40(newScd40, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__SCD40, newScd40, newScd40));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SHT30 getSht30() {
		return sht30;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSht30(SHT30 newSht30, NotificationChain msgs) {
		SHT30 oldSht30 = sht30;
		sht30 = newSht30;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__SHT30, oldSht30, newSht30);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSht30(SHT30 newSht30) {
		if (newSht30 != sht30) {
			NotificationChain msgs = null;
			if (sht30 != null)
				msgs = ((InternalEObject)sht30).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__SHT30, null, msgs);
			if (newSht30 != null)
				msgs = ((InternalEObject)newSht30).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__SHT30, null, msgs);
			msgs = basicSetSht30(newSht30, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__SHT30, newSht30, newSht30));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PIR getPir() {
		return pir;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPir(PIR newPir, NotificationChain msgs) {
		PIR oldPir = pir;
		pir = newPir;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__PIR, oldPir, newPir);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPir(PIR newPir) {
		if (newPir != pir) {
			NotificationChain msgs = null;
			if (pir != null)
				msgs = ((InternalEObject)pir).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__PIR, null, msgs);
			if (newPir != null)
				msgs = ((InternalEObject)newPir).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__PIR, null, msgs);
			msgs = basicSetPir(newPir, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__PIR, newPir, newPir));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SEN55 getSen55() {
		return sen55;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSen55(SEN55 newSen55, NotificationChain msgs) {
		SEN55 oldSen55 = sen55;
		sen55 = newSen55;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__SEN55, oldSen55, newSen55);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSen55(SEN55 newSen55) {
		if (newSen55 != sen55) {
			NotificationChain msgs = null;
			if (sen55 != null)
				msgs = ((InternalEObject)sen55).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__SEN55, null, msgs);
			if (newSen55 != null)
				msgs = ((InternalEObject)newSen55).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__SEN55, null, msgs);
			msgs = basicSetSen55(newSen55, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__SEN55, newSen55, newSen55));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Status getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStatus(Status newStatus, NotificationChain msgs) {
		Status oldStatus = status;
		status = newStatus;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__STATUS, oldStatus, newStatus);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStatus(Status newStatus) {
		if (newStatus != status) {
			NotificationChain msgs = null;
			if (status != null)
				msgs = ((InternalEObject)status).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__STATUS, null, msgs);
			if (newStatus != null)
				msgs = ((InternalEObject)newStatus).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__STATUS, null, msgs);
			msgs = basicSetStatus(newStatus, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__STATUS, newStatus, newStatus));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public QMP6988 getQmp6988() {
		return qmp6988;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetQmp6988(QMP6988 newQmp6988, NotificationChain msgs) {
		QMP6988 oldQmp6988 = qmp6988;
		qmp6988 = newQmp6988;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__QMP6988, oldQmp6988, newQmp6988);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setQmp6988(QMP6988 newQmp6988) {
		if (newQmp6988 != qmp6988) {
			NotificationChain msgs = null;
			if (qmp6988 != null)
				msgs = ((InternalEObject)qmp6988).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__QMP6988, null, msgs);
			if (newQmp6988 != null)
				msgs = ((InternalEObject)newQmp6988).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - AirQualityPackage.AIR_QUALITY_DATA__QMP6988, null, msgs);
			msgs = basicSetQmp6988(newQmp6988, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.AIR_QUALITY_DATA__QMP6988, newQmp6988, newQmp6988));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case AirQualityPackage.AIR_QUALITY_DATA__SCD40:
				return basicSetScd40(null, msgs);
			case AirQualityPackage.AIR_QUALITY_DATA__SHT30:
				return basicSetSht30(null, msgs);
			case AirQualityPackage.AIR_QUALITY_DATA__PIR:
				return basicSetPir(null, msgs);
			case AirQualityPackage.AIR_QUALITY_DATA__SEN55:
				return basicSetSen55(null, msgs);
			case AirQualityPackage.AIR_QUALITY_DATA__STATUS:
				return basicSetStatus(null, msgs);
			case AirQualityPackage.AIR_QUALITY_DATA__QMP6988:
				return basicSetQmp6988(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AirQualityPackage.AIR_QUALITY_DATA__TIMESTAMP:
				return getTimestamp();
			case AirQualityPackage.AIR_QUALITY_DATA__SCD40:
				return getScd40();
			case AirQualityPackage.AIR_QUALITY_DATA__SHT30:
				return getSht30();
			case AirQualityPackage.AIR_QUALITY_DATA__PIR:
				return getPir();
			case AirQualityPackage.AIR_QUALITY_DATA__SEN55:
				return getSen55();
			case AirQualityPackage.AIR_QUALITY_DATA__STATUS:
				return getStatus();
			case AirQualityPackage.AIR_QUALITY_DATA__QMP6988:
				return getQmp6988();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AirQualityPackage.AIR_QUALITY_DATA__TIMESTAMP:
				setTimestamp((String)newValue);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__SCD40:
				setScd40((SCD40)newValue);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__SHT30:
				setSht30((SHT30)newValue);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__PIR:
				setPir((PIR)newValue);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__SEN55:
				setSen55((SEN55)newValue);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__STATUS:
				setStatus((Status)newValue);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__QMP6988:
				setQmp6988((QMP6988)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AirQualityPackage.AIR_QUALITY_DATA__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__SCD40:
				setScd40((SCD40)null);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__SHT30:
				setSht30((SHT30)null);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__PIR:
				setPir((PIR)null);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__SEN55:
				setSen55((SEN55)null);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__STATUS:
				setStatus((Status)null);
				return;
			case AirQualityPackage.AIR_QUALITY_DATA__QMP6988:
				setQmp6988((QMP6988)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AirQualityPackage.AIR_QUALITY_DATA__TIMESTAMP:
				return TIMESTAMP_EDEFAULT == null ? timestamp != null : !TIMESTAMP_EDEFAULT.equals(timestamp);
			case AirQualityPackage.AIR_QUALITY_DATA__SCD40:
				return scd40 != null;
			case AirQualityPackage.AIR_QUALITY_DATA__SHT30:
				return sht30 != null;
			case AirQualityPackage.AIR_QUALITY_DATA__PIR:
				return pir != null;
			case AirQualityPackage.AIR_QUALITY_DATA__SEN55:
				return sen55 != null;
			case AirQualityPackage.AIR_QUALITY_DATA__STATUS:
				return status != null;
			case AirQualityPackage.AIR_QUALITY_DATA__QMP6988:
				return qmp6988 != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (timestamp: ");
		result.append(timestamp);
		result.append(')');
		return result.toString();
	}

} //AirQualityDataImpl
