/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.gecko.mac.airquality.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class AirQualityFactoryImpl extends EFactoryImpl implements AirQualityFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static AirQualityFactory init() {
		try {
			AirQualityFactory theAirQualityFactory = (AirQualityFactory)EPackage.Registry.INSTANCE.getEFactory(AirQualityPackage.eNS_URI);
			if (theAirQualityFactory != null) {
				return theAirQualityFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new AirQualityFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public AirQualityFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case AirQualityPackage.AIR_QUALITY_SENSOR: return createAirQualitySensor();
			case AirQualityPackage.AIR_QUALITY_DATA: return createAirQualityData();
			case AirQualityPackage.SCD40: return createSCD40();
			case AirQualityPackage.SHT30: return createSHT30();
			case AirQualityPackage.PIR: return createPIR();
			case AirQualityPackage.SEN55: return createSEN55();
			case AirQualityPackage.STATUS: return createStatus();
			case AirQualityPackage.QMP6988: return createQMP6988();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AirQualitySensor createAirQualitySensor() {
		AirQualitySensorImpl airQualitySensor = new AirQualitySensorImpl();
		return airQualitySensor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AirQualityData createAirQualityData() {
		AirQualityDataImpl airQualityData = new AirQualityDataImpl();
		return airQualityData;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SCD40 createSCD40() {
		SCD40Impl scd40 = new SCD40Impl();
		return scd40;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SHT30 createSHT30() {
		SHT30Impl sht30 = new SHT30Impl();
		return sht30;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PIR createPIR() {
		PIRImpl pir = new PIRImpl();
		return pir;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public SEN55 createSEN55() {
		SEN55Impl sen55 = new SEN55Impl();
		return sen55;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Status createStatus() {
		StatusImpl status = new StatusImpl();
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public QMP6988 createQMP6988() {
		QMP6988Impl qmp6988 = new QMP6988Impl();
		return qmp6988;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AirQualityPackage getAirQualityPackage() {
		return (AirQualityPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static AirQualityPackage getPackage() {
		return AirQualityPackage.eINSTANCE;
	}

} //AirQualityFactoryImpl
