/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.mac.airquality.AirQualityData;
import org.gecko.mac.airquality.AirQualityFactory;
import org.gecko.mac.airquality.AirQualityPackage;
import org.gecko.mac.airquality.AirQualitySensor;
import org.gecko.mac.airquality.Status;

import org.gecko.mac.lorawan.LoRaWANPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class AirQualityPackageImpl extends EPackageImpl implements AirQualityPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass airQualitySensorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass airQualityDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass scd40EClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sht30EClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass pirEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass sen55EClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass statusEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass qmp6988EClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.mac.airquality.AirQualityPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private AirQualityPackageImpl() {
		super(eNS_URI, AirQualityFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link AirQualityPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static AirQualityPackage init() {
		if (isInited) return (AirQualityPackage)EPackage.Registry.INSTANCE.getEPackage(AirQualityPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredAirQualityPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		AirQualityPackageImpl theAirQualityPackage = registeredAirQualityPackage instanceof AirQualityPackageImpl ? (AirQualityPackageImpl)registeredAirQualityPackage : new AirQualityPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		LoRaWANPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theAirQualityPackage.createPackageContents();

		// Initialize created meta-data
		theAirQualityPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theAirQualityPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(AirQualityPackage.eNS_URI, theAirQualityPackage);
		return theAirQualityPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAirQualitySensor() {
		return airQualitySensorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAirQualitySensor_Object() {
		return (EReference)airQualitySensorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAirQualityData() {
		return airQualityDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAirQualityData_Timestamp() {
		return (EAttribute)airQualityDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAirQualityData_Scd40() {
		return (EReference)airQualityDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAirQualityData_Sht30() {
		return (EReference)airQualityDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAirQualityData_Pir() {
		return (EReference)airQualityDataEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAirQualityData_Sen55() {
		return (EReference)airQualityDataEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAirQualityData_Status() {
		return (EReference)airQualityDataEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAirQualityData_Qmp6988() {
		return (EReference)airQualityDataEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSCD40() {
		return scd40EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSCD40_Temperature() {
		return (EAttribute)scd40EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSCD40_Humidity() {
		return (EAttribute)scd40EClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSCD40_Co2() {
		return (EAttribute)scd40EClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSHT30() {
		return sht30EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSHT30_Temperature() {
		return (EAttribute)sht30EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSHT30_Humidity() {
		return (EAttribute)sht30EClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPIR() {
		return pirEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPIR_Motion_detected() {
		return (EAttribute)pirEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getSEN55() {
		return sen55EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Pm2p5() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Pm10p0() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Temperature() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Pm4p0() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Humidity() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Nox_index() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Pm1p0() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getSEN55_Voc_index() {
		return (EAttribute)sen55EClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getStatus() {
		return statusEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStatus_Connected() {
		return (EAttribute)statusEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getStatus_Uptime() {
		return (EAttribute)statusEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getQMP6988() {
		return qmp6988EClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getQMP6988_Pressure() {
		return (EAttribute)qmp6988EClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getQMP6988_Pressure_hpa() {
		return (EAttribute)qmp6988EClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getQMP6988_Temperature() {
		return (EAttribute)qmp6988EClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AirQualityFactory getAirQualityFactory() {
		return (AirQualityFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		airQualitySensorEClass = createEClass(AIR_QUALITY_SENSOR);
		createEReference(airQualitySensorEClass, AIR_QUALITY_SENSOR__OBJECT);

		airQualityDataEClass = createEClass(AIR_QUALITY_DATA);
		createEAttribute(airQualityDataEClass, AIR_QUALITY_DATA__TIMESTAMP);
		createEReference(airQualityDataEClass, AIR_QUALITY_DATA__SCD40);
		createEReference(airQualityDataEClass, AIR_QUALITY_DATA__SHT30);
		createEReference(airQualityDataEClass, AIR_QUALITY_DATA__PIR);
		createEReference(airQualityDataEClass, AIR_QUALITY_DATA__SEN55);
		createEReference(airQualityDataEClass, AIR_QUALITY_DATA__STATUS);
		createEReference(airQualityDataEClass, AIR_QUALITY_DATA__QMP6988);

		scd40EClass = createEClass(SCD40);
		createEAttribute(scd40EClass, SCD40__TEMPERATURE);
		createEAttribute(scd40EClass, SCD40__HUMIDITY);
		createEAttribute(scd40EClass, SCD40__CO2);

		sht30EClass = createEClass(SHT30);
		createEAttribute(sht30EClass, SHT30__TEMPERATURE);
		createEAttribute(sht30EClass, SHT30__HUMIDITY);

		pirEClass = createEClass(PIR);
		createEAttribute(pirEClass, PIR__MOTION_DETECTED);

		sen55EClass = createEClass(SEN55);
		createEAttribute(sen55EClass, SEN55__PM2P5);
		createEAttribute(sen55EClass, SEN55__PM10P0);
		createEAttribute(sen55EClass, SEN55__TEMPERATURE);
		createEAttribute(sen55EClass, SEN55__PM4P0);
		createEAttribute(sen55EClass, SEN55__HUMIDITY);
		createEAttribute(sen55EClass, SEN55__NOX_INDEX);
		createEAttribute(sen55EClass, SEN55__PM1P0);
		createEAttribute(sen55EClass, SEN55__VOC_INDEX);

		statusEClass = createEClass(STATUS);
		createEAttribute(statusEClass, STATUS__CONNECTED);
		createEAttribute(statusEClass, STATUS__UPTIME);

		qmp6988EClass = createEClass(QMP6988);
		createEAttribute(qmp6988EClass, QMP6988__PRESSURE);
		createEAttribute(qmp6988EClass, QMP6988__PRESSURE_HPA);
		createEAttribute(qmp6988EClass, QMP6988__TEMPERATURE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		LoRaWANPackage theLoRaWANPackage = (LoRaWANPackage)EPackage.Registry.INSTANCE.getEPackage(LoRaWANPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		airQualitySensorEClass.getESuperTypes().add(theLoRaWANPackage.getUplinkMessage());

		// Initialize classes, features, and operations; add parameters
		initEClass(airQualitySensorEClass, AirQualitySensor.class, "AirQualitySensor", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getAirQualitySensor_Object(), this.getAirQualityData(), null, "object", null, 0, 1, AirQualitySensor.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(airQualityDataEClass, AirQualityData.class, "AirQualityData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAirQualityData_Timestamp(), ecorePackage.getEString(), "timestamp", null, 0, 1, AirQualityData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAirQualityData_Scd40(), this.getSCD40(), null, "scd40", null, 0, 1, AirQualityData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAirQualityData_Sht30(), this.getSHT30(), null, "sht30", null, 0, 1, AirQualityData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAirQualityData_Pir(), this.getPIR(), null, "pir", null, 0, 1, AirQualityData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAirQualityData_Sen55(), this.getSEN55(), null, "sen55", null, 0, 1, AirQualityData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAirQualityData_Status(), this.getStatus(), null, "status", null, 0, 1, AirQualityData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAirQualityData_Qmp6988(), this.getQMP6988(), null, "qmp6988", null, 0, 1, AirQualityData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(scd40EClass, org.gecko.mac.airquality.SCD40.class, "SCD40", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSCD40_Temperature(), ecorePackage.getEDouble(), "temperature", null, 0, 1, org.gecko.mac.airquality.SCD40.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSCD40_Humidity(), ecorePackage.getEDouble(), "humidity", null, 0, 1, org.gecko.mac.airquality.SCD40.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSCD40_Co2(), ecorePackage.getEInt(), "co2", null, 0, 1, org.gecko.mac.airquality.SCD40.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sht30EClass, org.gecko.mac.airquality.SHT30.class, "SHT30", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSHT30_Temperature(), ecorePackage.getEDouble(), "temperature", null, 0, 1, org.gecko.mac.airquality.SHT30.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSHT30_Humidity(), ecorePackage.getEDouble(), "humidity", null, 0, 1, org.gecko.mac.airquality.SHT30.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(pirEClass, org.gecko.mac.airquality.PIR.class, "PIR", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPIR_Motion_detected(), ecorePackage.getEBoolean(), "motion_detected", null, 0, 1, org.gecko.mac.airquality.PIR.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(sen55EClass, org.gecko.mac.airquality.SEN55.class, "SEN55", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getSEN55_Pm2p5(), ecorePackage.getEDouble(), "pm2p5", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSEN55_Pm10p0(), ecorePackage.getEDouble(), "pm10p0", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSEN55_Temperature(), ecorePackage.getEDouble(), "temperature", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSEN55_Pm4p0(), ecorePackage.getEDouble(), "pm4p0", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSEN55_Humidity(), ecorePackage.getEDouble(), "humidity", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSEN55_Nox_index(), ecorePackage.getEDouble(), "nox_index", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSEN55_Pm1p0(), ecorePackage.getEDouble(), "pm1p0", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getSEN55_Voc_index(), ecorePackage.getEDouble(), "voc_index", null, 0, 1, org.gecko.mac.airquality.SEN55.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(statusEClass, Status.class, "Status", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getStatus_Connected(), ecorePackage.getEBoolean(), "connected", null, 0, 1, Status.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getStatus_Uptime(), ecorePackage.getEDouble(), "uptime", null, 0, 1, Status.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(qmp6988EClass, org.gecko.mac.airquality.QMP6988.class, "QMP6988", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getQMP6988_Pressure(), ecorePackage.getEDouble(), "pressure", null, 0, 1, org.gecko.mac.airquality.QMP6988.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getQMP6988_Pressure_hpa(), ecorePackage.getEDouble(), "pressure_hpa", null, 0, 1, org.gecko.mac.airquality.QMP6988.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getQMP6988_Temperature(), ecorePackage.getEDouble(), "temperature", null, 0, 1, org.gecko.mac.airquality.QMP6988.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// codec.type
		createCodecAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "oSGiCompatible", "true",
			   "resource", "XMI",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motioni - initial API and implementation",
			   "basePackage", "org.gecko.mac"
		   });
	}

	/**
	 * Initializes the annotations for <b>codec.type</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createCodecAnnotations() {
		String source = "codec.type";
		addAnnotation
		  (airQualitySensorEClass,
		   source,
		   new String[] {
			   "M5AirQ", "AirQualitySensor"
		   });
	}

} //AirQualityPackageImpl
