/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.airquality.AirQualityPackage;
import org.gecko.mac.airquality.QMP6988;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>QMP6988</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.airquality.impl.QMP6988Impl#getPressure <em>Pressure</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.QMP6988Impl#getPressure_hpa <em>Pressure hpa</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.QMP6988Impl#getTemperature <em>Temperature</em>}</li>
 * </ul>
 *
 * @generated
 */
public class QMP6988Impl extends MinimalEObjectImpl.Container implements QMP6988 {
	/**
	 * The default value of the '{@link #getPressure() <em>Pressure</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPressure()
	 * @generated
	 * @ordered
	 */
	protected static final double PRESSURE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getPressure() <em>Pressure</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPressure()
	 * @generated
	 * @ordered
	 */
	protected double pressure = PRESSURE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPressure_hpa() <em>Pressure hpa</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPressure_hpa()
	 * @generated
	 * @ordered
	 */
	protected static final double PRESSURE_HPA_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getPressure_hpa() <em>Pressure hpa</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPressure_hpa()
	 * @generated
	 * @ordered
	 */
	protected double pressure_hpa = PRESSURE_HPA_EDEFAULT;

	/**
	 * The default value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected static final double TEMPERATURE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected double temperature = TEMPERATURE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QMP6988Impl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AirQualityPackage.Literals.QMP6988;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getPressure() {
		return pressure;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPressure(double newPressure) {
		double oldPressure = pressure;
		pressure = newPressure;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.QMP6988__PRESSURE, oldPressure, pressure));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getPressure_hpa() {
		return pressure_hpa;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPressure_hpa(double newPressure_hpa) {
		double oldPressure_hpa = pressure_hpa;
		pressure_hpa = newPressure_hpa;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.QMP6988__PRESSURE_HPA, oldPressure_hpa, pressure_hpa));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTemperature() {
		return temperature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTemperature(double newTemperature) {
		double oldTemperature = temperature;
		temperature = newTemperature;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.QMP6988__TEMPERATURE, oldTemperature, temperature));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AirQualityPackage.QMP6988__PRESSURE:
				return getPressure();
			case AirQualityPackage.QMP6988__PRESSURE_HPA:
				return getPressure_hpa();
			case AirQualityPackage.QMP6988__TEMPERATURE:
				return getTemperature();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AirQualityPackage.QMP6988__PRESSURE:
				setPressure((Double)newValue);
				return;
			case AirQualityPackage.QMP6988__PRESSURE_HPA:
				setPressure_hpa((Double)newValue);
				return;
			case AirQualityPackage.QMP6988__TEMPERATURE:
				setTemperature((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AirQualityPackage.QMP6988__PRESSURE:
				setPressure(PRESSURE_EDEFAULT);
				return;
			case AirQualityPackage.QMP6988__PRESSURE_HPA:
				setPressure_hpa(PRESSURE_HPA_EDEFAULT);
				return;
			case AirQualityPackage.QMP6988__TEMPERATURE:
				setTemperature(TEMPERATURE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AirQualityPackage.QMP6988__PRESSURE:
				return pressure != PRESSURE_EDEFAULT;
			case AirQualityPackage.QMP6988__PRESSURE_HPA:
				return pressure_hpa != PRESSURE_HPA_EDEFAULT;
			case AirQualityPackage.QMP6988__TEMPERATURE:
				return temperature != TEMPERATURE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (pressure: ");
		result.append(pressure);
		result.append(", pressure_hpa: ");
		result.append(pressure_hpa);
		result.append(", temperature: ");
		result.append(temperature);
		result.append(')');
		return result.toString();
	}

} //QMP6988Impl
