/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.airquality.AirQualityPackage;
import org.gecko.mac.airquality.SCD40;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SCD40</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.airquality.impl.SCD40Impl#getTemperature <em>Temperature</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SCD40Impl#getHumidity <em>Humidity</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SCD40Impl#getCo2 <em>Co2</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SCD40Impl extends MinimalEObjectImpl.Container implements SCD40 {
	/**
	 * The default value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected static final double TEMPERATURE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected double temperature = TEMPERATURE_EDEFAULT;

	/**
	 * The default value of the '{@link #getHumidity() <em>Humidity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHumidity()
	 * @generated
	 * @ordered
	 */
	protected static final double HUMIDITY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getHumidity() <em>Humidity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHumidity()
	 * @generated
	 * @ordered
	 */
	protected double humidity = HUMIDITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getCo2() <em>Co2</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCo2()
	 * @generated
	 * @ordered
	 */
	protected static final int CO2_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getCo2() <em>Co2</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCo2()
	 * @generated
	 * @ordered
	 */
	protected int co2 = CO2_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SCD40Impl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AirQualityPackage.Literals.SCD40;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTemperature() {
		return temperature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTemperature(double newTemperature) {
		double oldTemperature = temperature;
		temperature = newTemperature;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SCD40__TEMPERATURE, oldTemperature, temperature));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getHumidity() {
		return humidity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHumidity(double newHumidity) {
		double oldHumidity = humidity;
		humidity = newHumidity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SCD40__HUMIDITY, oldHumidity, humidity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getCo2() {
		return co2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCo2(int newCo2) {
		int oldCo2 = co2;
		co2 = newCo2;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SCD40__CO2, oldCo2, co2));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AirQualityPackage.SCD40__TEMPERATURE:
				return getTemperature();
			case AirQualityPackage.SCD40__HUMIDITY:
				return getHumidity();
			case AirQualityPackage.SCD40__CO2:
				return getCo2();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AirQualityPackage.SCD40__TEMPERATURE:
				setTemperature((Double)newValue);
				return;
			case AirQualityPackage.SCD40__HUMIDITY:
				setHumidity((Double)newValue);
				return;
			case AirQualityPackage.SCD40__CO2:
				setCo2((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AirQualityPackage.SCD40__TEMPERATURE:
				setTemperature(TEMPERATURE_EDEFAULT);
				return;
			case AirQualityPackage.SCD40__HUMIDITY:
				setHumidity(HUMIDITY_EDEFAULT);
				return;
			case AirQualityPackage.SCD40__CO2:
				setCo2(CO2_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AirQualityPackage.SCD40__TEMPERATURE:
				return temperature != TEMPERATURE_EDEFAULT;
			case AirQualityPackage.SCD40__HUMIDITY:
				return humidity != HUMIDITY_EDEFAULT;
			case AirQualityPackage.SCD40__CO2:
				return co2 != CO2_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (temperature: ");
		result.append(temperature);
		result.append(", humidity: ");
		result.append(humidity);
		result.append(", co2: ");
		result.append(co2);
		result.append(')');
		return result.toString();
	}

} //SCD40Impl
