/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.airquality.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.airquality.AirQualityPackage;
import org.gecko.mac.airquality.SEN55;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>SEN55</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getPm2p5 <em>Pm2p5</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getPm10p0 <em>Pm10p0</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getTemperature <em>Temperature</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getPm4p0 <em>Pm4p0</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getHumidity <em>Humidity</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getNox_index <em>Nox index</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getPm1p0 <em>Pm1p0</em>}</li>
 *   <li>{@link org.gecko.mac.airquality.impl.SEN55Impl#getVoc_index <em>Voc index</em>}</li>
 * </ul>
 *
 * @generated
 */
public class SEN55Impl extends MinimalEObjectImpl.Container implements SEN55 {
	/**
	 * The default value of the '{@link #getPm2p5() <em>Pm2p5</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm2p5()
	 * @generated
	 * @ordered
	 */
	protected static final double PM2P5_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getPm2p5() <em>Pm2p5</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm2p5()
	 * @generated
	 * @ordered
	 */
	protected double pm2p5 = PM2P5_EDEFAULT;

	/**
	 * The default value of the '{@link #getPm10p0() <em>Pm10p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm10p0()
	 * @generated
	 * @ordered
	 */
	protected static final double PM10P0_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getPm10p0() <em>Pm10p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm10p0()
	 * @generated
	 * @ordered
	 */
	protected double pm10p0 = PM10P0_EDEFAULT;

	/**
	 * The default value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected static final double TEMPERATURE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTemperature() <em>Temperature</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTemperature()
	 * @generated
	 * @ordered
	 */
	protected double temperature = TEMPERATURE_EDEFAULT;

	/**
	 * The default value of the '{@link #getPm4p0() <em>Pm4p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm4p0()
	 * @generated
	 * @ordered
	 */
	protected static final double PM4P0_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getPm4p0() <em>Pm4p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm4p0()
	 * @generated
	 * @ordered
	 */
	protected double pm4p0 = PM4P0_EDEFAULT;

	/**
	 * The default value of the '{@link #getHumidity() <em>Humidity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHumidity()
	 * @generated
	 * @ordered
	 */
	protected static final double HUMIDITY_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getHumidity() <em>Humidity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHumidity()
	 * @generated
	 * @ordered
	 */
	protected double humidity = HUMIDITY_EDEFAULT;

	/**
	 * The default value of the '{@link #getNox_index() <em>Nox index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNox_index()
	 * @generated
	 * @ordered
	 */
	protected static final double NOX_INDEX_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getNox_index() <em>Nox index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNox_index()
	 * @generated
	 * @ordered
	 */
	protected double nox_index = NOX_INDEX_EDEFAULT;

	/**
	 * The default value of the '{@link #getPm1p0() <em>Pm1p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm1p0()
	 * @generated
	 * @ordered
	 */
	protected static final double PM1P0_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getPm1p0() <em>Pm1p0</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPm1p0()
	 * @generated
	 * @ordered
	 */
	protected double pm1p0 = PM1P0_EDEFAULT;

	/**
	 * The default value of the '{@link #getVoc_index() <em>Voc index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVoc_index()
	 * @generated
	 * @ordered
	 */
	protected static final double VOC_INDEX_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getVoc_index() <em>Voc index</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVoc_index()
	 * @generated
	 * @ordered
	 */
	protected double voc_index = VOC_INDEX_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SEN55Impl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AirQualityPackage.Literals.SEN55;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getPm2p5() {
		return pm2p5;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPm2p5(double newPm2p5) {
		double oldPm2p5 = pm2p5;
		pm2p5 = newPm2p5;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__PM2P5, oldPm2p5, pm2p5));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getPm10p0() {
		return pm10p0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPm10p0(double newPm10p0) {
		double oldPm10p0 = pm10p0;
		pm10p0 = newPm10p0;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__PM10P0, oldPm10p0, pm10p0));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTemperature() {
		return temperature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTemperature(double newTemperature) {
		double oldTemperature = temperature;
		temperature = newTemperature;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__TEMPERATURE, oldTemperature, temperature));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getPm4p0() {
		return pm4p0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPm4p0(double newPm4p0) {
		double oldPm4p0 = pm4p0;
		pm4p0 = newPm4p0;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__PM4P0, oldPm4p0, pm4p0));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getHumidity() {
		return humidity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHumidity(double newHumidity) {
		double oldHumidity = humidity;
		humidity = newHumidity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__HUMIDITY, oldHumidity, humidity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getNox_index() {
		return nox_index;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setNox_index(double newNox_index) {
		double oldNox_index = nox_index;
		nox_index = newNox_index;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__NOX_INDEX, oldNox_index, nox_index));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getPm1p0() {
		return pm1p0;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPm1p0(double newPm1p0) {
		double oldPm1p0 = pm1p0;
		pm1p0 = newPm1p0;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__PM1P0, oldPm1p0, pm1p0));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getVoc_index() {
		return voc_index;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVoc_index(double newVoc_index) {
		double oldVoc_index = voc_index;
		voc_index = newVoc_index;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AirQualityPackage.SEN55__VOC_INDEX, oldVoc_index, voc_index));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AirQualityPackage.SEN55__PM2P5:
				return getPm2p5();
			case AirQualityPackage.SEN55__PM10P0:
				return getPm10p0();
			case AirQualityPackage.SEN55__TEMPERATURE:
				return getTemperature();
			case AirQualityPackage.SEN55__PM4P0:
				return getPm4p0();
			case AirQualityPackage.SEN55__HUMIDITY:
				return getHumidity();
			case AirQualityPackage.SEN55__NOX_INDEX:
				return getNox_index();
			case AirQualityPackage.SEN55__PM1P0:
				return getPm1p0();
			case AirQualityPackage.SEN55__VOC_INDEX:
				return getVoc_index();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AirQualityPackage.SEN55__PM2P5:
				setPm2p5((Double)newValue);
				return;
			case AirQualityPackage.SEN55__PM10P0:
				setPm10p0((Double)newValue);
				return;
			case AirQualityPackage.SEN55__TEMPERATURE:
				setTemperature((Double)newValue);
				return;
			case AirQualityPackage.SEN55__PM4P0:
				setPm4p0((Double)newValue);
				return;
			case AirQualityPackage.SEN55__HUMIDITY:
				setHumidity((Double)newValue);
				return;
			case AirQualityPackage.SEN55__NOX_INDEX:
				setNox_index((Double)newValue);
				return;
			case AirQualityPackage.SEN55__PM1P0:
				setPm1p0((Double)newValue);
				return;
			case AirQualityPackage.SEN55__VOC_INDEX:
				setVoc_index((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AirQualityPackage.SEN55__PM2P5:
				setPm2p5(PM2P5_EDEFAULT);
				return;
			case AirQualityPackage.SEN55__PM10P0:
				setPm10p0(PM10P0_EDEFAULT);
				return;
			case AirQualityPackage.SEN55__TEMPERATURE:
				setTemperature(TEMPERATURE_EDEFAULT);
				return;
			case AirQualityPackage.SEN55__PM4P0:
				setPm4p0(PM4P0_EDEFAULT);
				return;
			case AirQualityPackage.SEN55__HUMIDITY:
				setHumidity(HUMIDITY_EDEFAULT);
				return;
			case AirQualityPackage.SEN55__NOX_INDEX:
				setNox_index(NOX_INDEX_EDEFAULT);
				return;
			case AirQualityPackage.SEN55__PM1P0:
				setPm1p0(PM1P0_EDEFAULT);
				return;
			case AirQualityPackage.SEN55__VOC_INDEX:
				setVoc_index(VOC_INDEX_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AirQualityPackage.SEN55__PM2P5:
				return pm2p5 != PM2P5_EDEFAULT;
			case AirQualityPackage.SEN55__PM10P0:
				return pm10p0 != PM10P0_EDEFAULT;
			case AirQualityPackage.SEN55__TEMPERATURE:
				return temperature != TEMPERATURE_EDEFAULT;
			case AirQualityPackage.SEN55__PM4P0:
				return pm4p0 != PM4P0_EDEFAULT;
			case AirQualityPackage.SEN55__HUMIDITY:
				return humidity != HUMIDITY_EDEFAULT;
			case AirQualityPackage.SEN55__NOX_INDEX:
				return nox_index != NOX_INDEX_EDEFAULT;
			case AirQualityPackage.SEN55__PM1P0:
				return pm1p0 != PM1P0_EDEFAULT;
			case AirQualityPackage.SEN55__VOC_INDEX:
				return voc_index != VOC_INDEX_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (pm2p5: ");
		result.append(pm2p5);
		result.append(", pm10p0: ");
		result.append(pm10p0);
		result.append(", temperature: ");
		result.append(temperature);
		result.append(", pm4p0: ");
		result.append(pm4p0);
		result.append(", humidity: ");
		result.append(humidity);
		result.append(", nox_index: ");
		result.append(nox_index);
		result.append(", pm1p0: ");
		result.append(pm1p0);
		result.append(", voc_index: ");
		result.append(voc_index);
		result.append(')');
		return result.toString();
	}

} //SEN55Impl
