/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Action Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.gecko.mac.audit.AuditPackage#getActionType()
 * @model
 * @generated
 */
@ProviderType
public enum ActionType implements Enumerator {
	/**
	 * The '<em><b>RECEIVED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RECEIVED_VALUE
	 * @generated
	 * @ordered
	 */
	RECEIVED(0, "RECEIVED", "RECEIVED"),

	/**
	 * The '<em><b>LOADED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LOADED_VALUE
	 * @generated
	 * @ordered
	 */
	LOADED(1, "LOADED", "LOADED"),

	/**
	 * The '<em><b>GENERATED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GENERATED_VALUE
	 * @generated
	 * @ordered
	 */
	GENERATED(2, "GENERATED", "GENERATED"),

	/**
	 * The '<em><b>MAPPED TO SENSINACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MAPPED_TO_SENSINACT_VALUE
	 * @generated
	 * @ordered
	 */
	MAPPED_TO_SENSINACT(3, "MAPPED_TO_SENSINACT", "MAPPED_TO_SENSINACT"),

	/**
	 * The '<em><b>APPROVED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #APPROVED_VALUE
	 * @generated
	 * @ordered
	 */
	APPROVED(4, "APPROVED", "APPROVED"),

	/**
	 * The '<em><b>REJECTED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REJECTED_VALUE
	 * @generated
	 * @ordered
	 */
	REJECTED(5, "REJECTED", "REJECTED"),

	/**
	 * The '<em><b>DRAFT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DRAFT_VALUE
	 * @generated
	 * @ordered
	 */
	DRAFT(6, "DRAFT", "DRAFT"),

	/**
	 * The '<em><b>IN REVIEW</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IN_REVIEW_VALUE
	 * @generated
	 * @ordered
	 */
	IN_REVIEW(7, "IN_REVIEW", "IN_REVIEW"),

	/**
	 * The '<em><b>FAILURE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FAILURE_VALUE
	 * @generated
	 * @ordered
	 */
	FAILURE(8, "FAILURE", "FAILURE"),

	/**
	 * The '<em><b>SESSION STARTED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SESSION_STARTED_VALUE
	 * @generated
	 * @ordered
	 */
	SESSION_STARTED(9, "SESSION_STARTED", "SESSION_STARTED"),

	/**
	 * The '<em><b>SESSION COMPLETED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SESSION_COMPLETED_VALUE
	 * @generated
	 * @ordered
	 */
	SESSION_COMPLETED(10, "SESSION_COMPLETED", "SESSION_COMPLETED"),

	/**
	 * The '<em><b>SESSION CHECKPOINT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SESSION_CHECKPOINT_VALUE
	 * @generated
	 * @ordered
	 */
	SESSION_CHECKPOINT(11, "SESSION_CHECKPOINT", "SESSION_CHECKPOINT"),

	/**
	 * The '<em><b>SERVICE METHOD CALL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * OSGi service method call through proxy
	 * <!-- end-model-doc -->
	 * @see #SERVICE_METHOD_CALL_VALUE
	 * @generated
	 * @ordered
	 */
	SERVICE_METHOD_CALL(12, "SERVICE_METHOD_CALL", "SERVICE_METHOD_CALL");

	/**
	 * The '<em><b>RECEIVED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RECEIVED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RECEIVED_VALUE = 0;

	/**
	 * The '<em><b>LOADED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LOADED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LOADED_VALUE = 1;

	/**
	 * The '<em><b>GENERATED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GENERATED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GENERATED_VALUE = 2;

	/**
	 * The '<em><b>MAPPED TO SENSINACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MAPPED_TO_SENSINACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MAPPED_TO_SENSINACT_VALUE = 3;

	/**
	 * The '<em><b>APPROVED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #APPROVED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int APPROVED_VALUE = 4;

	/**
	 * The '<em><b>REJECTED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REJECTED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int REJECTED_VALUE = 5;

	/**
	 * The '<em><b>DRAFT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DRAFT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DRAFT_VALUE = 6;

	/**
	 * The '<em><b>IN REVIEW</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IN_REVIEW
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int IN_REVIEW_VALUE = 7;

	/**
	 * The '<em><b>FAILURE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FAILURE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FAILURE_VALUE = 8;

	/**
	 * The '<em><b>SESSION STARTED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SESSION_STARTED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SESSION_STARTED_VALUE = 9;

	/**
	 * The '<em><b>SESSION COMPLETED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SESSION_COMPLETED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SESSION_COMPLETED_VALUE = 10;

	/**
	 * The '<em><b>SESSION CHECKPOINT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SESSION_CHECKPOINT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SESSION_CHECKPOINT_VALUE = 11;

	/**
	 * The '<em><b>SERVICE METHOD CALL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * OSGi service method call through proxy
	 * <!-- end-model-doc -->
	 * @see #SERVICE_METHOD_CALL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SERVICE_METHOD_CALL_VALUE = 12;

	/**
	 * An array of all the '<em><b>Action Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ActionType[] VALUES_ARRAY =
		new ActionType[] {
			RECEIVED,
			LOADED,
			GENERATED,
			MAPPED_TO_SENSINACT,
			APPROVED,
			REJECTED,
			DRAFT,
			IN_REVIEW,
			FAILURE,
			SESSION_STARTED,
			SESSION_COMPLETED,
			SESSION_CHECKPOINT,
			SERVICE_METHOD_CALL,
		};

	/**
	 * A public read-only list of all the '<em><b>Action Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ActionType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Action Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ActionType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActionType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Action Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ActionType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActionType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Action Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ActionType get(int value) {
		switch (value) {
			case RECEIVED_VALUE: return RECEIVED;
			case LOADED_VALUE: return LOADED;
			case GENERATED_VALUE: return GENERATED;
			case MAPPED_TO_SENSINACT_VALUE: return MAPPED_TO_SENSINACT;
			case APPROVED_VALUE: return APPROVED;
			case REJECTED_VALUE: return REJECTED;
			case DRAFT_VALUE: return DRAFT;
			case IN_REVIEW_VALUE: return IN_REVIEW;
			case FAILURE_VALUE: return FAILURE;
			case SESSION_STARTED_VALUE: return SESSION_STARTED;
			case SESSION_COMPLETED_VALUE: return SESSION_COMPLETED;
			case SESSION_CHECKPOINT_VALUE: return SESSION_CHECKPOINT;
			case SERVICE_METHOD_CALL_VALUE: return SERVICE_METHOD_CALL;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ActionType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ActionType
