/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit;

import java.time.Instant;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Event Data</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Individual audit event within a process session
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getSessionId <em>Session Id</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getEventType <em>Event Type</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getCheckpoint <em>Checkpoint</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getDetails <em>Details</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getThreadId <em>Thread Id</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getDurationNs <em>Duration Ns</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getException <em>Exception</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getEventContext <em>Event Context</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditEventData#getAudit <em>Audit</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData()
 * @model
 * @generated
 */
@ProviderType
public interface AuditEventData extends EObject {
	/**
	 * Returns the value of the '<em><b>Session Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Reference to parent session ID
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Session Id</em>' attribute.
	 * @see #setSessionId(String)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_SessionId()
	 * @model required="true"
	 * @generated
	 */
	String getSessionId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getSessionId <em>Session Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Session Id</em>' attribute.
	 * @see #getSessionId()
	 * @generated
	 */
	void setSessionId(String value);

	/**
	 * Returns the value of the '<em><b>Event Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.mac.audit.EventType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Type of audit event
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Event Type</em>' attribute.
	 * @see org.gecko.mac.audit.EventType
	 * @see #setEventType(EventType)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_EventType()
	 * @model required="true"
	 * @generated
	 */
	EventType getEventType();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getEventType <em>Event Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Event Type</em>' attribute.
	 * @see org.gecko.mac.audit.EventType
	 * @see #getEventType()
	 * @generated
	 */
	void setEventType(EventType value);

	/**
	 * Returns the value of the '<em><b>Checkpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Checkpoint or method name
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Checkpoint</em>' attribute.
	 * @see #setCheckpoint(String)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_Checkpoint()
	 * @model required="true"
	 * @generated
	 */
	String getCheckpoint();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getCheckpoint <em>Checkpoint</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Checkpoint</em>' attribute.
	 * @see #getCheckpoint()
	 * @generated
	 */
	void setCheckpoint(String value);

	/**
	 * Returns the value of the '<em><b>Details</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Additional event details
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Details</em>' attribute.
	 * @see #setDetails(String)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_Details()
	 * @model
	 * @generated
	 */
	String getDetails();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getDetails <em>Details</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Details</em>' attribute.
	 * @see #getDetails()
	 * @generated
	 */
	void setDetails(String value);

	/**
	 * Returns the value of the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Event timestamp
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Timestamp</em>' attribute.
	 * @see #setTimestamp(Instant)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_Timestamp()
	 * @model dataType="org.gecko.mac.audit.Instant" required="true"
	 * @generated
	 */
	Instant getTimestamp();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getTimestamp <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Timestamp</em>' attribute.
	 * @see #getTimestamp()
	 * @generated
	 */
	void setTimestamp(Instant value);

	/**
	 * Returns the value of the '<em><b>Thread Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Thread ID where event occurred
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Thread Id</em>' attribute.
	 * @see #setThreadId(long)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_ThreadId()
	 * @model required="true"
	 * @generated
	 */
	long getThreadId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getThreadId <em>Thread Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Thread Id</em>' attribute.
	 * @see #getThreadId()
	 * @generated
	 */
	void setThreadId(long value);

	/**
	 * Returns the value of the '<em><b>Duration Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Duration in nanoseconds (for method calls)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Duration Ns</em>' attribute.
	 * @see #setDurationNs(Long)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_DurationNs()
	 * @model
	 * @generated
	 */
	Long getDurationNs();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getDurationNs <em>Duration Ns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Duration Ns</em>' attribute.
	 * @see #getDurationNs()
	 * @generated
	 */
	void setDurationNs(Long value);

	/**
	 * Returns the value of the '<em><b>Exception</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Exception message if error occurred
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Exception</em>' attribute.
	 * @see #setException(String)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_Exception()
	 * @model
	 * @generated
	 */
	String getException();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getException <em>Exception</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Exception</em>' attribute.
	 * @see #getException()
	 * @generated
	 */
	void setException(String value);

	/**
	 * Returns the value of the '<em><b>Event Context</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link java.lang.String},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Context snapshot at time of event
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Event Context</em>' map.
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_EventContext()
	 * @model mapType="org.gecko.mac.audit.ContextEntry&lt;org.eclipse.emf.ecore.EString, org.eclipse.emf.ecore.EString&gt;"
	 * @generated
	 */
	EMap<String, String> getEventContext();

	/**
	 * Returns the value of the '<em><b>Audit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Audit</em>' containment reference.
	 * @see #setAudit(Audit)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditEventData_Audit()
	 * @model containment="true"
	 * @generated
	 */
	Audit getAudit();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditEventData#getAudit <em>Audit</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Audit</em>' containment reference.
	 * @see #getAudit()
	 * @generated
	 */
	void setAudit(Audit value);

} // AuditEventData
