/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EReference;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.audit.AuditFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation' resource='XMI' oSGiCompatible='true' basePackage='org.gecko.mac'"
 * @generated
 */
@ProviderType
@EPackage(uri = AuditPackage.eNS_URI, genModel = "/model/audit.genmodel", genModelSourceLocations = {"model/audit.genmodel","org.gecko.mac.audit.model/model/audit.genmodel"}, ecore="/model/audit.ecore", ecoreSourceLocations="/model/audit.ecore")
public interface AuditPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "audit";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://datainmotion.com/mac/audit/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "audit";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AuditPackage eINSTANCE = org.gecko.mac.audit.impl.AuditPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.audit.impl.AuditImpl <em>Audit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.audit.impl.AuditImpl
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getAudit()
	 * @generated
	 */
	int AUDIT = 0;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT__TIMESTAMP = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT__ID = 1;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT__SOURCE = 2;

	/**
	 * The feature id for the '<em><b>Message</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT__MESSAGE = 3;

	/**
	 * The feature id for the '<em><b>Action</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT__ACTION = 4;

	/**
	 * The feature id for the '<em><b>Category</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT__CATEGORY = 5;

	/**
	 * The number of structural features of the '<em>Audit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Audit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.audit.impl.AuditSessionDataImpl <em>Session Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.audit.impl.AuditSessionDataImpl
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getAuditSessionData()
	 * @generated
	 */
	int AUDIT_SESSION_DATA = 1;

	/**
	 * The feature id for the '<em><b>Session Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA__SESSION_ID = 0;

	/**
	 * The feature id for the '<em><b>Process Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA__PROCESS_NAME = 1;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA__START_TIME = 2;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA__ACTIVE = 3;

	/**
	 * The feature id for the '<em><b>Context</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA__CONTEXT = 4;

	/**
	 * The feature id for the '<em><b>Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA__EVENTS = 5;

	/**
	 * The number of structural features of the '<em>Session Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA_FEATURE_COUNT = 6;

	/**
	 * The number of operations of the '<em>Session Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_SESSION_DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.audit.impl.AuditEventDataImpl <em>Event Data</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.audit.impl.AuditEventDataImpl
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getAuditEventData()
	 * @generated
	 */
	int AUDIT_EVENT_DATA = 2;

	/**
	 * The feature id for the '<em><b>Session Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__SESSION_ID = 0;

	/**
	 * The feature id for the '<em><b>Event Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__EVENT_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Checkpoint</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__CHECKPOINT = 2;

	/**
	 * The feature id for the '<em><b>Details</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__DETAILS = 3;

	/**
	 * The feature id for the '<em><b>Timestamp</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__TIMESTAMP = 4;

	/**
	 * The feature id for the '<em><b>Thread Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__THREAD_ID = 5;

	/**
	 * The feature id for the '<em><b>Duration Ns</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__DURATION_NS = 6;

	/**
	 * The feature id for the '<em><b>Exception</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__EXCEPTION = 7;

	/**
	 * The feature id for the '<em><b>Event Context</b></em>' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__EVENT_CONTEXT = 8;

	/**
	 * The feature id for the '<em><b>Audit</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA__AUDIT = 9;

	/**
	 * The number of structural features of the '<em>Event Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA_FEATURE_COUNT = 10;

	/**
	 * The number of operations of the '<em>Event Data</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int AUDIT_EVENT_DATA_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.audit.impl.ContextEntryImpl <em>Context Entry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.audit.impl.ContextEntryImpl
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getContextEntry()
	 * @generated
	 */
	int CONTEXT_ENTRY = 3;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_ENTRY__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_ENTRY__VALUE = 1;

	/**
	 * The number of structural features of the '<em>Context Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_ENTRY_FEATURE_COUNT = 2;

	/**
	 * The number of operations of the '<em>Context Entry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONTEXT_ENTRY_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.audit.ActionType <em>Action Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.audit.ActionType
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getActionType()
	 * @generated
	 */
	int ACTION_TYPE = 4;

	/**
	 * The meta object id for the '{@link org.gecko.mac.audit.CategoryType <em>Category Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.audit.CategoryType
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getCategoryType()
	 * @generated
	 */
	int CATEGORY_TYPE = 5;

	/**
	 * The meta object id for the '{@link org.gecko.mac.audit.EventType <em>Event Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.audit.EventType
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getEventType()
	 * @generated
	 */
	int EVENT_TYPE = 6;

	/**
	 * The meta object id for the '<em>Instant</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.time.Instant
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getInstant()
	 * @generated
	 */
	int INSTANT = 7;

	/**
	 * The meta object id for the '<em>Throwable</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.lang.Throwable
	 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getThrowable()
	 * @generated
	 */
	int THROWABLE = 8;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.audit.Audit <em>Audit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Audit</em>'.
	 * @see org.gecko.mac.audit.Audit
	 * @generated
	 */
	EClass getAudit();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.Audit#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.mac.audit.Audit#getTimestamp()
	 * @see #getAudit()
	 * @generated
	 */
	EAttribute getAudit_Timestamp();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.Audit#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.mac.audit.Audit#getId()
	 * @see #getAudit()
	 * @generated
	 */
	EAttribute getAudit_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.Audit#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Source</em>'.
	 * @see org.gecko.mac.audit.Audit#getSource()
	 * @see #getAudit()
	 * @generated
	 */
	EAttribute getAudit_Source();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.Audit#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Message</em>'.
	 * @see org.gecko.mac.audit.Audit#getMessage()
	 * @see #getAudit()
	 * @generated
	 */
	EAttribute getAudit_Message();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.Audit#getAction <em>Action</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Action</em>'.
	 * @see org.gecko.mac.audit.Audit#getAction()
	 * @see #getAudit()
	 * @generated
	 */
	EAttribute getAudit_Action();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.Audit#getCategory <em>Category</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Category</em>'.
	 * @see org.gecko.mac.audit.Audit#getCategory()
	 * @see #getAudit()
	 * @generated
	 */
	EAttribute getAudit_Category();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.audit.AuditSessionData <em>Session Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Session Data</em>'.
	 * @see org.gecko.mac.audit.AuditSessionData
	 * @generated
	 */
	EClass getAuditSessionData();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditSessionData#getSessionId <em>Session Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Session Id</em>'.
	 * @see org.gecko.mac.audit.AuditSessionData#getSessionId()
	 * @see #getAuditSessionData()
	 * @generated
	 */
	EAttribute getAuditSessionData_SessionId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditSessionData#getProcessName <em>Process Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Process Name</em>'.
	 * @see org.gecko.mac.audit.AuditSessionData#getProcessName()
	 * @see #getAuditSessionData()
	 * @generated
	 */
	EAttribute getAuditSessionData_ProcessName();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditSessionData#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see org.gecko.mac.audit.AuditSessionData#getStartTime()
	 * @see #getAuditSessionData()
	 * @generated
	 */
	EAttribute getAuditSessionData_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditSessionData#isActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see org.gecko.mac.audit.AuditSessionData#isActive()
	 * @see #getAuditSessionData()
	 * @generated
	 */
	EAttribute getAuditSessionData_Active();

	/**
	 * Returns the meta object for the map '{@link org.gecko.mac.audit.AuditSessionData#getContext <em>Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Context</em>'.
	 * @see org.gecko.mac.audit.AuditSessionData#getContext()
	 * @see #getAuditSessionData()
	 * @generated
	 */
	EReference getAuditSessionData_Context();

	/**
	 * Returns the meta object for the containment reference list '{@link org.gecko.mac.audit.AuditSessionData#getEvents <em>Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Events</em>'.
	 * @see org.gecko.mac.audit.AuditSessionData#getEvents()
	 * @see #getAuditSessionData()
	 * @generated
	 */
	EReference getAuditSessionData_Events();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.audit.AuditEventData <em>Event Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event Data</em>'.
	 * @see org.gecko.mac.audit.AuditEventData
	 * @generated
	 */
	EClass getAuditEventData();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getSessionId <em>Session Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Session Id</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getSessionId()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_SessionId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getEventType <em>Event Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Event Type</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getEventType()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_EventType();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getCheckpoint <em>Checkpoint</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Checkpoint</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getCheckpoint()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_Checkpoint();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getDetails <em>Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Details</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getDetails()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_Details();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getTimestamp <em>Timestamp</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timestamp</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getTimestamp()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_Timestamp();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getThreadId <em>Thread Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Thread Id</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getThreadId()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_ThreadId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getDurationNs <em>Duration Ns</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Duration Ns</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getDurationNs()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_DurationNs();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.audit.AuditEventData#getException <em>Exception</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Exception</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getException()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EAttribute getAuditEventData_Exception();

	/**
	 * Returns the meta object for the map '{@link org.gecko.mac.audit.AuditEventData#getEventContext <em>Event Context</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the map '<em>Event Context</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getEventContext()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EReference getAuditEventData_EventContext();

	/**
	 * Returns the meta object for the containment reference '{@link org.gecko.mac.audit.AuditEventData#getAudit <em>Audit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Audit</em>'.
	 * @see org.gecko.mac.audit.AuditEventData#getAudit()
	 * @see #getAuditEventData()
	 * @generated
	 */
	EReference getAuditEventData_Audit();

	/**
	 * Returns the meta object for class '{@link java.util.Map.Entry <em>Context Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Context Entry</em>'.
	 * @see java.util.Map.Entry
	 * @model keyDataType="org.eclipse.emf.ecore.EString" keyRequired="true"
	 *        valueDataType="org.eclipse.emf.ecore.EString"
	 * @generated
	 */
	EClass getContextEntry();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see java.util.Map.Entry
	 * @see #getContextEntry()
	 * @generated
	 */
	EAttribute getContextEntry_Key();

	/**
	 * Returns the meta object for the attribute '{@link java.util.Map.Entry <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see java.util.Map.Entry
	 * @see #getContextEntry()
	 * @generated
	 */
	EAttribute getContextEntry_Value();

	/**
	 * Returns the meta object for enum '{@link org.gecko.mac.audit.ActionType <em>Action Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Action Type</em>'.
	 * @see org.gecko.mac.audit.ActionType
	 * @generated
	 */
	EEnum getActionType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.mac.audit.CategoryType <em>Category Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Category Type</em>'.
	 * @see org.gecko.mac.audit.CategoryType
	 * @generated
	 */
	EEnum getCategoryType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.mac.audit.EventType <em>Event Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Event Type</em>'.
	 * @see org.gecko.mac.audit.EventType
	 * @generated
	 */
	EEnum getEventType();

	/**
	 * Returns the meta object for data type '{@link java.time.Instant <em>Instant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * <!-- begin-model-doc -->
     * Java time Instant for precise timestamps
     * <!-- end-model-doc -->
	 * @return the meta object for data type '<em>Instant</em>'.
	 * @see java.time.Instant
	 * @model instanceClass="java.time.Instant"
	 *        annotation="java.time.Instant"
	 * @generated
	 */
	EDataType getInstant();

	/**
	 * Returns the meta object for data type '{@link java.lang.Throwable <em>Throwable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Throwable</em>'.
	 * @see java.lang.Throwable
	 * @model instanceClass="java.lang.Throwable"
	 * @generated
	 */
	EDataType getThrowable();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	AuditFactory getAuditFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.audit.impl.AuditImpl <em>Audit</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.audit.impl.AuditImpl
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getAudit()
		 * @generated
		 */
		EClass AUDIT = eINSTANCE.getAudit();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT__TIMESTAMP = eINSTANCE.getAudit_Timestamp();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT__ID = eINSTANCE.getAudit_Id();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT__SOURCE = eINSTANCE.getAudit_Source();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT__MESSAGE = eINSTANCE.getAudit_Message();

		/**
		 * The meta object literal for the '<em><b>Action</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT__ACTION = eINSTANCE.getAudit_Action();

		/**
		 * The meta object literal for the '<em><b>Category</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT__CATEGORY = eINSTANCE.getAudit_Category();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.audit.impl.AuditSessionDataImpl <em>Session Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.audit.impl.AuditSessionDataImpl
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getAuditSessionData()
		 * @generated
		 */
		EClass AUDIT_SESSION_DATA = eINSTANCE.getAuditSessionData();

		/**
		 * The meta object literal for the '<em><b>Session Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_SESSION_DATA__SESSION_ID = eINSTANCE.getAuditSessionData_SessionId();

		/**
		 * The meta object literal for the '<em><b>Process Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_SESSION_DATA__PROCESS_NAME = eINSTANCE.getAuditSessionData_ProcessName();

		/**
		 * The meta object literal for the '<em><b>Start Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_SESSION_DATA__START_TIME = eINSTANCE.getAuditSessionData_StartTime();

		/**
		 * The meta object literal for the '<em><b>Active</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_SESSION_DATA__ACTIVE = eINSTANCE.getAuditSessionData_Active();

		/**
		 * The meta object literal for the '<em><b>Context</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AUDIT_SESSION_DATA__CONTEXT = eINSTANCE.getAuditSessionData_Context();

		/**
		 * The meta object literal for the '<em><b>Events</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AUDIT_SESSION_DATA__EVENTS = eINSTANCE.getAuditSessionData_Events();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.audit.impl.AuditEventDataImpl <em>Event Data</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.audit.impl.AuditEventDataImpl
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getAuditEventData()
		 * @generated
		 */
		EClass AUDIT_EVENT_DATA = eINSTANCE.getAuditEventData();

		/**
		 * The meta object literal for the '<em><b>Session Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__SESSION_ID = eINSTANCE.getAuditEventData_SessionId();

		/**
		 * The meta object literal for the '<em><b>Event Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__EVENT_TYPE = eINSTANCE.getAuditEventData_EventType();

		/**
		 * The meta object literal for the '<em><b>Checkpoint</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__CHECKPOINT = eINSTANCE.getAuditEventData_Checkpoint();

		/**
		 * The meta object literal for the '<em><b>Details</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__DETAILS = eINSTANCE.getAuditEventData_Details();

		/**
		 * The meta object literal for the '<em><b>Timestamp</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__TIMESTAMP = eINSTANCE.getAuditEventData_Timestamp();

		/**
		 * The meta object literal for the '<em><b>Thread Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__THREAD_ID = eINSTANCE.getAuditEventData_ThreadId();

		/**
		 * The meta object literal for the '<em><b>Duration Ns</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__DURATION_NS = eINSTANCE.getAuditEventData_DurationNs();

		/**
		 * The meta object literal for the '<em><b>Exception</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute AUDIT_EVENT_DATA__EXCEPTION = eINSTANCE.getAuditEventData_Exception();

		/**
		 * The meta object literal for the '<em><b>Event Context</b></em>' map feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AUDIT_EVENT_DATA__EVENT_CONTEXT = eINSTANCE.getAuditEventData_EventContext();

		/**
		 * The meta object literal for the '<em><b>Audit</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference AUDIT_EVENT_DATA__AUDIT = eINSTANCE.getAuditEventData_Audit();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.audit.impl.ContextEntryImpl <em>Context Entry</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.audit.impl.ContextEntryImpl
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getContextEntry()
		 * @generated
		 */
		EClass CONTEXT_ENTRY = eINSTANCE.getContextEntry();

		/**
		 * The meta object literal for the '<em><b>Key</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTEXT_ENTRY__KEY = eINSTANCE.getContextEntry_Key();

		/**
		 * The meta object literal for the '<em><b>Value</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CONTEXT_ENTRY__VALUE = eINSTANCE.getContextEntry_Value();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.audit.ActionType <em>Action Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.audit.ActionType
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getActionType()
		 * @generated
		 */
		EEnum ACTION_TYPE = eINSTANCE.getActionType();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.audit.CategoryType <em>Category Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.audit.CategoryType
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getCategoryType()
		 * @generated
		 */
		EEnum CATEGORY_TYPE = eINSTANCE.getCategoryType();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.audit.EventType <em>Event Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.audit.EventType
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getEventType()
		 * @generated
		 */
		EEnum EVENT_TYPE = eINSTANCE.getEventType();

		/**
		 * The meta object literal for the '<em>Instant</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see java.time.Instant
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getInstant()
		 * @generated
		 */
		EDataType INSTANT = eINSTANCE.getInstant();

		/**
		 * The meta object literal for the '<em>Throwable</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see java.lang.Throwable
		 * @see org.gecko.mac.audit.impl.AuditPackageImpl#getThrowable()
		 * @generated
		 */
		EDataType THROWABLE = eINSTANCE.getThrowable();

	}

} //AuditPackage
