/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit;

import java.time.Instant;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Session Data</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Process audit session for tracking business flows and method calls across threads
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.audit.AuditSessionData#getSessionId <em>Session Id</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditSessionData#getProcessName <em>Process Name</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditSessionData#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditSessionData#isActive <em>Active</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditSessionData#getContext <em>Context</em>}</li>
 *   <li>{@link org.gecko.mac.audit.AuditSessionData#getEvents <em>Events</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.audit.AuditPackage#getAuditSessionData()
 * @model
 * @generated
 */
@ProviderType
public interface AuditSessionData extends EObject {
	/**
	 * Returns the value of the '<em><b>Session Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Unique session identifier (UUID)
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Session Id</em>' attribute.
	 * @see #setSessionId(String)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditSessionData_SessionId()
	 * @model required="true"
	 * @generated
	 */
	String getSessionId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditSessionData#getSessionId <em>Session Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Session Id</em>' attribute.
	 * @see #getSessionId()
	 * @generated
	 */
	void setSessionId(String value);

	/**
	 * Returns the value of the '<em><b>Process Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Human-readable process name
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Process Name</em>' attribute.
	 * @see #setProcessName(String)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditSessionData_ProcessName()
	 * @model required="true"
	 * @generated
	 */
	String getProcessName();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditSessionData#getProcessName <em>Process Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Process Name</em>' attribute.
	 * @see #getProcessName()
	 * @generated
	 */
	void setProcessName(String value);

	/**
	 * Returns the value of the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session start timestamp
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Start Time</em>' attribute.
	 * @see #setStartTime(Instant)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditSessionData_StartTime()
	 * @model dataType="org.gecko.mac.audit.Instant" required="true"
	 * @generated
	 */
	Instant getStartTime();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditSessionData#getStartTime <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Start Time</em>' attribute.
	 * @see #getStartTime()
	 * @generated
	 */
	void setStartTime(Instant value);

	/**
	 * Returns the value of the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session active state
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Active</em>' attribute.
	 * @see #setActive(boolean)
	 * @see org.gecko.mac.audit.AuditPackage#getAuditSessionData_Active()
	 * @model required="true"
	 * @generated
	 */
	boolean isActive();

	/**
	 * Sets the value of the '{@link org.gecko.mac.audit.AuditSessionData#isActive <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Active</em>' attribute.
	 * @see #isActive()
	 * @generated
	 */
	void setActive(boolean value);

	/**
	 * Returns the value of the '<em><b>Context</b></em>' map.
	 * The key is of type {@link java.lang.String},
	 * and the value is of type {@link java.lang.String},
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session context key-value pairs
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Context</em>' map.
	 * @see org.gecko.mac.audit.AuditPackage#getAuditSessionData_Context()
	 * @model mapType="org.gecko.mac.audit.ContextEntry&lt;org.eclipse.emf.ecore.EString, org.eclipse.emf.ecore.EString&gt;"
	 * @generated
	 */
	EMap<String, String> getContext();

	/**
	 * Returns the value of the '<em><b>Events</b></em>' containment reference list.
	 * The list contents are of type {@link org.gecko.mac.audit.AuditEventData}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * All audit events in this session
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Events</em>' containment reference list.
	 * @see org.gecko.mac.audit.AuditPackage#getAuditSessionData_Events()
	 * @model containment="true"
	 * @generated
	 */
	EList<AuditEventData> getEvents();

} // AuditSessionData
