/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Event Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * Types of audit events within a process session
 * <!-- end-model-doc -->
 * @see org.gecko.mac.audit.AuditPackage#getEventType()
 * @model
 * @generated
 */
@ProviderType
public enum EventType implements Enumerator {
	/**
	 * The '<em><b>SESSION START</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session initiation event
	 * <!-- end-model-doc -->
	 * @see #SESSION_START_VALUE
	 * @generated
	 * @ordered
	 */
	SESSION_START(0, "SESSION_START", "SESSION_START"),

	/**
	 * The '<em><b>CHECKPOINT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Manual process checkpoint
	 * <!-- end-model-doc -->
	 * @see #CHECKPOINT_VALUE
	 * @generated
	 * @ordered
	 */
	CHECKPOINT(1, "CHECKPOINT", "CHECKPOINT"),

	/**
	 * The '<em><b>METHOD CALL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * General method call event
	 * <!-- end-model-doc -->
	 * @see #METHOD_CALL_VALUE
	 * @generated
	 * @ordered
	 */
	METHOD_CALL(2, "METHOD_CALL", "METHOD_CALL"),

	/**
	 * The '<em><b>SERVICE METHOD CALL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * OSGi service method call through proxy
	 * <!-- end-model-doc -->
	 * @see #SERVICE_METHOD_CALL_VALUE
	 * @generated
	 * @ordered
	 */
	SERVICE_METHOD_CALL(3, "SERVICE_METHOD_CALL", "SERVICE_METHOD_CALL"),

	/**
	 * The '<em><b>ERROR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Error event
	 * <!-- end-model-doc -->
	 * @see #ERROR_VALUE
	 * @generated
	 * @ordered
	 */
	ERROR(4, "ERROR", "ERROR"),

	/**
	 * The '<em><b>SESSION COMPLETE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session completed successfully
	 * <!-- end-model-doc -->
	 * @see #SESSION_COMPLETE_VALUE
	 * @generated
	 * @ordered
	 */
	SESSION_COMPLETE(5, "SESSION_COMPLETE", "SESSION_COMPLETE"),

	/**
	 * The '<em><b>SESSION FAILED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session failed
	 * <!-- end-model-doc -->
	 * @see #SESSION_FAILED_VALUE
	 * @generated
	 * @ordered
	 */
	SESSION_FAILED(6, "SESSION_FAILED", "SESSION_FAILED");

	/**
	 * The '<em><b>SESSION START</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session initiation event
	 * <!-- end-model-doc -->
	 * @see #SESSION_START
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SESSION_START_VALUE = 0;

	/**
	 * The '<em><b>CHECKPOINT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Manual process checkpoint
	 * <!-- end-model-doc -->
	 * @see #CHECKPOINT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CHECKPOINT_VALUE = 1;

	/**
	 * The '<em><b>METHOD CALL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * General method call event
	 * <!-- end-model-doc -->
	 * @see #METHOD_CALL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int METHOD_CALL_VALUE = 2;

	/**
	 * The '<em><b>SERVICE METHOD CALL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * OSGi service method call through proxy
	 * <!-- end-model-doc -->
	 * @see #SERVICE_METHOD_CALL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SERVICE_METHOD_CALL_VALUE = 3;

	/**
	 * The '<em><b>ERROR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Error event
	 * <!-- end-model-doc -->
	 * @see #ERROR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ERROR_VALUE = 4;

	/**
	 * The '<em><b>SESSION COMPLETE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session completed successfully
	 * <!-- end-model-doc -->
	 * @see #SESSION_COMPLETE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SESSION_COMPLETE_VALUE = 5;

	/**
	 * The '<em><b>SESSION FAILED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Session failed
	 * <!-- end-model-doc -->
	 * @see #SESSION_FAILED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SESSION_FAILED_VALUE = 6;

	/**
	 * An array of all the '<em><b>Event Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final EventType[] VALUES_ARRAY =
		new EventType[] {
			SESSION_START,
			CHECKPOINT,
			METHOD_CALL,
			SERVICE_METHOD_CALL,
			ERROR,
			SESSION_COMPLETE,
			SESSION_FAILED,
		};

	/**
	 * A public read-only list of all the '<em><b>Event Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<EventType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Event Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static EventType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			EventType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Event Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static EventType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			EventType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Event Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static EventType get(int value) {
		switch (value) {
			case SESSION_START_VALUE: return SESSION_START;
			case CHECKPOINT_VALUE: return CHECKPOINT;
			case METHOD_CALL_VALUE: return METHOD_CALL;
			case SERVICE_METHOD_CALL_VALUE: return SERVICE_METHOD_CALL;
			case ERROR_VALUE: return ERROR;
			case SESSION_COMPLETE_VALUE: return SESSION_COMPLETE;
			case SESSION_FAILED_VALUE: return SESSION_FAILED;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EventType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //EventType
