/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit.helper;

import org.gecko.mac.audit.ActionType;
import org.gecko.mac.audit.Audit;
import org.gecko.mac.audit.AuditFactory;
import org.gecko.mac.audit.CategoryType;

/**
 * 
 * @author ilenia
 * @since Oct 22, 2025
 */
public class AuditHelper {
	
	public static Audit createAudit(String id, String timestamp, String source, ActionType action, CategoryType category, String message) {
		Audit audit = AuditFactory.eINSTANCE.createAudit();
		audit.setId(id);
		audit.setTimestamp(timestamp);
		audit.setSource(source);
		audit.setAction(action);
		audit.setCategory(category);
		audit.setMessage(message);
		return audit;
	}

}
