/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit.impl;

import java.time.Instant;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.mac.audit.Audit;
import org.gecko.mac.audit.AuditEventData;
import org.gecko.mac.audit.AuditPackage;
import org.gecko.mac.audit.EventType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Event Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getSessionId <em>Session Id</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getEventType <em>Event Type</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getCheckpoint <em>Checkpoint</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getDetails <em>Details</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getTimestamp <em>Timestamp</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getThreadId <em>Thread Id</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getDurationNs <em>Duration Ns</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getException <em>Exception</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getEventContext <em>Event Context</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditEventDataImpl#getAudit <em>Audit</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AuditEventDataImpl extends MinimalEObjectImpl.Container implements AuditEventData {
	/**
	 * The default value of the '{@link #getSessionId() <em>Session Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSessionId()
	 * @generated
	 * @ordered
	 */
	protected static final String SESSION_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSessionId() <em>Session Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSessionId()
	 * @generated
	 * @ordered
	 */
	protected String sessionId = SESSION_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getEventType() <em>Event Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventType()
	 * @generated
	 * @ordered
	 */
	protected static final EventType EVENT_TYPE_EDEFAULT = EventType.SESSION_START;

	/**
	 * The cached value of the '{@link #getEventType() <em>Event Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventType()
	 * @generated
	 * @ordered
	 */
	protected EventType eventType = EVENT_TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getCheckpoint() <em>Checkpoint</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheckpoint()
	 * @generated
	 * @ordered
	 */
	protected static final String CHECKPOINT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCheckpoint() <em>Checkpoint</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCheckpoint()
	 * @generated
	 * @ordered
	 */
	protected String checkpoint = CHECKPOINT_EDEFAULT;

	/**
	 * The default value of the '{@link #getDetails() <em>Details</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDetails()
	 * @generated
	 * @ordered
	 */
	protected static final String DETAILS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDetails() <em>Details</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDetails()
	 * @generated
	 * @ordered
	 */
	protected String details = DETAILS_EDEFAULT;

	/**
	 * The default value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected static final Instant TIMESTAMP_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getTimestamp() <em>Timestamp</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTimestamp()
	 * @generated
	 * @ordered
	 */
	protected Instant timestamp = TIMESTAMP_EDEFAULT;

	/**
	 * The default value of the '{@link #getThreadId() <em>Thread Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreadId()
	 * @generated
	 * @ordered
	 */
	protected static final long THREAD_ID_EDEFAULT = 0L;

	/**
	 * The cached value of the '{@link #getThreadId() <em>Thread Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getThreadId()
	 * @generated
	 * @ordered
	 */
	protected long threadId = THREAD_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getDurationNs() <em>Duration Ns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDurationNs()
	 * @generated
	 * @ordered
	 */
	protected static final Long DURATION_NS_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDurationNs() <em>Duration Ns</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDurationNs()
	 * @generated
	 * @ordered
	 */
	protected Long durationNs = DURATION_NS_EDEFAULT;

	/**
	 * The default value of the '{@link #getException() <em>Exception</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getException()
	 * @generated
	 * @ordered
	 */
	protected static final String EXCEPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getException() <em>Exception</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getException()
	 * @generated
	 * @ordered
	 */
	protected String exception = EXCEPTION_EDEFAULT;

	/**
	 * The cached value of the '{@link #getEventContext() <em>Event Context</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEventContext()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, String> eventContext;

	/**
	 * The cached value of the '{@link #getAudit() <em>Audit</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAudit()
	 * @generated
	 * @ordered
	 */
	protected Audit audit;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AuditEventDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AuditPackage.Literals.AUDIT_EVENT_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getSessionId() {
		return sessionId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSessionId(String newSessionId) {
		String oldSessionId = sessionId;
		sessionId = newSessionId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__SESSION_ID, oldSessionId, sessionId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EventType getEventType() {
		return eventType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setEventType(EventType newEventType) {
		EventType oldEventType = eventType;
		eventType = newEventType == null ? EVENT_TYPE_EDEFAULT : newEventType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__EVENT_TYPE, oldEventType, eventType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCheckpoint() {
		return checkpoint;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCheckpoint(String newCheckpoint) {
		String oldCheckpoint = checkpoint;
		checkpoint = newCheckpoint;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__CHECKPOINT, oldCheckpoint, checkpoint));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDetails() {
		return details;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDetails(String newDetails) {
		String oldDetails = details;
		details = newDetails;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__DETAILS, oldDetails, details));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Instant getTimestamp() {
		return timestamp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTimestamp(Instant newTimestamp) {
		Instant oldTimestamp = timestamp;
		timestamp = newTimestamp;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__TIMESTAMP, oldTimestamp, timestamp));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public long getThreadId() {
		return threadId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setThreadId(long newThreadId) {
		long oldThreadId = threadId;
		threadId = newThreadId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__THREAD_ID, oldThreadId, threadId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Long getDurationNs() {
		return durationNs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDurationNs(Long newDurationNs) {
		Long oldDurationNs = durationNs;
		durationNs = newDurationNs;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__DURATION_NS, oldDurationNs, durationNs));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getException() {
		return exception;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setException(String newException) {
		String oldException = exception;
		exception = newException;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__EXCEPTION, oldException, exception));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EMap<String, String> getEventContext() {
		if (eventContext == null) {
			eventContext = new EcoreEMap<String,String>(AuditPackage.Literals.CONTEXT_ENTRY, ContextEntryImpl.class, this, AuditPackage.AUDIT_EVENT_DATA__EVENT_CONTEXT);
		}
		return eventContext;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Audit getAudit() {
		return audit;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAudit(Audit newAudit, NotificationChain msgs) {
		Audit oldAudit = audit;
		audit = newAudit;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__AUDIT, oldAudit, newAudit);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAudit(Audit newAudit) {
		if (newAudit != audit) {
			NotificationChain msgs = null;
			if (audit != null)
				msgs = ((InternalEObject)audit).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - AuditPackage.AUDIT_EVENT_DATA__AUDIT, null, msgs);
			if (newAudit != null)
				msgs = ((InternalEObject)newAudit).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - AuditPackage.AUDIT_EVENT_DATA__AUDIT, null, msgs);
			msgs = basicSetAudit(newAudit, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_EVENT_DATA__AUDIT, newAudit, newAudit));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_CONTEXT:
				return ((InternalEList<?>)getEventContext()).basicRemove(otherEnd, msgs);
			case AuditPackage.AUDIT_EVENT_DATA__AUDIT:
				return basicSetAudit(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AuditPackage.AUDIT_EVENT_DATA__SESSION_ID:
				return getSessionId();
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_TYPE:
				return getEventType();
			case AuditPackage.AUDIT_EVENT_DATA__CHECKPOINT:
				return getCheckpoint();
			case AuditPackage.AUDIT_EVENT_DATA__DETAILS:
				return getDetails();
			case AuditPackage.AUDIT_EVENT_DATA__TIMESTAMP:
				return getTimestamp();
			case AuditPackage.AUDIT_EVENT_DATA__THREAD_ID:
				return getThreadId();
			case AuditPackage.AUDIT_EVENT_DATA__DURATION_NS:
				return getDurationNs();
			case AuditPackage.AUDIT_EVENT_DATA__EXCEPTION:
				return getException();
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_CONTEXT:
				if (coreType) return getEventContext();
				else return getEventContext().map();
			case AuditPackage.AUDIT_EVENT_DATA__AUDIT:
				return getAudit();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AuditPackage.AUDIT_EVENT_DATA__SESSION_ID:
				setSessionId((String)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_TYPE:
				setEventType((EventType)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__CHECKPOINT:
				setCheckpoint((String)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__DETAILS:
				setDetails((String)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__TIMESTAMP:
				setTimestamp((Instant)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__THREAD_ID:
				setThreadId((Long)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__DURATION_NS:
				setDurationNs((Long)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__EXCEPTION:
				setException((String)newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_CONTEXT:
				((EStructuralFeature.Setting)getEventContext()).set(newValue);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__AUDIT:
				setAudit((Audit)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AuditPackage.AUDIT_EVENT_DATA__SESSION_ID:
				setSessionId(SESSION_ID_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_TYPE:
				setEventType(EVENT_TYPE_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__CHECKPOINT:
				setCheckpoint(CHECKPOINT_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__DETAILS:
				setDetails(DETAILS_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__THREAD_ID:
				setThreadId(THREAD_ID_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__DURATION_NS:
				setDurationNs(DURATION_NS_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__EXCEPTION:
				setException(EXCEPTION_EDEFAULT);
				return;
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_CONTEXT:
				getEventContext().clear();
				return;
			case AuditPackage.AUDIT_EVENT_DATA__AUDIT:
				setAudit((Audit)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AuditPackage.AUDIT_EVENT_DATA__SESSION_ID:
				return SESSION_ID_EDEFAULT == null ? sessionId != null : !SESSION_ID_EDEFAULT.equals(sessionId);
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_TYPE:
				return eventType != EVENT_TYPE_EDEFAULT;
			case AuditPackage.AUDIT_EVENT_DATA__CHECKPOINT:
				return CHECKPOINT_EDEFAULT == null ? checkpoint != null : !CHECKPOINT_EDEFAULT.equals(checkpoint);
			case AuditPackage.AUDIT_EVENT_DATA__DETAILS:
				return DETAILS_EDEFAULT == null ? details != null : !DETAILS_EDEFAULT.equals(details);
			case AuditPackage.AUDIT_EVENT_DATA__TIMESTAMP:
				return TIMESTAMP_EDEFAULT == null ? timestamp != null : !TIMESTAMP_EDEFAULT.equals(timestamp);
			case AuditPackage.AUDIT_EVENT_DATA__THREAD_ID:
				return threadId != THREAD_ID_EDEFAULT;
			case AuditPackage.AUDIT_EVENT_DATA__DURATION_NS:
				return DURATION_NS_EDEFAULT == null ? durationNs != null : !DURATION_NS_EDEFAULT.equals(durationNs);
			case AuditPackage.AUDIT_EVENT_DATA__EXCEPTION:
				return EXCEPTION_EDEFAULT == null ? exception != null : !EXCEPTION_EDEFAULT.equals(exception);
			case AuditPackage.AUDIT_EVENT_DATA__EVENT_CONTEXT:
				return eventContext != null && !eventContext.isEmpty();
			case AuditPackage.AUDIT_EVENT_DATA__AUDIT:
				return audit != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (sessionId: ");
		result.append(sessionId);
		result.append(", eventType: ");
		result.append(eventType);
		result.append(", checkpoint: ");
		result.append(checkpoint);
		result.append(", details: ");
		result.append(details);
		result.append(", timestamp: ");
		result.append(timestamp);
		result.append(", threadId: ");
		result.append(threadId);
		result.append(", durationNs: ");
		result.append(durationNs);
		result.append(", exception: ");
		result.append(exception);
		result.append(')');
		return result.toString();
	}

} //AuditEventDataImpl
