/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit.impl;

import java.time.Instant;

import java.util.Map;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.mac.audit.ActionType;
import org.gecko.mac.audit.Audit;
import org.gecko.mac.audit.AuditEventData;
import org.gecko.mac.audit.AuditFactory;
import org.gecko.mac.audit.AuditPackage;
import org.gecko.mac.audit.AuditSessionData;
import org.gecko.mac.audit.CategoryType;
import org.gecko.mac.audit.EventType;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class AuditPackageImpl extends EPackageImpl implements AuditPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass auditEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass auditSessionDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass auditEventDataEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contextEntryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum actionTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum categoryTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum eventTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType instantEDataType = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EDataType throwableEDataType = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.mac.audit.AuditPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private AuditPackageImpl() {
		super(eNS_URI, AuditFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link AuditPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static AuditPackage init() {
		if (isInited) return (AuditPackage)EPackage.Registry.INSTANCE.getEPackage(AuditPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredAuditPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		AuditPackageImpl theAuditPackage = registeredAuditPackage instanceof AuditPackageImpl ? (AuditPackageImpl)registeredAuditPackage : new AuditPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theAuditPackage.createPackageContents();

		// Initialize created meta-data
		theAuditPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theAuditPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(AuditPackage.eNS_URI, theAuditPackage);
		return theAuditPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAudit() {
		return auditEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAudit_Timestamp() {
		return (EAttribute)auditEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAudit_Id() {
		return (EAttribute)auditEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAudit_Source() {
		return (EAttribute)auditEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAudit_Message() {
		return (EAttribute)auditEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAudit_Action() {
		return (EAttribute)auditEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAudit_Category() {
		return (EAttribute)auditEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAuditSessionData() {
		return auditSessionDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditSessionData_SessionId() {
		return (EAttribute)auditSessionDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditSessionData_ProcessName() {
		return (EAttribute)auditSessionDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditSessionData_StartTime() {
		return (EAttribute)auditSessionDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditSessionData_Active() {
		return (EAttribute)auditSessionDataEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAuditSessionData_Context() {
		return (EReference)auditSessionDataEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAuditSessionData_Events() {
		return (EReference)auditSessionDataEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAuditEventData() {
		return auditEventDataEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_SessionId() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_EventType() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_Checkpoint() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_Details() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_Timestamp() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_ThreadId() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_DurationNs() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAuditEventData_Exception() {
		return (EAttribute)auditEventDataEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAuditEventData_EventContext() {
		return (EReference)auditEventDataEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getAuditEventData_Audit() {
		return (EReference)auditEventDataEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContextEntry() {
		return contextEntryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContextEntry_Key() {
		return (EAttribute)contextEntryEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContextEntry_Value() {
		return (EAttribute)contextEntryEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getActionType() {
		return actionTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getCategoryType() {
		return categoryTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getEventType() {
		return eventTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getInstant() {
		return instantEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EDataType getThrowable() {
		return throwableEDataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AuditFactory getAuditFactory() {
		return (AuditFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		auditEClass = createEClass(AUDIT);
		createEAttribute(auditEClass, AUDIT__TIMESTAMP);
		createEAttribute(auditEClass, AUDIT__ID);
		createEAttribute(auditEClass, AUDIT__SOURCE);
		createEAttribute(auditEClass, AUDIT__MESSAGE);
		createEAttribute(auditEClass, AUDIT__ACTION);
		createEAttribute(auditEClass, AUDIT__CATEGORY);

		auditSessionDataEClass = createEClass(AUDIT_SESSION_DATA);
		createEAttribute(auditSessionDataEClass, AUDIT_SESSION_DATA__SESSION_ID);
		createEAttribute(auditSessionDataEClass, AUDIT_SESSION_DATA__PROCESS_NAME);
		createEAttribute(auditSessionDataEClass, AUDIT_SESSION_DATA__START_TIME);
		createEAttribute(auditSessionDataEClass, AUDIT_SESSION_DATA__ACTIVE);
		createEReference(auditSessionDataEClass, AUDIT_SESSION_DATA__CONTEXT);
		createEReference(auditSessionDataEClass, AUDIT_SESSION_DATA__EVENTS);

		auditEventDataEClass = createEClass(AUDIT_EVENT_DATA);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__SESSION_ID);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__EVENT_TYPE);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__CHECKPOINT);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__DETAILS);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__TIMESTAMP);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__THREAD_ID);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__DURATION_NS);
		createEAttribute(auditEventDataEClass, AUDIT_EVENT_DATA__EXCEPTION);
		createEReference(auditEventDataEClass, AUDIT_EVENT_DATA__EVENT_CONTEXT);
		createEReference(auditEventDataEClass, AUDIT_EVENT_DATA__AUDIT);

		contextEntryEClass = createEClass(CONTEXT_ENTRY);
		createEAttribute(contextEntryEClass, CONTEXT_ENTRY__KEY);
		createEAttribute(contextEntryEClass, CONTEXT_ENTRY__VALUE);

		// Create enums
		actionTypeEEnum = createEEnum(ACTION_TYPE);
		categoryTypeEEnum = createEEnum(CATEGORY_TYPE);
		eventTypeEEnum = createEEnum(EVENT_TYPE);

		// Create data types
		instantEDataType = createEDataType(INSTANT);
		throwableEDataType = createEDataType(THROWABLE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes, features, and operations; add parameters
		initEClass(auditEClass, Audit.class, "Audit", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAudit_Timestamp(), ecorePackage.getEString(), "timestamp", null, 0, 1, Audit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAudit_Id(), ecorePackage.getEString(), "id", null, 0, 1, Audit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAudit_Source(), ecorePackage.getEString(), "source", null, 0, 1, Audit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAudit_Message(), ecorePackage.getEString(), "message", null, 0, 1, Audit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAudit_Action(), this.getActionType(), "action", null, 0, 1, Audit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAudit_Category(), this.getCategoryType(), "category", null, 0, 1, Audit.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(auditSessionDataEClass, AuditSessionData.class, "AuditSessionData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAuditSessionData_SessionId(), ecorePackage.getEString(), "sessionId", null, 1, 1, AuditSessionData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditSessionData_ProcessName(), ecorePackage.getEString(), "processName", null, 1, 1, AuditSessionData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditSessionData_StartTime(), this.getInstant(), "startTime", null, 1, 1, AuditSessionData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditSessionData_Active(), ecorePackage.getEBoolean(), "active", null, 1, 1, AuditSessionData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAuditSessionData_Context(), this.getContextEntry(), null, "context", null, 0, -1, AuditSessionData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAuditSessionData_Events(), this.getAuditEventData(), null, "events", null, 0, -1, AuditSessionData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(auditEventDataEClass, AuditEventData.class, "AuditEventData", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAuditEventData_SessionId(), ecorePackage.getEString(), "sessionId", null, 1, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditEventData_EventType(), this.getEventType(), "eventType", null, 1, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditEventData_Checkpoint(), ecorePackage.getEString(), "checkpoint", null, 1, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditEventData_Details(), ecorePackage.getEString(), "details", null, 0, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditEventData_Timestamp(), this.getInstant(), "timestamp", null, 1, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditEventData_ThreadId(), ecorePackage.getELong(), "threadId", null, 1, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditEventData_DurationNs(), ecorePackage.getELongObject(), "durationNs", null, 0, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAuditEventData_Exception(), ecorePackage.getEString(), "exception", null, 0, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAuditEventData_EventContext(), this.getContextEntry(), null, "eventContext", null, 0, -1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getAuditEventData_Audit(), this.getAudit(), null, "audit", null, 0, 1, AuditEventData.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(contextEntryEClass, Map.Entry.class, "ContextEntry", !IS_ABSTRACT, !IS_INTERFACE, !IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContextEntry_Key(), ecorePackage.getEString(), "key", null, 1, 1, Map.Entry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContextEntry_Value(), ecorePackage.getEString(), "value", null, 0, 1, Map.Entry.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(actionTypeEEnum, ActionType.class, "ActionType");
		addEEnumLiteral(actionTypeEEnum, ActionType.RECEIVED);
		addEEnumLiteral(actionTypeEEnum, ActionType.LOADED);
		addEEnumLiteral(actionTypeEEnum, ActionType.GENERATED);
		addEEnumLiteral(actionTypeEEnum, ActionType.MAPPED_TO_SENSINACT);
		addEEnumLiteral(actionTypeEEnum, ActionType.APPROVED);
		addEEnumLiteral(actionTypeEEnum, ActionType.REJECTED);
		addEEnumLiteral(actionTypeEEnum, ActionType.DRAFT);
		addEEnumLiteral(actionTypeEEnum, ActionType.IN_REVIEW);
		addEEnumLiteral(actionTypeEEnum, ActionType.FAILURE);
		addEEnumLiteral(actionTypeEEnum, ActionType.SESSION_STARTED);
		addEEnumLiteral(actionTypeEEnum, ActionType.SESSION_COMPLETED);
		addEEnumLiteral(actionTypeEEnum, ActionType.SESSION_CHECKPOINT);
		addEEnumLiteral(actionTypeEEnum, ActionType.SERVICE_METHOD_CALL);

		initEEnum(categoryTypeEEnum, CategoryType.class, "CategoryType");
		addEEnumLiteral(categoryTypeEEnum, CategoryType.SENSOR_DATA);
		addEEnumLiteral(categoryTypeEEnum, CategoryType.MODEL);
		addEEnumLiteral(categoryTypeEEnum, CategoryType.WORKFLOW);

		initEEnum(eventTypeEEnum, EventType.class, "EventType");
		addEEnumLiteral(eventTypeEEnum, EventType.SESSION_START);
		addEEnumLiteral(eventTypeEEnum, EventType.CHECKPOINT);
		addEEnumLiteral(eventTypeEEnum, EventType.METHOD_CALL);
		addEEnumLiteral(eventTypeEEnum, EventType.SERVICE_METHOD_CALL);
		addEEnumLiteral(eventTypeEEnum, EventType.ERROR);
		addEEnumLiteral(eventTypeEEnum, EventType.SESSION_COMPLETE);
		addEEnumLiteral(eventTypeEEnum, EventType.SESSION_FAILED);

		// Initialize data types
		initEDataType(instantEDataType, Instant.class, "Instant", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);
		initEDataType(throwableEDataType, Throwable.class, "Throwable", IS_SERIALIZABLE, !IS_GENERATED_INSTANCE_CLASS);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
		// java.time.Instant
		createJavaAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Data In Motion - initial API and implementation",
			   "resource", "XMI",
			   "oSGiCompatible", "true",
			   "basePackage", "org.gecko.mac"
		   });
		addAnnotation
		  (getAudit_Id(),
		   source,
		   new String[] {
			   "documentation", "Unique identifier of the asset this audit refers to"
		   });
		addAnnotation
		  (getAudit_Source(),
		   source,
		   new String[] {
			   "documentation", "The id of the component from which this audit comes from"
		   });
		addAnnotation
		  (auditSessionDataEClass,
		   source,
		   new String[] {
			   "documentation", "Process audit session for tracking business flows and method calls across threads"
		   });
		addAnnotation
		  (getAuditSessionData_SessionId(),
		   source,
		   new String[] {
			   "documentation", "Unique session identifier (UUID)"
		   });
		addAnnotation
		  (getAuditSessionData_ProcessName(),
		   source,
		   new String[] {
			   "documentation", "Human-readable process name"
		   });
		addAnnotation
		  (getAuditSessionData_StartTime(),
		   source,
		   new String[] {
			   "documentation", "Session start timestamp"
		   });
		addAnnotation
		  (getAuditSessionData_Active(),
		   source,
		   new String[] {
			   "documentation", "Session active state"
		   });
		addAnnotation
		  (getAuditSessionData_Context(),
		   source,
		   new String[] {
			   "documentation", "Session context key-value pairs"
		   });
		addAnnotation
		  (getAuditSessionData_Events(),
		   source,
		   new String[] {
			   "documentation", "All audit events in this session"
		   });
		addAnnotation
		  (auditEventDataEClass,
		   source,
		   new String[] {
			   "documentation", "Individual audit event within a process session"
		   });
		addAnnotation
		  (getAuditEventData_SessionId(),
		   source,
		   new String[] {
			   "documentation", "Reference to parent session ID"
		   });
		addAnnotation
		  (getAuditEventData_EventType(),
		   source,
		   new String[] {
			   "documentation", "Type of audit event"
		   });
		addAnnotation
		  (getAuditEventData_Checkpoint(),
		   source,
		   new String[] {
			   "documentation", "Checkpoint or method name"
		   });
		addAnnotation
		  (getAuditEventData_Details(),
		   source,
		   new String[] {
			   "documentation", "Additional event details"
		   });
		addAnnotation
		  (getAuditEventData_Timestamp(),
		   source,
		   new String[] {
			   "documentation", "Event timestamp"
		   });
		addAnnotation
		  (getAuditEventData_ThreadId(),
		   source,
		   new String[] {
			   "documentation", "Thread ID where event occurred"
		   });
		addAnnotation
		  (getAuditEventData_DurationNs(),
		   source,
		   new String[] {
			   "documentation", "Duration in nanoseconds (for method calls)"
		   });
		addAnnotation
		  (getAuditEventData_Exception(),
		   source,
		   new String[] {
			   "documentation", "Exception message if error occurred"
		   });
		addAnnotation
		  (getAuditEventData_EventContext(),
		   source,
		   new String[] {
			   "documentation", "Context snapshot at time of event"
		   });
		addAnnotation
		  (contextEntryEClass,
		   source,
		   new String[] {
			   "documentation", "Key-value pair for session context"
		   });
		addAnnotation
		  (actionTypeEEnum.getELiterals().get(12),
		   source,
		   new String[] {
			   "documentation", "OSGi service method call through proxy"
		   });
		addAnnotation
		  (eventTypeEEnum,
		   source,
		   new String[] {
			   "documentation", "Types of audit events within a process session"
		   });
		addAnnotation
		  (eventTypeEEnum.getELiterals().get(0),
		   source,
		   new String[] {
			   "documentation", "Session initiation event"
		   });
		addAnnotation
		  (eventTypeEEnum.getELiterals().get(1),
		   source,
		   new String[] {
			   "documentation", "Manual process checkpoint"
		   });
		addAnnotation
		  (eventTypeEEnum.getELiterals().get(2),
		   source,
		   new String[] {
			   "documentation", "General method call event"
		   });
		addAnnotation
		  (eventTypeEEnum.getELiterals().get(3),
		   source,
		   new String[] {
			   "documentation", "OSGi service method call through proxy"
		   });
		addAnnotation
		  (eventTypeEEnum.getELiterals().get(4),
		   source,
		   new String[] {
			   "documentation", "Error event"
		   });
		addAnnotation
		  (eventTypeEEnum.getELiterals().get(5),
		   source,
		   new String[] {
			   "documentation", "Session completed successfully"
		   });
		addAnnotation
		  (eventTypeEEnum.getELiterals().get(6),
		   source,
		   new String[] {
			   "documentation", "Session failed"
		   });
		addAnnotation
		  (instantEDataType,
		   source,
		   new String[] {
			   "documentation", "Java time Instant for precise timestamps"
		   });
	}

	/**
	 * Initializes the annotations for <b>java.time.Instant</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createJavaAnnotations() {
		String source = "java.time.Instant";
		addAnnotation
		  (instantEDataType,
		   source,
		   new String[] {
		   });
	}

} //AuditPackageImpl
