/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Data In Motion - initial API and implementation
 */
package org.gecko.mac.audit.impl;

import java.time.Instant;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

import org.gecko.mac.audit.AuditEventData;
import org.gecko.mac.audit.AuditPackage;
import org.gecko.mac.audit.AuditSessionData;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Session Data</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.audit.impl.AuditSessionDataImpl#getSessionId <em>Session Id</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditSessionDataImpl#getProcessName <em>Process Name</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditSessionDataImpl#getStartTime <em>Start Time</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditSessionDataImpl#isActive <em>Active</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditSessionDataImpl#getContext <em>Context</em>}</li>
 *   <li>{@link org.gecko.mac.audit.impl.AuditSessionDataImpl#getEvents <em>Events</em>}</li>
 * </ul>
 *
 * @generated
 */
public class AuditSessionDataImpl extends MinimalEObjectImpl.Container implements AuditSessionData {
	/**
	 * The default value of the '{@link #getSessionId() <em>Session Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSessionId()
	 * @generated
	 * @ordered
	 */
	protected static final String SESSION_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSessionId() <em>Session Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSessionId()
	 * @generated
	 * @ordered
	 */
	protected String sessionId = SESSION_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getProcessName() <em>Process Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessName()
	 * @generated
	 * @ordered
	 */
	protected static final String PROCESS_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getProcessName() <em>Process Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProcessName()
	 * @generated
	 * @ordered
	 */
	protected String processName = PROCESS_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected static final Instant START_TIME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStartTime() <em>Start Time</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartTime()
	 * @generated
	 * @ordered
	 */
	protected Instant startTime = START_TIME_EDEFAULT;

	/**
	 * The default value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ACTIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isActive() <em>Active</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isActive()
	 * @generated
	 * @ordered
	 */
	protected boolean active = ACTIVE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContext() <em>Context</em>}' map.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContext()
	 * @generated
	 * @ordered
	 */
	protected EMap<String, String> context;

	/**
	 * The cached value of the '{@link #getEvents() <em>Events</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEvents()
	 * @generated
	 * @ordered
	 */
	protected EList<AuditEventData> events;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AuditSessionDataImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AuditPackage.Literals.AUDIT_SESSION_DATA;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getSessionId() {
		return sessionId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSessionId(String newSessionId) {
		String oldSessionId = sessionId;
		sessionId = newSessionId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_SESSION_DATA__SESSION_ID, oldSessionId, sessionId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getProcessName() {
		return processName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setProcessName(String newProcessName) {
		String oldProcessName = processName;
		processName = newProcessName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_SESSION_DATA__PROCESS_NAME, oldProcessName, processName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Instant getStartTime() {
		return startTime;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStartTime(Instant newStartTime) {
		Instant oldStartTime = startTime;
		startTime = newStartTime;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_SESSION_DATA__START_TIME, oldStartTime, startTime));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isActive() {
		return active;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setActive(boolean newActive) {
		boolean oldActive = active;
		active = newActive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AuditPackage.AUDIT_SESSION_DATA__ACTIVE, oldActive, active));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EMap<String, String> getContext() {
		if (context == null) {
			context = new EcoreEMap<String,String>(AuditPackage.Literals.CONTEXT_ENTRY, ContextEntryImpl.class, this, AuditPackage.AUDIT_SESSION_DATA__CONTEXT);
		}
		return context;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<AuditEventData> getEvents() {
		if (events == null) {
			events = new EObjectContainmentEList<AuditEventData>(AuditEventData.class, this, AuditPackage.AUDIT_SESSION_DATA__EVENTS);
		}
		return events;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case AuditPackage.AUDIT_SESSION_DATA__CONTEXT:
				return ((InternalEList<?>)getContext()).basicRemove(otherEnd, msgs);
			case AuditPackage.AUDIT_SESSION_DATA__EVENTS:
				return ((InternalEList<?>)getEvents()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AuditPackage.AUDIT_SESSION_DATA__SESSION_ID:
				return getSessionId();
			case AuditPackage.AUDIT_SESSION_DATA__PROCESS_NAME:
				return getProcessName();
			case AuditPackage.AUDIT_SESSION_DATA__START_TIME:
				return getStartTime();
			case AuditPackage.AUDIT_SESSION_DATA__ACTIVE:
				return isActive();
			case AuditPackage.AUDIT_SESSION_DATA__CONTEXT:
				if (coreType) return getContext();
				else return getContext().map();
			case AuditPackage.AUDIT_SESSION_DATA__EVENTS:
				return getEvents();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AuditPackage.AUDIT_SESSION_DATA__SESSION_ID:
				setSessionId((String)newValue);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__PROCESS_NAME:
				setProcessName((String)newValue);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__START_TIME:
				setStartTime((Instant)newValue);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__ACTIVE:
				setActive((Boolean)newValue);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__CONTEXT:
				((EStructuralFeature.Setting)getContext()).set(newValue);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__EVENTS:
				getEvents().clear();
				getEvents().addAll((Collection<? extends AuditEventData>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AuditPackage.AUDIT_SESSION_DATA__SESSION_ID:
				setSessionId(SESSION_ID_EDEFAULT);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__PROCESS_NAME:
				setProcessName(PROCESS_NAME_EDEFAULT);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__START_TIME:
				setStartTime(START_TIME_EDEFAULT);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__ACTIVE:
				setActive(ACTIVE_EDEFAULT);
				return;
			case AuditPackage.AUDIT_SESSION_DATA__CONTEXT:
				getContext().clear();
				return;
			case AuditPackage.AUDIT_SESSION_DATA__EVENTS:
				getEvents().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AuditPackage.AUDIT_SESSION_DATA__SESSION_ID:
				return SESSION_ID_EDEFAULT == null ? sessionId != null : !SESSION_ID_EDEFAULT.equals(sessionId);
			case AuditPackage.AUDIT_SESSION_DATA__PROCESS_NAME:
				return PROCESS_NAME_EDEFAULT == null ? processName != null : !PROCESS_NAME_EDEFAULT.equals(processName);
			case AuditPackage.AUDIT_SESSION_DATA__START_TIME:
				return START_TIME_EDEFAULT == null ? startTime != null : !START_TIME_EDEFAULT.equals(startTime);
			case AuditPackage.AUDIT_SESSION_DATA__ACTIVE:
				return active != ACTIVE_EDEFAULT;
			case AuditPackage.AUDIT_SESSION_DATA__CONTEXT:
				return context != null && !context.isEmpty();
			case AuditPackage.AUDIT_SESSION_DATA__EVENTS:
				return events != null && !events.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (sessionId: ");
		result.append(sessionId);
		result.append(", processName: ");
		result.append(processName);
		result.append(", startTime: ");
		result.append(startTime);
		result.append(", active: ");
		result.append(active);
		result.append(')');
		return result.toString();
	}

} //AuditSessionDataImpl
