/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.mac.auditapi;


import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.auditapi.AuditApiFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel modelName='AuditApi' complianceLevel='17.0' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Mark Hoffmann - initial API and implementation' resource='XMI' prefix='AuditApi' basePackage='org.gecko.mac' rootExtendsInterface='' oSGiCompatible='true'"
 * @generated
 */
@ProviderType
@EPackage(uri = AuditApiPackage.eNS_URI, genModel = "/model/audit-api.genmodel", genModelSourceLocations = {"model/audit-api.genmodel","org.gecko.mac.audit.model/model/audit-api.genmodel"}, ecore="/model/audit-api.ecore", ecoreSourceLocations="/model/audit-api.ecore")
public interface AuditApiPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "auditapi";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://datainmotion.com/mac/audit/api/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "auditapi";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	AuditApiPackage eINSTANCE = org.gecko.mac.auditapi.impl.AuditApiPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager <em>Process Audit Session Manager</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager
	 * @see org.gecko.mac.auditapi.impl.AuditApiPackageImpl#getProcessAuditSessionManager()
	 * @generated
	 */
	int PROCESS_AUDIT_SESSION_MANAGER = 0;

	/**
	 * The number of structural features of the '<em>Process Audit Session Manager</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Start Session</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___START_SESSION__STRING = 0;

	/**
	 * The operation id for the '<em>Get Current Session</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___GET_CURRENT_SESSION = 1;

	/**
	 * The operation id for the '<em>Set Current Session</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___SET_CURRENT_SESSION__PROCESSAUDITSESSION = 2;

	/**
	 * The operation id for the '<em>Clear Current Session</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___CLEAR_CURRENT_SESSION = 3;

	/**
	 * The operation id for the '<em>Get Session</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___GET_SESSION__STRING = 4;

	/**
	 * The operation id for the '<em>Get Active Sessions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___GET_ACTIVE_SESSIONS = 5;

	/**
	 * The operation id for the '<em>Get Completed Sessions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___GET_COMPLETED_SESSIONS = 6;

	/**
	 * The operation id for the '<em>Clear Completed Sessions</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER___CLEAR_COMPLETED_SESSIONS = 7;

	/**
	 * The number of operations of the '<em>Process Audit Session Manager</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_MANAGER_OPERATION_COUNT = 8;

	/**
	 * The meta object id for the '{@link org.gecko.mac.auditapi.ProcessAuditSession <em>Process Audit Session</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.auditapi.ProcessAuditSession
	 * @see org.gecko.mac.auditapi.impl.AuditApiPackageImpl#getProcessAuditSession()
	 * @generated
	 */
	int PROCESS_AUDIT_SESSION = 1;

	/**
	 * The number of structural features of the '<em>Process Audit Session</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_FEATURE_COUNT = 0;

	/**
	 * The operation id for the '<em>Get Session Id</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___GET_SESSION_ID = 0;

	/**
	 * The operation id for the '<em>Get Process Name</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___GET_PROCESS_NAME = 1;

	/**
	 * The operation id for the '<em>Get Start Time</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___GET_START_TIME = 2;

	/**
	 * The operation id for the '<em>Add Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___ADD_CONTEXT__STRING_OBJECT = 3;

	/**
	 * The operation id for the '<em>Get Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___GET_CONTEXT__STRING = 4;

	/**
	 * The operation id for the '<em>Get All Context</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___GET_ALL_CONTEXT = 5;

	/**
	 * The operation id for the '<em>Checkpoint</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___CHECKPOINT__STRING = 6;

	/**
	 * The operation id for the '<em>Checkpoint</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___CHECKPOINT__STRING_STRING = 7;

	/**
	 * The operation id for the '<em>Checkpoint</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___CHECKPOINT__STRING_AUDIT = 8;

	/**
	 * The operation id for the '<em>Error</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___ERROR__STRING_STRING_THROWABLE = 9;

	/**
	 * The operation id for the '<em>Complete</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___COMPLETE__STRING = 10;

	/**
	 * The operation id for the '<em>Fail</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___FAIL__STRING = 11;

	/**
	 * The operation id for the '<em>Is Active</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___IS_ACTIVE = 12;

	/**
	 * The operation id for the '<em>Get Events</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___GET_EVENTS = 13;

	/**
	 * The operation id for the '<em>Add Method Call</em>' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION___ADD_METHOD_CALL__STRING_STRING_LONG_THROWABLE = 14;

	/**
	 * The number of operations of the '<em>Process Audit Session</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESS_AUDIT_SESSION_OPERATION_COUNT = 15;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager <em>Process Audit Session Manager</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Audit Session Manager</em>'.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager
	 * @generated
	 */
	EClass getProcessAuditSessionManager();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#startSession(java.lang.String) <em>Start Session</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Start Session</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#startSession(java.lang.String)
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__StartSession__String();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#getCurrentSession() <em>Get Current Session</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Current Session</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#getCurrentSession()
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__GetCurrentSession();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#setCurrentSession(org.gecko.mac.auditapi.ProcessAuditSession) <em>Set Current Session</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Set Current Session</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#setCurrentSession(org.gecko.mac.auditapi.ProcessAuditSession)
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__SetCurrentSession__ProcessAuditSession();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#clearCurrentSession() <em>Clear Current Session</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Clear Current Session</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#clearCurrentSession()
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__ClearCurrentSession();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#getSession(java.lang.String) <em>Get Session</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Session</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#getSession(java.lang.String)
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__GetSession__String();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#getActiveSessions() <em>Get Active Sessions</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Active Sessions</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#getActiveSessions()
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__GetActiveSessions();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#getCompletedSessions() <em>Get Completed Sessions</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Completed Sessions</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#getCompletedSessions()
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__GetCompletedSessions();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager#clearCompletedSessions() <em>Clear Completed Sessions</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Clear Completed Sessions</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager#clearCompletedSessions()
	 * @generated
	 */
	EOperation getProcessAuditSessionManager__ClearCompletedSessions();

	/**
	 * Returns the meta object for class '{@link org.gecko.mac.auditapi.ProcessAuditSession <em>Process Audit Session</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Process Audit Session</em>'.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession
	 * @generated
	 */
	EClass getProcessAuditSession();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#getSessionId() <em>Get Session Id</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Session Id</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#getSessionId()
	 * @generated
	 */
	EOperation getProcessAuditSession__GetSessionId();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#getProcessName() <em>Get Process Name</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Process Name</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#getProcessName()
	 * @generated
	 */
	EOperation getProcessAuditSession__GetProcessName();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#getStartTime() <em>Get Start Time</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Start Time</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#getStartTime()
	 * @generated
	 */
	EOperation getProcessAuditSession__GetStartTime();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#addContext(java.lang.String, java.lang.Object) <em>Add Context</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Add Context</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#addContext(java.lang.String, java.lang.Object)
	 * @generated
	 */
	EOperation getProcessAuditSession__AddContext__String_Object();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#getContext(java.lang.String) <em>Get Context</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Context</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#getContext(java.lang.String)
	 * @generated
	 */
	EOperation getProcessAuditSession__GetContext__String();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#getAllContext() <em>Get All Context</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get All Context</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#getAllContext()
	 * @generated
	 */
	EOperation getProcessAuditSession__GetAllContext();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#checkpoint(java.lang.String) <em>Checkpoint</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Checkpoint</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#checkpoint(java.lang.String)
	 * @generated
	 */
	EOperation getProcessAuditSession__Checkpoint__String();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#checkpoint(java.lang.String, java.lang.String) <em>Checkpoint</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Checkpoint</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#checkpoint(java.lang.String, java.lang.String)
	 * @generated
	 */
	EOperation getProcessAuditSession__Checkpoint__String_String();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#checkpoint(java.lang.String, org.gecko.mac.audit.Audit) <em>Checkpoint</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Checkpoint</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#checkpoint(java.lang.String, org.gecko.mac.audit.Audit)
	 * @generated
	 */
	EOperation getProcessAuditSession__Checkpoint__String_Audit();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#error(java.lang.String, java.lang.String, java.lang.Throwable) <em>Error</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Error</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#error(java.lang.String, java.lang.String, java.lang.Throwable)
	 * @generated
	 */
	EOperation getProcessAuditSession__Error__String_String_Throwable();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#complete(java.lang.String) <em>Complete</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Complete</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#complete(java.lang.String)
	 * @generated
	 */
	EOperation getProcessAuditSession__Complete__String();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#fail(java.lang.String) <em>Fail</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Fail</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#fail(java.lang.String)
	 * @generated
	 */
	EOperation getProcessAuditSession__Fail__String();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#isActive() <em>Is Active</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Is Active</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#isActive()
	 * @generated
	 */
	EOperation getProcessAuditSession__IsActive();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#getEvents() <em>Get Events</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Get Events</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#getEvents()
	 * @generated
	 */
	EOperation getProcessAuditSession__GetEvents();

	/**
	 * Returns the meta object for the '{@link org.gecko.mac.auditapi.ProcessAuditSession#addMethodCall(java.lang.String, java.lang.String, java.lang.Long, java.lang.Throwable) <em>Add Method Call</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the '<em>Add Method Call</em>' operation.
	 * @see org.gecko.mac.auditapi.ProcessAuditSession#addMethodCall(java.lang.String, java.lang.String, java.lang.Long, java.lang.Throwable)
	 * @generated
	 */
	EOperation getProcessAuditSession__AddMethodCall__String_String_Long_Throwable();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	AuditApiFactory getAuditApiFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.auditapi.ProcessAuditSessionManager <em>Process Audit Session Manager</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.auditapi.ProcessAuditSessionManager
		 * @see org.gecko.mac.auditapi.impl.AuditApiPackageImpl#getProcessAuditSessionManager()
		 * @generated
		 */
		EClass PROCESS_AUDIT_SESSION_MANAGER = eINSTANCE.getProcessAuditSessionManager();

		/**
		 * The meta object literal for the '<em><b>Start Session</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___START_SESSION__STRING = eINSTANCE.getProcessAuditSessionManager__StartSession__String();

		/**
		 * The meta object literal for the '<em><b>Get Current Session</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___GET_CURRENT_SESSION = eINSTANCE.getProcessAuditSessionManager__GetCurrentSession();

		/**
		 * The meta object literal for the '<em><b>Set Current Session</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___SET_CURRENT_SESSION__PROCESSAUDITSESSION = eINSTANCE.getProcessAuditSessionManager__SetCurrentSession__ProcessAuditSession();

		/**
		 * The meta object literal for the '<em><b>Clear Current Session</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___CLEAR_CURRENT_SESSION = eINSTANCE.getProcessAuditSessionManager__ClearCurrentSession();

		/**
		 * The meta object literal for the '<em><b>Get Session</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___GET_SESSION__STRING = eINSTANCE.getProcessAuditSessionManager__GetSession__String();

		/**
		 * The meta object literal for the '<em><b>Get Active Sessions</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___GET_ACTIVE_SESSIONS = eINSTANCE.getProcessAuditSessionManager__GetActiveSessions();

		/**
		 * The meta object literal for the '<em><b>Get Completed Sessions</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___GET_COMPLETED_SESSIONS = eINSTANCE.getProcessAuditSessionManager__GetCompletedSessions();

		/**
		 * The meta object literal for the '<em><b>Clear Completed Sessions</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION_MANAGER___CLEAR_COMPLETED_SESSIONS = eINSTANCE.getProcessAuditSessionManager__ClearCompletedSessions();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.auditapi.ProcessAuditSession <em>Process Audit Session</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.auditapi.ProcessAuditSession
		 * @see org.gecko.mac.auditapi.impl.AuditApiPackageImpl#getProcessAuditSession()
		 * @generated
		 */
		EClass PROCESS_AUDIT_SESSION = eINSTANCE.getProcessAuditSession();

		/**
		 * The meta object literal for the '<em><b>Get Session Id</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___GET_SESSION_ID = eINSTANCE.getProcessAuditSession__GetSessionId();

		/**
		 * The meta object literal for the '<em><b>Get Process Name</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___GET_PROCESS_NAME = eINSTANCE.getProcessAuditSession__GetProcessName();

		/**
		 * The meta object literal for the '<em><b>Get Start Time</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___GET_START_TIME = eINSTANCE.getProcessAuditSession__GetStartTime();

		/**
		 * The meta object literal for the '<em><b>Add Context</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___ADD_CONTEXT__STRING_OBJECT = eINSTANCE.getProcessAuditSession__AddContext__String_Object();

		/**
		 * The meta object literal for the '<em><b>Get Context</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___GET_CONTEXT__STRING = eINSTANCE.getProcessAuditSession__GetContext__String();

		/**
		 * The meta object literal for the '<em><b>Get All Context</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___GET_ALL_CONTEXT = eINSTANCE.getProcessAuditSession__GetAllContext();

		/**
		 * The meta object literal for the '<em><b>Checkpoint</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___CHECKPOINT__STRING = eINSTANCE.getProcessAuditSession__Checkpoint__String();

		/**
		 * The meta object literal for the '<em><b>Checkpoint</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___CHECKPOINT__STRING_STRING = eINSTANCE.getProcessAuditSession__Checkpoint__String_String();

		/**
		 * The meta object literal for the '<em><b>Checkpoint</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___CHECKPOINT__STRING_AUDIT = eINSTANCE.getProcessAuditSession__Checkpoint__String_Audit();

		/**
		 * The meta object literal for the '<em><b>Error</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___ERROR__STRING_STRING_THROWABLE = eINSTANCE.getProcessAuditSession__Error__String_String_Throwable();

		/**
		 * The meta object literal for the '<em><b>Complete</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___COMPLETE__STRING = eINSTANCE.getProcessAuditSession__Complete__String();

		/**
		 * The meta object literal for the '<em><b>Fail</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___FAIL__STRING = eINSTANCE.getProcessAuditSession__Fail__String();

		/**
		 * The meta object literal for the '<em><b>Is Active</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___IS_ACTIVE = eINSTANCE.getProcessAuditSession__IsActive();

		/**
		 * The meta object literal for the '<em><b>Get Events</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___GET_EVENTS = eINSTANCE.getProcessAuditSession__GetEvents();

		/**
		 * The meta object literal for the '<em><b>Add Method Call</b></em>' operation.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EOperation PROCESS_AUDIT_SESSION___ADD_METHOD_CALL__STRING_STRING_LONG_THROWABLE = eINSTANCE.getProcessAuditSession__AddMethodCall__String_String_Long_Throwable();

	}

} //AuditApiPackage
