/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.mac.auditapi;

import java.time.Instant;

import java.util.Map;

import org.eclipse.emf.common.util.EList;

import org.gecko.mac.audit.Audit;
import org.gecko.mac.audit.AuditEventData;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Process Audit Session</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Process audit session interface for tracking business flows and method calls across threads
 * <!-- end-model-doc -->
 *
 *
 * @see org.gecko.mac.auditapi.AuditApiPackage#getProcessAuditSession()
 * @model interface="true" abstract="true"
 * @generated
 */
@ProviderType
public interface ProcessAuditSession {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get the unique session identifier
	 * <!-- end-model-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	String getSessionId();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get the process name
	 * <!-- end-model-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	String getProcessName();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get the session start time
	 * <!-- end-model-doc -->
	 * @model kind="operation" dataType="org.gecko.mac.audit.Instant" required="true"
	 * @generated
	 */
	Instant getStartTime();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Add contextual information to the session
	 * <!-- end-model-doc -->
	 * @model keyRequired="true" valueRequired="true"
	 * @generated
	 */
	void addContext(String key, Object value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get contextual information from the session
	 * <!-- end-model-doc -->
	 * @model keyRequired="true"
	 * @generated
	 */
	Object getContext(String key);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get all context as map
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	Map<String, Object> getAllContext();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Record a checkpoint in the process flow
	 * <!-- end-model-doc -->
	 * @model checkpointRequired="true"
	 * @generated
	 */
	void checkpoint(String checkpoint);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Record a checkpoint with details
	 * <!-- end-model-doc -->
	 * @model checkpointRequired="true"
	 * @generated
	 */
	void checkpoint(String checkpoint, String details);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Record a checkpoint with an Audit
	 * <!-- end-model-doc -->
	 * @model checkpointRequired="true"
	 * @generated
	 */
	void checkpoint(String checkpoint, Audit audit);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Record an error in the process
	 * <!-- end-model-doc -->
	 * @model checkpointRequired="true" messageRequired="true" exceptionDataType="org.gecko.mac.audit.Throwable"
	 * @generated
	 */
	void error(String checkpoint, String message, Throwable exception);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Complete the session successfully
	 * <!-- end-model-doc -->
	 * @model resultRequired="true"
	 * @generated
	 */
	void complete(String result);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Complete the session with failure
	 * <!-- end-model-doc -->
	 * @model reasonRequired="true"
	 * @generated
	 */
	void fail(String reason);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Check if session is active
	 * <!-- end-model-doc -->
	 * @model kind="operation" required="true"
	 * @generated
	 */
	Boolean isActive();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get all audit events recorded in this session
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	EList<AuditEventData> getEvents();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Add method call event (used by proxy)
	 * <!-- end-model-doc -->
	 * @model serviceNameRequired="true" methodNameRequired="true" exceptionDataType="org.gecko.mac.audit.Throwable"
	 * @generated
	 */
	void addMethodCall(String serviceName, String methodName, Long durationNs, Throwable exception);

} // ProcessAuditSession
