/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.mac.auditapi;

import org.eclipse.emf.common.util.EList;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Process Audit Session Manager</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * Session manager for process audit sessions with thread-local management and MDC integration
 * <!-- end-model-doc -->
 *
 *
 * @see org.gecko.mac.auditapi.AuditApiPackage#getProcessAuditSessionManager()
 * @model interface="true" abstract="true"
 * @generated
 */
@ProviderType
public interface ProcessAuditSessionManager {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Start a new process audit session and set it as current for this thread
	 * <!-- end-model-doc -->
	 * @model processNameRequired="true"
	 * @generated
	 */
	ProcessAuditSession startSession(String processName);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get the current session for this thread (may be null)
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	ProcessAuditSession getCurrentSession();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Set the current session for this thread (enables session handover between threads)
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	void setCurrentSession(ProcessAuditSession session);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Clear the current session for this thread
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	void clearCurrentSession();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get a session by ID (useful for handover scenarios)
	 * <!-- end-model-doc -->
	 * @model sessionIdRequired="true"
	 * @generated
	 */
	ProcessAuditSession getSession(String sessionId);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get all active sessions across all threads
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	EList<ProcessAuditSession> getActiveSessions();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Get all completed sessions
	 * <!-- end-model-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	EList<ProcessAuditSession> getCompletedSessions();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Clear completed sessions from memory
	 * <!-- end-model-doc -->
	 * @model
	 * @generated
	 */
	void clearCompletedSessions();

} // ProcessAuditSessionManager
