/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package org.gecko.mac.auditapi.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.mac.audit.AuditPackage;

import org.gecko.mac.auditapi.AuditApiFactory;
import org.gecko.mac.auditapi.AuditApiPackage;
import org.gecko.mac.auditapi.ProcessAuditSession;
import org.gecko.mac.auditapi.ProcessAuditSessionManager;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class AuditApiPackageImpl extends EPackageImpl implements AuditApiPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processAuditSessionManagerEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass processAuditSessionEClass = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.mac.auditapi.AuditApiPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private AuditApiPackageImpl() {
		super(eNS_URI, AuditApiFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link AuditApiPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static AuditApiPackage init() {
		if (isInited) return (AuditApiPackage)EPackage.Registry.INSTANCE.getEPackage(AuditApiPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredAuditApiPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		AuditApiPackageImpl theAuditApiPackage = registeredAuditApiPackage instanceof AuditApiPackageImpl ? (AuditApiPackageImpl)registeredAuditApiPackage : new AuditApiPackageImpl();

		isInited = true;

		// Initialize simple dependencies
		AuditPackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theAuditApiPackage.createPackageContents();

		// Initialize created meta-data
		theAuditApiPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theAuditApiPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(AuditApiPackage.eNS_URI, theAuditApiPackage);
		return theAuditApiPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProcessAuditSessionManager() {
		return processAuditSessionManagerEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__StartSession__String() {
		return processAuditSessionManagerEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__GetCurrentSession() {
		return processAuditSessionManagerEClass.getEOperations().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__SetCurrentSession__ProcessAuditSession() {
		return processAuditSessionManagerEClass.getEOperations().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__ClearCurrentSession() {
		return processAuditSessionManagerEClass.getEOperations().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__GetSession__String() {
		return processAuditSessionManagerEClass.getEOperations().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__GetActiveSessions() {
		return processAuditSessionManagerEClass.getEOperations().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__GetCompletedSessions() {
		return processAuditSessionManagerEClass.getEOperations().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSessionManager__ClearCompletedSessions() {
		return processAuditSessionManagerEClass.getEOperations().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getProcessAuditSession() {
		return processAuditSessionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__GetSessionId() {
		return processAuditSessionEClass.getEOperations().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__GetProcessName() {
		return processAuditSessionEClass.getEOperations().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__GetStartTime() {
		return processAuditSessionEClass.getEOperations().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__AddContext__String_Object() {
		return processAuditSessionEClass.getEOperations().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__GetContext__String() {
		return processAuditSessionEClass.getEOperations().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__GetAllContext() {
		return processAuditSessionEClass.getEOperations().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__Checkpoint__String() {
		return processAuditSessionEClass.getEOperations().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__Checkpoint__String_String() {
		return processAuditSessionEClass.getEOperations().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__Checkpoint__String_Audit() {
		return processAuditSessionEClass.getEOperations().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__Error__String_String_Throwable() {
		return processAuditSessionEClass.getEOperations().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__Complete__String() {
		return processAuditSessionEClass.getEOperations().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__Fail__String() {
		return processAuditSessionEClass.getEOperations().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__IsActive() {
		return processAuditSessionEClass.getEOperations().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__GetEvents() {
		return processAuditSessionEClass.getEOperations().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EOperation getProcessAuditSession__AddMethodCall__String_String_Long_Throwable() {
		return processAuditSessionEClass.getEOperations().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public AuditApiFactory getAuditApiFactory() {
		return (AuditApiFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		processAuditSessionManagerEClass = createEClass(PROCESS_AUDIT_SESSION_MANAGER);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___START_SESSION__STRING);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___GET_CURRENT_SESSION);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___SET_CURRENT_SESSION__PROCESSAUDITSESSION);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___CLEAR_CURRENT_SESSION);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___GET_SESSION__STRING);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___GET_ACTIVE_SESSIONS);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___GET_COMPLETED_SESSIONS);
		createEOperation(processAuditSessionManagerEClass, PROCESS_AUDIT_SESSION_MANAGER___CLEAR_COMPLETED_SESSIONS);

		processAuditSessionEClass = createEClass(PROCESS_AUDIT_SESSION);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___GET_SESSION_ID);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___GET_PROCESS_NAME);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___GET_START_TIME);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___ADD_CONTEXT__STRING_OBJECT);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___GET_CONTEXT__STRING);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___GET_ALL_CONTEXT);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___CHECKPOINT__STRING);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___CHECKPOINT__STRING_STRING);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___CHECKPOINT__STRING_AUDIT);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___ERROR__STRING_STRING_THROWABLE);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___COMPLETE__STRING);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___FAIL__STRING);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___IS_ACTIVE);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___GET_EVENTS);
		createEOperation(processAuditSessionEClass, PROCESS_AUDIT_SESSION___ADD_METHOD_CALL__STRING_STRING_LONG_THROWABLE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		AuditPackage theAuditPackage = (AuditPackage)EPackage.Registry.INSTANCE.getEPackage(AuditPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes, features, and operations; add parameters
		initEClass(processAuditSessionManagerEClass, ProcessAuditSessionManager.class, "ProcessAuditSessionManager", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		EOperation op = initEOperation(getProcessAuditSessionManager__StartSession__String(), this.getProcessAuditSession(), "startSession", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "processName", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSessionManager__GetCurrentSession(), this.getProcessAuditSession(), "getCurrentSession", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSessionManager__SetCurrentSession__ProcessAuditSession(), null, "setCurrentSession", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, this.getProcessAuditSession(), "session", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSessionManager__ClearCurrentSession(), null, "clearCurrentSession", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSessionManager__GetSession__String(), this.getProcessAuditSession(), "getSession", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "sessionId", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSessionManager__GetActiveSessions(), this.getProcessAuditSession(), "getActiveSessions", 0, -1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSessionManager__GetCompletedSessions(), this.getProcessAuditSession(), "getCompletedSessions", 0, -1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSessionManager__ClearCompletedSessions(), null, "clearCompletedSessions", 0, 1, IS_UNIQUE, IS_ORDERED);

		initEClass(processAuditSessionEClass, ProcessAuditSession.class, "ProcessAuditSession", IS_ABSTRACT, IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);

		initEOperation(getProcessAuditSession__GetSessionId(), ecorePackage.getEString(), "getSessionId", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSession__GetProcessName(), ecorePackage.getEString(), "getProcessName", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSession__GetStartTime(), theAuditPackage.getInstant(), "getStartTime", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__AddContext__String_Object(), null, "addContext", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "key", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEJavaObject(), "value", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__GetContext__String(), ecorePackage.getEJavaObject(), "getContext", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "key", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__GetAllContext(), null, "getAllContext", 0, 1, IS_UNIQUE, IS_ORDERED);
		EGenericType g1 = createEGenericType(ecorePackage.getEMap());
		EGenericType g2 = createEGenericType(ecorePackage.getEString());
		g1.getETypeArguments().add(g2);
		g2 = createEGenericType(ecorePackage.getEJavaObject());
		g1.getETypeArguments().add(g2);
		initEOperation(op, g1);

		op = initEOperation(getProcessAuditSession__Checkpoint__String(), null, "checkpoint", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "checkpoint", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__Checkpoint__String_String(), null, "checkpoint", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "checkpoint", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "details", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__Checkpoint__String_Audit(), null, "checkpoint", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "checkpoint", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theAuditPackage.getAudit(), "audit", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__Error__String_String_Throwable(), null, "error", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "checkpoint", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "message", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theAuditPackage.getThrowable(), "exception", 0, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__Complete__String(), null, "complete", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "result", 1, 1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__Fail__String(), null, "fail", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "reason", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSession__IsActive(), ecorePackage.getEBooleanObject(), "isActive", 1, 1, IS_UNIQUE, IS_ORDERED);

		initEOperation(getProcessAuditSession__GetEvents(), theAuditPackage.getAuditEventData(), "getEvents", 0, -1, IS_UNIQUE, IS_ORDERED);

		op = initEOperation(getProcessAuditSession__AddMethodCall__String_String_Long_Throwable(), null, "addMethodCall", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "serviceName", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getEString(), "methodName", 1, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, ecorePackage.getELongObject(), "durationNs", 0, 1, IS_UNIQUE, IS_ORDERED);
		addEParameter(op, theAuditPackage.getThrowable(), "exception", 0, 1, IS_UNIQUE, IS_ORDERED);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "modelName", "AuditApi",
			   "complianceLevel", "17.0",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n     Mark Hoffmann - initial API and implementation",
			   "resource", "XMI",
			   "prefix", "AuditApi",
			   "basePackage", "org.gecko.mac",
			   "rootExtendsInterface", "",
			   "oSGiCompatible", "true"
		   });
		addAnnotation
		  (processAuditSessionManagerEClass,
		   source,
		   new String[] {
			   "documentation", "Session manager for process audit sessions with thread-local management and MDC integration"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__StartSession__String(),
		   source,
		   new String[] {
			   "documentation", "Start a new process audit session and set it as current for this thread"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__GetCurrentSession(),
		   source,
		   new String[] {
			   "documentation", "Get the current session for this thread (may be null)"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__SetCurrentSession__ProcessAuditSession(),
		   source,
		   new String[] {
			   "documentation", "Set the current session for this thread (enables session handover between threads)"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__ClearCurrentSession(),
		   source,
		   new String[] {
			   "documentation", "Clear the current session for this thread"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__GetSession__String(),
		   source,
		   new String[] {
			   "documentation", "Get a session by ID (useful for handover scenarios)"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__GetActiveSessions(),
		   source,
		   new String[] {
			   "documentation", "Get all active sessions across all threads"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__GetCompletedSessions(),
		   source,
		   new String[] {
			   "documentation", "Get all completed sessions"
		   });
		addAnnotation
		  (getProcessAuditSessionManager__ClearCompletedSessions(),
		   source,
		   new String[] {
			   "documentation", "Clear completed sessions from memory"
		   });
		addAnnotation
		  (processAuditSessionEClass,
		   source,
		   new String[] {
			   "documentation", "Process audit session interface for tracking business flows and method calls across threads"
		   });
		addAnnotation
		  (getProcessAuditSession__GetSessionId(),
		   source,
		   new String[] {
			   "documentation", "Get the unique session identifier"
		   });
		addAnnotation
		  (getProcessAuditSession__GetProcessName(),
		   source,
		   new String[] {
			   "documentation", "Get the process name"
		   });
		addAnnotation
		  (getProcessAuditSession__GetStartTime(),
		   source,
		   new String[] {
			   "documentation", "Get the session start time"
		   });
		addAnnotation
		  (getProcessAuditSession__AddContext__String_Object(),
		   source,
		   new String[] {
			   "documentation", "Add contextual information to the session"
		   });
		addAnnotation
		  (getProcessAuditSession__GetContext__String(),
		   source,
		   new String[] {
			   "documentation", "Get contextual information from the session"
		   });
		addAnnotation
		  (getProcessAuditSession__GetAllContext(),
		   source,
		   new String[] {
			   "documentation", "Get all context as map"
		   });
		addAnnotation
		  (getProcessAuditSession__Checkpoint__String(),
		   source,
		   new String[] {
			   "documentation", "Record a checkpoint in the process flow"
		   });
		addAnnotation
		  (getProcessAuditSession__Checkpoint__String_String(),
		   source,
		   new String[] {
			   "documentation", "Record a checkpoint with details"
		   });
		addAnnotation
		  (getProcessAuditSession__Checkpoint__String_Audit(),
		   source,
		   new String[] {
			   "documentation", "Record a checkpoint with an Audit"
		   });
		addAnnotation
		  (getProcessAuditSession__Error__String_String_Throwable(),
		   source,
		   new String[] {
			   "documentation", "Record an error in the process"
		   });
		addAnnotation
		  (getProcessAuditSession__Complete__String(),
		   source,
		   new String[] {
			   "documentation", "Complete the session successfully"
		   });
		addAnnotation
		  (getProcessAuditSession__Fail__String(),
		   source,
		   new String[] {
			   "documentation", "Complete the session with failure"
		   });
		addAnnotation
		  (getProcessAuditSession__IsActive(),
		   source,
		   new String[] {
			   "documentation", "Check if session is active"
		   });
		addAnnotation
		  (getProcessAuditSession__GetEvents(),
		   source,
		   new String[] {
			   "documentation", "Get all audit events recorded in this session"
		   });
		addAnnotation
		  (getProcessAuditSession__AddMethodCall__String_String_Long_Throwable(),
		   source,
		   new String[] {
			   "documentation", "Add method call event (used by proxy)"
		   });
	}

} //AuditApiPackageImpl
