/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved. 
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motion - initial API and implementation
 */
package org.gecko.mac.event.handler;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

/**
 * 
 * @author ilenia
 * @since Oct 22, 2025
 */
@ObjectClassDefinition(name = "Event Handler Configuration")
public @interface AuditEventHandlerConfig {
	
	@AttributeDefinition(name = "Event Topic", description = "The topic this handler is listening to")
	String[] event_topics();
	
	@AttributeDefinition(name = "MQTT Forward Topic", description = "The MQTT topic this handler is forwarding to")
	String mqtt_forward_topic();

}
