/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.equipment;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Equipment Item</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.equipment.EquipmentItem#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.EquipmentItem#getType <em>Type</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.EquipmentItem#getDescription <em>Description</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.EquipmentItem#getSerialNumber <em>Serial Number</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.EquipmentItem#getHourlyRate <em>Hourly Rate</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.EquipmentItem#getDailyRate <em>Daily Rate</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.EquipmentItem#getStatus <em>Status</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem()
 * @model
 * @generated
 */
@ProviderType
public interface EquipmentItem extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem_Id()
	 * @model id="true" required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.equipment.EquipmentItem#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.mac.equipment.EquipmentType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.gecko.mac.equipment.EquipmentType
	 * @see #setType(EquipmentType)
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem_Type()
	 * @model
	 * @generated
	 */
	EquipmentType getType();

	/**
	 * Sets the value of the '{@link org.gecko.mac.equipment.EquipmentItem#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.gecko.mac.equipment.EquipmentType
	 * @see #getType()
	 * @generated
	 */
	void setType(EquipmentType value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.gecko.mac.equipment.EquipmentItem#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Serial Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Manufacturer's serial number for tracking.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Serial Number</em>' attribute.
	 * @see #setSerialNumber(String)
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem_SerialNumber()
	 * @model
	 * @generated
	 */
	String getSerialNumber();

	/**
	 * Sets the value of the '{@link org.gecko.mac.equipment.EquipmentItem#getSerialNumber <em>Serial Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Serial Number</em>' attribute.
	 * @see #getSerialNumber()
	 * @generated
	 */
	void setSerialNumber(String value);

	/**
	 * Returns the value of the '<em><b>Hourly Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The standard hourly rate for rental.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Hourly Rate</em>' attribute.
	 * @see #setHourlyRate(double)
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem_HourlyRate()
	 * @model
	 * @generated
	 */
	double getHourlyRate();

	/**
	 * Sets the value of the '{@link org.gecko.mac.equipment.EquipmentItem#getHourlyRate <em>Hourly Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Hourly Rate</em>' attribute.
	 * @see #getHourlyRate()
	 * @generated
	 */
	void setHourlyRate(double value);

	/**
	 * Returns the value of the '<em><b>Daily Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The standard daily  rate for rental.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Daily Rate</em>' attribute.
	 * @see #setDailyRate(double)
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem_DailyRate()
	 * @model
	 * @generated
	 */
	double getDailyRate();

	/**
	 * Sets the value of the '{@link org.gecko.mac.equipment.EquipmentItem#getDailyRate <em>Daily Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Daily Rate</em>' attribute.
	 * @see #getDailyRate()
	 * @generated
	 */
	void setDailyRate(double value);

	/**
	 * Returns the value of the '<em><b>Status</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.mac.equipment.EquipmentStatus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Status</em>' attribute.
	 * @see org.gecko.mac.equipment.EquipmentStatus
	 * @see #setStatus(EquipmentStatus)
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#getEquipmentItem_Status()
	 * @model
	 * @generated
	 */
	EquipmentStatus getStatus();

	/**
	 * Sets the value of the '{@link org.gecko.mac.equipment.EquipmentItem#getStatus <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' attribute.
	 * @see org.gecko.mac.equipment.EquipmentStatus
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(EquipmentStatus value);

} // EquipmentItem
