/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.equipment;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.equipment.GolfEquipmentFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel oSGiCompatible='true' resource='XMI' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motioni - initial API and implementation' basePackage='org.gecko.mac'"
 * @generated
 */
@ProviderType
@EPackage(uri = GolfEquipmentPackage.eNS_URI, genModel = "/model/golf-equipment.genmodel", genModelSourceLocations = {"model/golf-equipment.genmodel","org.gecko.mac.golf.equipment.model/model/golf-equipment.genmodel"}, ecore="/model/golf-equipment.ecore", ecoreSourceLocations="/model/golf-equipment.ecore")
public interface GolfEquipmentPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "equipment";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://datainmotion.com/mac/golf/equipment/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "equipment";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GolfEquipmentPackage eINSTANCE = org.gecko.mac.equipment.impl.GolfEquipmentPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.equipment.impl.EquipmentItemImpl <em>Equipment Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.equipment.impl.EquipmentItemImpl
	 * @see org.gecko.mac.equipment.impl.GolfEquipmentPackageImpl#getEquipmentItem()
	 * @generated
	 */
	int EQUIPMENT_ITEM = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM__ID = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Serial Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM__SERIAL_NUMBER = 3;

	/**
	 * The feature id for the '<em><b>Hourly Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM__HOURLY_RATE = 4;

	/**
	 * The feature id for the '<em><b>Daily Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM__DAILY_RATE = 5;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM__STATUS = 6;

	/**
	 * The number of structural features of the '<em>Equipment Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM_FEATURE_COUNT = 7;

	/**
	 * The number of operations of the '<em>Equipment Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EQUIPMENT_ITEM_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.equipment.EquipmentType <em>Equipment Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.equipment.EquipmentType
	 * @see org.gecko.mac.equipment.impl.GolfEquipmentPackageImpl#getEquipmentType()
	 * @generated
	 */
	int EQUIPMENT_TYPE = 1;

	/**
	 * The meta object id for the '{@link org.gecko.mac.equipment.EquipmentStatus <em>Equipment Status</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.equipment.EquipmentStatus
	 * @see org.gecko.mac.equipment.impl.GolfEquipmentPackageImpl#getEquipmentStatus()
	 * @generated
	 */
	int EQUIPMENT_STATUS = 2;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.equipment.EquipmentItem <em>Equipment Item</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Equipment Item</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem
	 * @generated
	 */
	EClass getEquipmentItem();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.equipment.EquipmentItem#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem#getId()
	 * @see #getEquipmentItem()
	 * @generated
	 */
	EAttribute getEquipmentItem_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.equipment.EquipmentItem#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem#getType()
	 * @see #getEquipmentItem()
	 * @generated
	 */
	EAttribute getEquipmentItem_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.equipment.EquipmentItem#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem#getDescription()
	 * @see #getEquipmentItem()
	 * @generated
	 */
	EAttribute getEquipmentItem_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.equipment.EquipmentItem#getSerialNumber <em>Serial Number</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Serial Number</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem#getSerialNumber()
	 * @see #getEquipmentItem()
	 * @generated
	 */
	EAttribute getEquipmentItem_SerialNumber();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.equipment.EquipmentItem#getHourlyRate <em>Hourly Rate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Hourly Rate</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem#getHourlyRate()
	 * @see #getEquipmentItem()
	 * @generated
	 */
	EAttribute getEquipmentItem_HourlyRate();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.equipment.EquipmentItem#getDailyRate <em>Daily Rate</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Daily Rate</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem#getDailyRate()
	 * @see #getEquipmentItem()
	 * @generated
	 */
	EAttribute getEquipmentItem_DailyRate();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.equipment.EquipmentItem#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.gecko.mac.equipment.EquipmentItem#getStatus()
	 * @see #getEquipmentItem()
	 * @generated
	 */
	EAttribute getEquipmentItem_Status();

	/**
	 * Returns the meta object for enum '{@link org.gecko.mac.equipment.EquipmentType <em>Equipment Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Equipment Type</em>'.
	 * @see org.gecko.mac.equipment.EquipmentType
	 * @generated
	 */
	EEnum getEquipmentType();

	/**
	 * Returns the meta object for enum '{@link org.gecko.mac.equipment.EquipmentStatus <em>Equipment Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Equipment Status</em>'.
	 * @see org.gecko.mac.equipment.EquipmentStatus
	 * @generated
	 */
	EEnum getEquipmentStatus();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	GolfEquipmentFactory getGolfEquipmentFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.equipment.impl.EquipmentItemImpl <em>Equipment Item</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.equipment.impl.EquipmentItemImpl
		 * @see org.gecko.mac.equipment.impl.GolfEquipmentPackageImpl#getEquipmentItem()
		 * @generated
		 */
		EClass EQUIPMENT_ITEM = eINSTANCE.getEquipmentItem();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EQUIPMENT_ITEM__ID = eINSTANCE.getEquipmentItem_Id();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EQUIPMENT_ITEM__TYPE = eINSTANCE.getEquipmentItem_Type();

		/**
		 * The meta object literal for the '<em><b>Description</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EQUIPMENT_ITEM__DESCRIPTION = eINSTANCE.getEquipmentItem_Description();

		/**
		 * The meta object literal for the '<em><b>Serial Number</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EQUIPMENT_ITEM__SERIAL_NUMBER = eINSTANCE.getEquipmentItem_SerialNumber();

		/**
		 * The meta object literal for the '<em><b>Hourly Rate</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EQUIPMENT_ITEM__HOURLY_RATE = eINSTANCE.getEquipmentItem_HourlyRate();

		/**
		 * The meta object literal for the '<em><b>Daily Rate</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EQUIPMENT_ITEM__DAILY_RATE = eINSTANCE.getEquipmentItem_DailyRate();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EQUIPMENT_ITEM__STATUS = eINSTANCE.getEquipmentItem_Status();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.equipment.EquipmentType <em>Equipment Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.equipment.EquipmentType
		 * @see org.gecko.mac.equipment.impl.GolfEquipmentPackageImpl#getEquipmentType()
		 * @generated
		 */
		EEnum EQUIPMENT_TYPE = eINSTANCE.getEquipmentType();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.equipment.EquipmentStatus <em>Equipment Status</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.equipment.EquipmentStatus
		 * @see org.gecko.mac.equipment.impl.GolfEquipmentPackageImpl#getEquipmentStatus()
		 * @generated
		 */
		EEnum EQUIPMENT_STATUS = eINSTANCE.getEquipmentStatus();

	}

} //GolfEquipmentPackage
