/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.equipment.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.gecko.mac.equipment.EquipmentItem;
import org.gecko.mac.equipment.EquipmentStatus;
import org.gecko.mac.equipment.EquipmentType;
import org.gecko.mac.equipment.GolfEquipmentPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Equipment Item</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.equipment.impl.EquipmentItemImpl#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.impl.EquipmentItemImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.impl.EquipmentItemImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.impl.EquipmentItemImpl#getSerialNumber <em>Serial Number</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.impl.EquipmentItemImpl#getHourlyRate <em>Hourly Rate</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.impl.EquipmentItemImpl#getDailyRate <em>Daily Rate</em>}</li>
 *   <li>{@link org.gecko.mac.equipment.impl.EquipmentItemImpl#getStatus <em>Status</em>}</li>
 * </ul>
 *
 * @generated
 */
public class EquipmentItemImpl extends MinimalEObjectImpl.Container implements EquipmentItem {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final EquipmentType TYPE_EDEFAULT = EquipmentType.GOLF_CART;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected EquipmentType type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getSerialNumber() <em>Serial Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSerialNumber()
	 * @generated
	 * @ordered
	 */
	protected static final String SERIAL_NUMBER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSerialNumber() <em>Serial Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSerialNumber()
	 * @generated
	 * @ordered
	 */
	protected String serialNumber = SERIAL_NUMBER_EDEFAULT;

	/**
	 * The default value of the '{@link #getHourlyRate() <em>Hourly Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHourlyRate()
	 * @generated
	 * @ordered
	 */
	protected static final double HOURLY_RATE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getHourlyRate() <em>Hourly Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHourlyRate()
	 * @generated
	 * @ordered
	 */
	protected double hourlyRate = HOURLY_RATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDailyRate() <em>Daily Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDailyRate()
	 * @generated
	 * @ordered
	 */
	protected static final double DAILY_RATE_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getDailyRate() <em>Daily Rate</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDailyRate()
	 * @generated
	 * @ordered
	 */
	protected double dailyRate = DAILY_RATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected static final EquipmentStatus STATUS_EDEFAULT = EquipmentStatus.AVAILABLE;

	/**
	 * The cached value of the '{@link #getStatus() <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStatus()
	 * @generated
	 * @ordered
	 */
	protected EquipmentStatus status = STATUS_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EquipmentItemImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfEquipmentPackage.Literals.EQUIPMENT_ITEM;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfEquipmentPackage.EQUIPMENT_ITEM__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EquipmentType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(EquipmentType newType) {
		EquipmentType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfEquipmentPackage.EQUIPMENT_ITEM__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfEquipmentPackage.EQUIPMENT_ITEM__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getSerialNumber() {
		return serialNumber;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSerialNumber(String newSerialNumber) {
		String oldSerialNumber = serialNumber;
		serialNumber = newSerialNumber;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfEquipmentPackage.EQUIPMENT_ITEM__SERIAL_NUMBER, oldSerialNumber, serialNumber));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getHourlyRate() {
		return hourlyRate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHourlyRate(double newHourlyRate) {
		double oldHourlyRate = hourlyRate;
		hourlyRate = newHourlyRate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfEquipmentPackage.EQUIPMENT_ITEM__HOURLY_RATE, oldHourlyRate, hourlyRate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getDailyRate() {
		return dailyRate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDailyRate(double newDailyRate) {
		double oldDailyRate = dailyRate;
		dailyRate = newDailyRate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfEquipmentPackage.EQUIPMENT_ITEM__DAILY_RATE, oldDailyRate, dailyRate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EquipmentStatus getStatus() {
		return status;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStatus(EquipmentStatus newStatus) {
		EquipmentStatus oldStatus = status;
		status = newStatus == null ? STATUS_EDEFAULT : newStatus;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfEquipmentPackage.EQUIPMENT_ITEM__STATUS, oldStatus, status));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfEquipmentPackage.EQUIPMENT_ITEM__ID:
				return getId();
			case GolfEquipmentPackage.EQUIPMENT_ITEM__TYPE:
				return getType();
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DESCRIPTION:
				return getDescription();
			case GolfEquipmentPackage.EQUIPMENT_ITEM__SERIAL_NUMBER:
				return getSerialNumber();
			case GolfEquipmentPackage.EQUIPMENT_ITEM__HOURLY_RATE:
				return getHourlyRate();
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DAILY_RATE:
				return getDailyRate();
			case GolfEquipmentPackage.EQUIPMENT_ITEM__STATUS:
				return getStatus();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfEquipmentPackage.EQUIPMENT_ITEM__ID:
				setId((String)newValue);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__TYPE:
				setType((EquipmentType)newValue);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__SERIAL_NUMBER:
				setSerialNumber((String)newValue);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__HOURLY_RATE:
				setHourlyRate((Double)newValue);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DAILY_RATE:
				setDailyRate((Double)newValue);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__STATUS:
				setStatus((EquipmentStatus)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfEquipmentPackage.EQUIPMENT_ITEM__ID:
				setId(ID_EDEFAULT);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__SERIAL_NUMBER:
				setSerialNumber(SERIAL_NUMBER_EDEFAULT);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__HOURLY_RATE:
				setHourlyRate(HOURLY_RATE_EDEFAULT);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DAILY_RATE:
				setDailyRate(DAILY_RATE_EDEFAULT);
				return;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__STATUS:
				setStatus(STATUS_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfEquipmentPackage.EQUIPMENT_ITEM__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case GolfEquipmentPackage.EQUIPMENT_ITEM__TYPE:
				return type != TYPE_EDEFAULT;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case GolfEquipmentPackage.EQUIPMENT_ITEM__SERIAL_NUMBER:
				return SERIAL_NUMBER_EDEFAULT == null ? serialNumber != null : !SERIAL_NUMBER_EDEFAULT.equals(serialNumber);
			case GolfEquipmentPackage.EQUIPMENT_ITEM__HOURLY_RATE:
				return hourlyRate != HOURLY_RATE_EDEFAULT;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__DAILY_RATE:
				return dailyRate != DAILY_RATE_EDEFAULT;
			case GolfEquipmentPackage.EQUIPMENT_ITEM__STATUS:
				return status != STATUS_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", type: ");
		result.append(type);
		result.append(", description: ");
		result.append(description);
		result.append(", serialNumber: ");
		result.append(serialNumber);
		result.append(", hourlyRate: ");
		result.append(hourlyRate);
		result.append(", dailyRate: ");
		result.append(dailyRate);
		result.append(", status: ");
		result.append(status);
		result.append(')');
		return result.toString();
	}

} //EquipmentItemImpl
