/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.equipment.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EPackageImpl;

import org.gecko.mac.equipment.EquipmentItem;
import org.gecko.mac.equipment.EquipmentStatus;
import org.gecko.mac.equipment.EquipmentType;
import org.gecko.mac.equipment.GolfEquipmentFactory;
import org.gecko.mac.equipment.GolfEquipmentPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class GolfEquipmentPackageImpl extends EPackageImpl implements GolfEquipmentPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass equipmentItemEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum equipmentTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum equipmentStatusEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.gecko.mac.equipment.GolfEquipmentPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private GolfEquipmentPackageImpl() {
		super(eNS_URI, GolfEquipmentFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link GolfEquipmentPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static GolfEquipmentPackage init() {
		if (isInited) return (GolfEquipmentPackage)EPackage.Registry.INSTANCE.getEPackage(GolfEquipmentPackage.eNS_URI);

		// Obtain or create and register package
		Object registeredGolfEquipmentPackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		GolfEquipmentPackageImpl theGolfEquipmentPackage = registeredGolfEquipmentPackage instanceof GolfEquipmentPackageImpl ? (GolfEquipmentPackageImpl)registeredGolfEquipmentPackage : new GolfEquipmentPackageImpl();

		isInited = true;

		// Create package meta-data objects
		theGolfEquipmentPackage.createPackageContents();

		// Initialize created meta-data
		theGolfEquipmentPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theGolfEquipmentPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(GolfEquipmentPackage.eNS_URI, theGolfEquipmentPackage);
		return theGolfEquipmentPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getEquipmentItem() {
		return equipmentItemEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEquipmentItem_Id() {
		return (EAttribute)equipmentItemEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEquipmentItem_Type() {
		return (EAttribute)equipmentItemEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEquipmentItem_Description() {
		return (EAttribute)equipmentItemEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEquipmentItem_SerialNumber() {
		return (EAttribute)equipmentItemEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEquipmentItem_HourlyRate() {
		return (EAttribute)equipmentItemEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEquipmentItem_DailyRate() {
		return (EAttribute)equipmentItemEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getEquipmentItem_Status() {
		return (EAttribute)equipmentItemEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getEquipmentType() {
		return equipmentTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getEquipmentStatus() {
		return equipmentStatusEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GolfEquipmentFactory getGolfEquipmentFactory() {
		return (GolfEquipmentFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		equipmentItemEClass = createEClass(EQUIPMENT_ITEM);
		createEAttribute(equipmentItemEClass, EQUIPMENT_ITEM__ID);
		createEAttribute(equipmentItemEClass, EQUIPMENT_ITEM__TYPE);
		createEAttribute(equipmentItemEClass, EQUIPMENT_ITEM__DESCRIPTION);
		createEAttribute(equipmentItemEClass, EQUIPMENT_ITEM__SERIAL_NUMBER);
		createEAttribute(equipmentItemEClass, EQUIPMENT_ITEM__HOURLY_RATE);
		createEAttribute(equipmentItemEClass, EQUIPMENT_ITEM__DAILY_RATE);
		createEAttribute(equipmentItemEClass, EQUIPMENT_ITEM__STATUS);

		// Create enums
		equipmentTypeEEnum = createEEnum(EQUIPMENT_TYPE);
		equipmentStatusEEnum = createEEnum(EQUIPMENT_STATUS);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes, features, and operations; add parameters
		initEClass(equipmentItemEClass, EquipmentItem.class, "EquipmentItem", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getEquipmentItem_Id(), ecorePackage.getEString(), "id", null, 1, 1, EquipmentItem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEquipmentItem_Type(), this.getEquipmentType(), "type", null, 0, 1, EquipmentItem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEquipmentItem_Description(), ecorePackage.getEString(), "description", null, 0, 1, EquipmentItem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEquipmentItem_SerialNumber(), ecorePackage.getEString(), "serialNumber", null, 0, 1, EquipmentItem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEquipmentItem_HourlyRate(), ecorePackage.getEDouble(), "hourlyRate", null, 0, 1, EquipmentItem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEquipmentItem_DailyRate(), ecorePackage.getEDouble(), "dailyRate", null, 0, 1, EquipmentItem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getEquipmentItem_Status(), this.getEquipmentStatus(), "status", null, 0, 1, EquipmentItem.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(equipmentTypeEEnum, EquipmentType.class, "EquipmentType");
		addEEnumLiteral(equipmentTypeEEnum, EquipmentType.GOLF_CART);
		addEEnumLiteral(equipmentTypeEEnum, EquipmentType.CLUB_SET);
		addEEnumLiteral(equipmentTypeEEnum, EquipmentType.PULL_CART);

		initEEnum(equipmentStatusEEnum, EquipmentStatus.class, "EquipmentStatus");
		addEEnumLiteral(equipmentStatusEEnum, EquipmentStatus.AVAILABLE);
		addEEnumLiteral(equipmentStatusEEnum, EquipmentStatus.IN_USE);
		addEEnumLiteral(equipmentStatusEEnum, EquipmentStatus.MAINTENANCE);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// Version
		createVersionAnnotations();
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>Version</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createVersionAnnotations() {
		String source = "Version";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "value", "1.0"
		   });
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (this,
		   source,
		   new String[] {
			   "oSGiCompatible", "true",
			   "resource", "XMI",
			   "copyrightText", "Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motioni - initial API and implementation",
			   "basePackage", "org.gecko.mac"
		   });
		addAnnotation
		  (getEquipmentItem_SerialNumber(),
		   source,
		   new String[] {
			   "documentation", "Manufacturer\'s serial number for tracking."
		   });
		addAnnotation
		  (getEquipmentItem_HourlyRate(),
		   source,
		   new String[] {
			   "documentation", "The standard hourly rate for rental."
		   });
		addAnnotation
		  (getEquipmentItem_DailyRate(),
		   source,
		   new String[] {
			   "documentation", "The standard daily  rate for rental."
		   });
	}

} //GolfEquipmentPackageImpl
