/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Course Scorecard Info</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getHcpHole <em>Hcp Hole</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getParHole <em>Par Hole</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getParIn <em>Par In</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getManualParIn <em>Manual Par In</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getParOut <em>Par Out</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getManualParOut <em>Manual Par Out</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getParTotal <em>Par Total</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getManualParTotal <em>Manual Par Total</em>}</li>
 * </ul>
 *
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo()
 * @model
 * @generated
 */
@ProviderType
public interface CourseScorecardInfo extends EObject {
	/**
	 * Returns the value of the '<em><b>Hcp Hole</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.Integer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A hole handicap is a measure of its difficulty.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Hcp Hole</em>' attribute list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_HcpHole()
	 * @model unique="false"
	 * @generated
	 */
	EList<Integer> getHcpHole();

	/**
	 * Returns the value of the '<em><b>Par Hole</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.Integer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Par Hole</em>' attribute list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_ParHole()
	 * @model unique="false"
	 * @generated
	 */
	EList<Integer> getParHole();

	/**
	 * Returns the value of the '<em><b>Par In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sum of parHole for holes which go from the outside to the clubhouse. They usually are holes from 10 to 18.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Par In</em>' attribute.
	 * @see #setParIn(Integer)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_ParIn()
	 * @model
	 * @generated
	 */
	Integer getParIn();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getParIn <em>Par In</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Par In</em>' attribute.
	 * @see #getParIn()
	 * @generated
	 */
	void setParIn(Integer value);

	/**
	 * Returns the value of the '<em><b>Manual Par In</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is computed at validation time, if parIn from iGolf is set to zero or null and the number of holes of the golf course are more than 9. This is the sum of parHole for holes from 9 to 18.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Manual Par In</em>' attribute.
	 * @see #setManualParIn(int)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_ManualParIn()
	 * @model
	 * @generated
	 */
	int getManualParIn();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getManualParIn <em>Manual Par In</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Manual Par In</em>' attribute.
	 * @see #getManualParIn()
	 * @generated
	 */
	void setManualParIn(int value);

	/**
	 * Returns the value of the '<em><b>Par Out</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sum of parHole for holes which go from the clubhouse to ouside. They usually are holes from 1 to 9.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Par Out</em>' attribute.
	 * @see #setParOut(Integer)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_ParOut()
	 * @model
	 * @generated
	 */
	Integer getParOut();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getParOut <em>Par Out</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Par Out</em>' attribute.
	 * @see #getParOut()
	 * @generated
	 */
	void setParOut(Integer value);

	/**
	 * Returns the value of the '<em><b>Manual Par Out</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is computed at validation time, if parOut from iGolf is set to zero or null. This is simply the sum of parHole for holes from 1 to 9.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Manual Par Out</em>' attribute.
	 * @see #setManualParOut(int)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_ManualParOut()
	 * @model
	 * @generated
	 */
	int getManualParOut();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getManualParOut <em>Manual Par Out</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Manual Par Out</em>' attribute.
	 * @see #getManualParOut()
	 * @generated
	 */
	void setManualParOut(int value);

	/**
	 * Returns the value of the '<em><b>Par Total</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Sum of parIn plus parOut
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Par Total</em>' attribute.
	 * @see #setParTotal(Integer)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_ParTotal()
	 * @model
	 * @generated
	 */
	Integer getParTotal();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getParTotal <em>Par Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Par Total</em>' attribute.
	 * @see #getParTotal()
	 * @generated
	 */
	void setParTotal(Integer value);

	/**
	 * Returns the value of the '<em><b>Manual Par Total</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This is computed at validation time, in case the parTotal from iGolf is null or zero. The computation is simply the sum of all the non-zero parHole values.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Manual Par Total</em>' attribute.
	 * @see #setManualParTotal(int)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecardInfo_ManualParTotal()
	 * @model
	 * @generated
	 */
	int getManualParTotal();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo#getManualParTotal <em>Manual Par Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Manual Par Total</em>' attribute.
	 * @see #getManualParTotal()
	 * @generated
	 */
	void setManualParTotal(int value);

} // CourseScorecardInfo
