/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Course Scorecards</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards#getMenScorecard <em>Men Scorecard</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards#getWmnScorecard <em>Wmn Scorecard</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards#getCourseId <em>Course Id</em>}</li>
 * </ul>
 *
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecards()
 * @model
 * @generated
 */
@ProviderType
public interface CourseScorecards extends EObject {
	/**
	 * Returns the value of the '<em><b>Men Scorecard</b></em>' containment reference list.
	 * The list contents are of type {@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Men Scorecard</em>' containment reference list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecards_MenScorecard()
	 * @model containment="true"
	 * @generated
	 */
	EList<CourseScorecardInfo> getMenScorecard();

	/**
	 * Returns the value of the '<em><b>Wmn Scorecard</b></em>' containment reference list.
	 * The list contents are of type {@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Wmn Scorecard</em>' containment reference list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecards_WmnScorecard()
	 * @model containment="true"
	 * @generated
	 */
	EList<CourseScorecardInfo> getWmnScorecard();

	/**
	 * Returns the value of the '<em><b>Course Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Course Id</em>' attribute.
	 * @see #setCourseId(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getCourseScorecards_CourseId()
	 * @model required="true"
	 * @generated
	 */
	String getCourseId();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards#getCourseId <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Course Id</em>' attribute.
	 * @see #getCourseId()
	 * @generated
	 */
	void setCourseId(String value);

} // CourseScorecards
