/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import java.util.Date;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Golf Course</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getId <em>Id</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getCourseId <em>Course Id</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getCourseDetails <em>Course Details</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getCourseGPSVector <em>Course GPS Vector</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getScorecards <em>Scorecards</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getTee <em>Tee</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getValidationError <em>Validation Error</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isInvalid <em>Invalid</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isTotallyInvalid <em>Totally Invalid</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getLastValidationDate <em>Last Validation Date</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isDeleted <em>Deleted</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isHasOverlappingHoles <em>Has Overlapping Holes</em>}</li>
 * </ul>
 *
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse()
 * @model
 * @generated
 */
@ProviderType
public interface GolfCourse extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_Id()
	 * @model id="true" required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Course Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Course Id</em>' attribute.
	 * @see #setCourseId(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_CourseId()
	 * @model required="true"
	 * @generated
	 */
	String getCourseId();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getCourseId <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Course Id</em>' attribute.
	 * @see #getCourseId()
	 * @generated
	 */
	void setCourseId(String value);

	/**
	 * Returns the value of the '<em><b>Course Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Course Details</em>' containment reference.
	 * @see #setCourseDetails(CourseDetails)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_CourseDetails()
	 * @model containment="true"
	 * @generated
	 */
	CourseDetails getCourseDetails();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getCourseDetails <em>Course Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Course Details</em>' containment reference.
	 * @see #getCourseDetails()
	 * @generated
	 */
	void setCourseDetails(CourseDetails value);

	/**
	 * Returns the value of the '<em><b>Course GPS Vector</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Course GPS Vector</em>' containment reference.
	 * @see #setCourseGPSVector(CourseGPSVector)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_CourseGPSVector()
	 * @model containment="true"
	 * @generated
	 */
	CourseGPSVector getCourseGPSVector();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getCourseGPSVector <em>Course GPS Vector</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Course GPS Vector</em>' containment reference.
	 * @see #getCourseGPSVector()
	 * @generated
	 */
	void setCourseGPSVector(CourseGPSVector value);

	/**
	 * Returns the value of the '<em><b>Scorecards</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Scorecards</em>' containment reference.
	 * @see #setScorecards(CourseScorecards)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_Scorecards()
	 * @model containment="true"
	 * @generated
	 */
	CourseScorecards getScorecards();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getScorecards <em>Scorecards</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Scorecards</em>' containment reference.
	 * @see #getScorecards()
	 * @generated
	 */
	void setScorecards(CourseScorecards value);

	/**
	 * Returns the value of the '<em><b>Tee</b></em>' containment reference list.
	 * The list contents are of type {@link com.playertour.backend.golfcourse.model.golfcourse.Tee}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Tee</em>' containment reference list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_Tee()
	 * @model containment="true"
	 * @generated
	 */
	EList<Tee> getTee();

	/**
	 * Returns the value of the '<em><b>Validation Error</b></em>' attribute list.
	 * The list contents are of type {@link com.playertour.backend.golfcourse.model.golfcourse.ValidationErrorType}.
	 * The literals are from the enumeration {@link com.playertour.backend.golfcourse.model.golfcourse.ValidationErrorType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Validation Error</em>' attribute list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.ValidationErrorType
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_ValidationError()
	 * @model
	 * @generated
	 */
	EList<ValidationErrorType> getValidationError();

	/**
	 * Returns the value of the '<em><b>Invalid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A GolfCourse is considered invalid if it has missing, incomplete or inconsistent information 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Invalid</em>' attribute.
	 * @see #setInvalid(boolean)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_Invalid()
	 * @model
	 * @generated
	 */
	boolean isInvalid();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isInvalid <em>Invalid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Invalid</em>' attribute.
	 * @see #isInvalid()
	 * @generated
	 */
	void setInvalid(boolean value);

	/**
	 * Returns the value of the '<em><b>Totally Invalid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * A GolfCourse is considered totallyInvalid if it is missing GPS info, or Scorecard info, or if the information on the Scorecards are not consistent with the number of holes
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Totally Invalid</em>' attribute.
	 * @see #setTotallyInvalid(boolean)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_TotallyInvalid()
	 * @model
	 * @generated
	 */
	boolean isTotallyInvalid();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isTotallyInvalid <em>Totally Invalid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Totally Invalid</em>' attribute.
	 * @see #isTotallyInvalid()
	 * @generated
	 */
	void setTotallyInvalid(boolean value);

	/**
	 * Returns the value of the '<em><b>Last Validation Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Last Validation Date</em>' attribute.
	 * @see #setLastValidationDate(Date)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_LastValidationDate()
	 * @model
	 * @generated
	 */
	Date getLastValidationDate();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#getLastValidationDate <em>Last Validation Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Last Validation Date</em>' attribute.
	 * @see #getLastValidationDate()
	 * @generated
	 */
	void setLastValidationDate(Date value);

	/**
	 * Returns the value of the '<em><b>Deleted</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Deleted</em>' attribute.
	 * @see #setDeleted(boolean)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_Deleted()
	 * @model
	 * @generated
	 */
	boolean isDeleted();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isDeleted <em>Deleted</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Deleted</em>' attribute.
	 * @see #isDeleted()
	 * @generated
	 */
	void setDeleted(boolean value);

	/**
	 * Returns the value of the '<em><b>Has Overlapping Holes</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This attribute is set to true when the course is marked as an 18 holes but is actually a 9 holes course, where holes 10-18 are the same as holes 1-9
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Has Overlapping Holes</em>' attribute.
	 * @see #setHasOverlappingHoles(boolean)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getGolfCourse_HasOverlappingHoles()
	 * @model
	 * @generated
	 */
	boolean isHasOverlappingHoles();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse#isHasOverlappingHoles <em>Has Overlapping Holes</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Has Overlapping Holes</em>' attribute.
	 * @see #isHasOverlappingHoles()
	 * @generated
	 */
	void setHasOverlappingHoles(boolean value);

} // GolfCourse
