/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Hole</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getHoleNumber <em>Hole Number</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getGreenCenter <em>Green Center</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getBunker <em>Bunker</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getCentralPath <em>Central Path</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getTeeboxCenter <em>Teebox Center</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getPerimeter <em>Perimeter</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getGreen <em>Green</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getFairway <em>Fairway</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getTeebox <em>Teebox</em>}</li>
 * </ul>
 *
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole()
 * @model
 * @generated
 */
@ProviderType
public interface Hole extends EObject {
	/**
	 * Returns the value of the '<em><b>Hole Number</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Hole Number</em>' attribute.
	 * @see #setHoleNumber(int)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_HoleNumber()
	 * @model
	 * @generated
	 */
	int getHoleNumber();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getHoleNumber <em>Hole Number</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Hole Number</em>' attribute.
	 * @see #getHoleNumber()
	 * @generated
	 */
	void setHoleNumber(int value);

	/**
	 * Returns the value of the '<em><b>Green Center</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Green Center</em>' containment reference.
	 * @see #setGreenCenter(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_GreenCenter()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getGreenCenter();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getGreenCenter <em>Green Center</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Green Center</em>' containment reference.
	 * @see #getGreenCenter()
	 * @generated
	 */
	void setGreenCenter(ShapeObject value);

	/**
	 * Returns the value of the '<em><b>Bunker</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Bunker</em>' containment reference.
	 * @see #setBunker(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_Bunker()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getBunker();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getBunker <em>Bunker</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Bunker</em>' containment reference.
	 * @see #getBunker()
	 * @generated
	 */
	void setBunker(ShapeObject value);

	/**
	 * Returns the value of the '<em><b>Central Path</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Central Path</em>' containment reference.
	 * @see #setCentralPath(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_CentralPath()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getCentralPath();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getCentralPath <em>Central Path</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Central Path</em>' containment reference.
	 * @see #getCentralPath()
	 * @generated
	 */
	void setCentralPath(ShapeObject value);

	/**
	 * Returns the value of the '<em><b>Teebox Center</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Teebox Center</em>' containment reference.
	 * @see #setTeeboxCenter(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_TeeboxCenter()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getTeeboxCenter();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getTeeboxCenter <em>Teebox Center</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Teebox Center</em>' containment reference.
	 * @see #getTeeboxCenter()
	 * @generated
	 */
	void setTeeboxCenter(ShapeObject value);

	/**
	 * Returns the value of the '<em><b>Perimeter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Perimeter</em>' containment reference.
	 * @see #setPerimeter(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_Perimeter()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getPerimeter();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getPerimeter <em>Perimeter</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Perimeter</em>' containment reference.
	 * @see #getPerimeter()
	 * @generated
	 */
	void setPerimeter(ShapeObject value);

	/**
	 * Returns the value of the '<em><b>Green</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Green</em>' containment reference.
	 * @see #setGreen(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_Green()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getGreen();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getGreen <em>Green</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Green</em>' containment reference.
	 * @see #getGreen()
	 * @generated
	 */
	void setGreen(ShapeObject value);

	/**
	 * Returns the value of the '<em><b>Fairway</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Fairway</em>' containment reference.
	 * @see #setFairway(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_Fairway()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getFairway();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getFairway <em>Fairway</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Fairway</em>' containment reference.
	 * @see #getFairway()
	 * @generated
	 */
	void setFairway(ShapeObject value);

	/**
	 * Returns the value of the '<em><b>Teebox</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Teebox</em>' containment reference.
	 * @see #setTeebox(ShapeObject)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getHole_Teebox()
	 * @model containment="true"
	 * @generated
	 */
	ShapeObject getTeebox();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole#getTeebox <em>Teebox</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Teebox</em>' containment reference.
	 * @see #getTeebox()
	 * @generated
	 */
	void setTeebox(ShapeObject value);

} // Hole
