/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Price Table</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekend9 <em>Weekend9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekend18 <em>Weekend18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekday9 <em>Weekday9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekday18 <em>Weekday18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getTwilight <em>Twilight</em>}</li>
 * </ul>
 *
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getPriceTable()
 * @model
 * @generated
 */
@ProviderType
public interface PriceTable extends EObject {
	/**
	 * Returns the value of the '<em><b>Weekend9</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Price for a weekend 9 hole round
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Weekend9</em>' attribute.
	 * @see #setWeekend9(double)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getPriceTable_Weekend9()
	 * @model
	 * @generated
	 */
	double getWeekend9();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekend9 <em>Weekend9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Weekend9</em>' attribute.
	 * @see #getWeekend9()
	 * @generated
	 */
	void setWeekend9(double value);

	/**
	 * Returns the value of the '<em><b>Weekend18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Price for a weekend 18  hole round
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Weekend18</em>' attribute.
	 * @see #setWeekend18(double)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getPriceTable_Weekend18()
	 * @model
	 * @generated
	 */
	double getWeekend18();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekend18 <em>Weekend18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Weekend18</em>' attribute.
	 * @see #getWeekend18()
	 * @generated
	 */
	void setWeekend18(double value);

	/**
	 * Returns the value of the '<em><b>Weekday9</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Price for a weekday 9 hole round
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Weekday9</em>' attribute.
	 * @see #setWeekday9(double)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getPriceTable_Weekday9()
	 * @model
	 * @generated
	 */
	double getWeekday9();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekday9 <em>Weekday9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Weekday9</em>' attribute.
	 * @see #getWeekday9()
	 * @generated
	 */
	void setWeekday9(double value);

	/**
	 * Returns the value of the '<em><b>Weekday18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Price for a weekday 18 hole round
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Weekday18</em>' attribute.
	 * @see #setWeekday18(double)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getPriceTable_Weekday18()
	 * @model
	 * @generated
	 */
	double getWeekday18();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getWeekday18 <em>Weekday18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Weekday18</em>' attribute.
	 * @see #getWeekday18()
	 * @generated
	 */
	void setWeekday18(double value);

	/**
	 * Returns the value of the '<em><b>Twilight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Price for a twilight round
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Twilight</em>' attribute.
	 * @see #setTwilight(double)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getPriceTable_Twilight()
	 * @model
	 * @generated
	 */
	double getTwilight();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable#getTwilight <em>Twilight</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Twilight</em>' attribute.
	 * @see #getTwilight()
	 * @generated
	 */
	void setTwilight(double value);

} // PriceTable
