/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Shape Wrapper</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.ShapeWrapper#getIgolfString <em>Igolf String</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.ShapeWrapper#getPoints <em>Points</em>}</li>
 * </ul>
 *
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getShapeWrapper()
 * @model
 * @generated
 */
@ProviderType
public interface ShapeWrapper extends EObject {
	/**
	 * Returns the value of the '<em><b>Igolf String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Igolf String</em>' attribute.
	 * @see #setIgolfString(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getShapeWrapper_IgolfString()
	 * @model
	 * @generated
	 */
	String getIgolfString();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.ShapeWrapper#getIgolfString <em>Igolf String</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Igolf String</em>' attribute.
	 * @see #getIgolfString()
	 * @generated
	 */
	void setIgolfString(String value);

	/**
	 * Returns the value of the '<em><b>Points</b></em>' containment reference list.
	 * The list contents are of type {@link com.playertour.backend.golfcourse.model.golfcourse.Location}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Points</em>' containment reference list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getShapeWrapper_Points()
	 * @model containment="true"
	 * @generated
	 */
	EList<Location> getPoints();

} // ShapeWrapper
