/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Tee</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getName <em>Name</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getColor <em>Color</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getColorValue <em>Color Value</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getGender <em>Gender</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getRating <em>Rating</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getSlope <em>Slope</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYdsTotal <em>Yds Total</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYds1to9 <em>Yds1to9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYds10to18 <em>Yds10to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYds1to18 <em>Yds1to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYdsHole <em>Yds Hole</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMetersTotal <em>Meters Total</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMeters1to9 <em>Meters1to9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMeters10to18 <em>Meters10to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMeters1to18 <em>Meters1to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMetersHole <em>Meters Hole</em>}</li>
 * </ul>
 *
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee()
 * @model
 * @generated
 */
@ProviderType
public interface Tee extends EObject {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Color</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Color</em>' attribute.
	 * @see #setColor(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Color()
	 * @model
	 * @generated
	 */
	String getColor();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getColor <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Color</em>' attribute.
	 * @see #getColor()
	 * @generated
	 */
	void setColor(String value);

	/**
	 * Returns the value of the '<em><b>Color Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Color Value</em>' attribute.
	 * @see #setColorValue(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_ColorValue()
	 * @model
	 * @generated
	 */
	String getColorValue();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getColorValue <em>Color Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Color Value</em>' attribute.
	 * @see #getColorValue()
	 * @generated
	 */
	void setColorValue(String value);

	/**
	 * Returns the value of the '<em><b>Gender</b></em>' attribute.
	 * The literals are from the enumeration {@link com.playertour.backend.golfcourse.model.golfcourse.GenderType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Gender</em>' attribute.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GenderType
	 * @see #setGender(GenderType)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Gender()
	 * @model
	 * @generated
	 */
	GenderType getGender();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getGender <em>Gender</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Gender</em>' attribute.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GenderType
	 * @see #getGender()
	 * @generated
	 */
	void setGender(GenderType value);

	/**
	 * Returns the value of the '<em><b>Rating</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Rating</em>' attribute.
	 * @see #setRating(double)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Rating()
	 * @model
	 * @generated
	 */
	double getRating();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getRating <em>Rating</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rating</em>' attribute.
	 * @see #getRating()
	 * @generated
	 */
	void setRating(double value);

	/**
	 * Returns the value of the '<em><b>Slope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Slope</em>' attribute.
	 * @see #setSlope(Integer)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Slope()
	 * @model
	 * @generated
	 */
	Integer getSlope();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getSlope <em>Slope</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Slope</em>' attribute.
	 * @see #getSlope()
	 * @generated
	 */
	void setSlope(Integer value);

	/**
	 * Returns the value of the '<em><b>Yds Total</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Yds Total</em>' attribute.
	 * @see #setYdsTotal(Integer)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_YdsTotal()
	 * @model
	 * @generated
	 */
	Integer getYdsTotal();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYdsTotal <em>Yds Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Yds Total</em>' attribute.
	 * @see #getYdsTotal()
	 * @generated
	 */
	void setYdsTotal(Integer value);

	/**
	 * Returns the value of the '<em><b>Yds1to9</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Yds1to9</em>' attribute.
	 * @see #setYds1to9(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Yds1to9()
	 * @model
	 * @generated
	 */
	String getYds1to9();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYds1to9 <em>Yds1to9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Yds1to9</em>' attribute.
	 * @see #getYds1to9()
	 * @generated
	 */
	void setYds1to9(String value);

	/**
	 * Returns the value of the '<em><b>Yds10to18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Yds10to18</em>' attribute.
	 * @see #setYds10to18(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Yds10to18()
	 * @model
	 * @generated
	 */
	String getYds10to18();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYds10to18 <em>Yds10to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Yds10to18</em>' attribute.
	 * @see #getYds10to18()
	 * @generated
	 */
	void setYds10to18(String value);

	/**
	 * Returns the value of the '<em><b>Yds1to18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Yds1to18</em>' attribute.
	 * @see #setYds1to18(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Yds1to18()
	 * @model
	 * @generated
	 */
	String getYds1to18();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getYds1to18 <em>Yds1to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Yds1to18</em>' attribute.
	 * @see #getYds1to18()
	 * @generated
	 */
	void setYds1to18(String value);

	/**
	 * Returns the value of the '<em><b>Yds Hole</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.Integer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Yds Hole</em>' attribute list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_YdsHole()
	 * @model unique="false"
	 * @generated
	 */
	EList<Integer> getYdsHole();

	/**
	 * Returns the value of the '<em><b>Meters Total</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Meters Total</em>' attribute.
	 * @see #setMetersTotal(Integer)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_MetersTotal()
	 * @model
	 * @generated
	 */
	Integer getMetersTotal();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMetersTotal <em>Meters Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Meters Total</em>' attribute.
	 * @see #getMetersTotal()
	 * @generated
	 */
	void setMetersTotal(Integer value);

	/**
	 * Returns the value of the '<em><b>Meters1to9</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Meters1to9</em>' attribute.
	 * @see #setMeters1to9(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Meters1to9()
	 * @model
	 * @generated
	 */
	String getMeters1to9();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMeters1to9 <em>Meters1to9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Meters1to9</em>' attribute.
	 * @see #getMeters1to9()
	 * @generated
	 */
	void setMeters1to9(String value);

	/**
	 * Returns the value of the '<em><b>Meters10to18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Meters10to18</em>' attribute.
	 * @see #setMeters10to18(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Meters10to18()
	 * @model
	 * @generated
	 */
	String getMeters10to18();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMeters10to18 <em>Meters10to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Meters10to18</em>' attribute.
	 * @see #getMeters10to18()
	 * @generated
	 */
	void setMeters10to18(String value);

	/**
	 * Returns the value of the '<em><b>Meters1to18</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Meters1to18</em>' attribute.
	 * @see #setMeters1to18(String)
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_Meters1to18()
	 * @model
	 * @generated
	 */
	String getMeters1to18();

	/**
	 * Sets the value of the '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee#getMeters1to18 <em>Meters1to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Meters1to18</em>' attribute.
	 * @see #getMeters1to18()
	 * @generated
	 */
	void setMeters1to18(String value);

	/**
	 * Returns the value of the '<em><b>Meters Hole</b></em>' attribute list.
	 * The list contents are of type {@link java.lang.Integer}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Meters Hole</em>' attribute list.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getTee_MetersHole()
	 * @model unique="false"
	 * @generated
	 */
	EList<Integer> getMetersHole();

} // Tee
