/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Validation Error Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#getValidationErrorType()
 * @model
 * @generated
 */
@ProviderType
public enum ValidationErrorType implements Enumerator {
	/**
	 * The '<em><b>MISSING GPS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MISSING_GPS_VALUE
	 * @generated
	 * @ordered
	 */
	MISSING_GPS(0, "MISSING_GPS", "MISSING_GPS"),

	/**
	 * The '<em><b>MISSING SCORECARD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MISSING_SCORECARD_VALUE
	 * @generated
	 * @ordered
	 */
	MISSING_SCORECARD(1, "MISSING_SCORECARD", "MISSING_SCORECARD"),

	/**
	 * The '<em><b>HOLE NUM NOT 9NOR 18</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HOLE_NUM_NOT_9NOR_18_VALUE
	 * @generated
	 * @ordered
	 */
	HOLE_NUM_NOT_9NOR_18(2, "HOLE_NUM_NOT_9NOR_18", "HOLE_NUM_NOT_9NOR_18"),

	/**
	 * The '<em><b>SCORECARD INCONSITENT PAR HOLE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If the number of non-zero parHole values in the Scorecard is inconsitent with the number of holes of the golf course.
	 * <!-- end-model-doc -->
	 * @see #SCORECARD_INCONSITENT_PAR_HOLE_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_INCONSITENT_PAR_HOLE(3, "SCORECARD_INCONSITENT_PAR_HOLE", "SCORECARD_INCONSITENT_PAR_HOLE"),

	/**
	 * The '<em><b>SCORECARD INCONSISTENT HCP HOLE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If the number of non-zero hcpHole values in the Scorecard is inconsitent with the number of holes of the golf course.
	 * <!-- end-model-doc -->
	 * @see #SCORECARD_INCONSISTENT_HCP_HOLE_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_INCONSISTENT_HCP_HOLE(4, "SCORECARD_INCONSISTENT_HCP_HOLE", "SCORECARD_INCONSISTENT_HCP_HOLE"),

	/**
	 * The '<em><b>SCORECARD PAR TOTAL ZERO</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_TOTAL_ZERO_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_PAR_TOTAL_ZERO(5, "SCORECARD_PAR_TOTAL_ZERO", "SCORECARD_PAR_TOTAL_ZERO"),

	/**
	 * The '<em><b>SCORECARD PAR TOTAL NULL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_TOTAL_NULL_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_PAR_TOTAL_NULL(6, "SCORECARD_PAR_TOTAL_NULL", "SCORECARD_PAR_TOTAL_NULL"),

	/**
	 * The '<em><b>SCORECARD PAR IN ZERO</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If parIn is set to zero even though the number of holes of the golf course is larger than 9.
	 * <!-- end-model-doc -->
	 * @see #SCORECARD_PAR_IN_ZERO_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_PAR_IN_ZERO(7, "SCORECARD_PAR_IN_ZERO", "SCORECARD_PAR_IN_ZERO"),

	/**
	 * The '<em><b>SCORECARD PAR IN NULL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_IN_NULL_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_PAR_IN_NULL(8, "SCORECARD_PAR_IN_NULL", "SCORECARD_PAR_IN_NULL"),

	/**
	 * The '<em><b>SCORECARD PAR OUT ZERO</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_OUT_ZERO_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_PAR_OUT_ZERO(9, "SCORECARD_PAR_OUT_ZERO", "SCORECARD_PAR_OUT_ZERO"),

	/**
	 * The '<em><b>SCORECARD PAR OUT NULL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_OUT_NULL_VALUE
	 * @generated
	 * @ordered
	 */
	SCORECARD_PAR_OUT_NULL(10, "SCORECARD_PAR_OUT_NULL", "SCORECARD_PAR_OUT_NULL"),

	/**
	 * The '<em><b>MISSING TEE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MISSING_TEE_VALUE
	 * @generated
	 * @ordered
	 */
	MISSING_TEE(11, "MISSING_TEE", "MISSING_TEE"),

	/**
	 * The '<em><b>TEE INCONSITENT YDS HOLE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If the number of non-zero ydsHole values in the Tee is inconsitent with the number of holes of the golf course.
	 * <!-- end-model-doc -->
	 * @see #TEE_INCONSITENT_YDS_HOLE_VALUE
	 * @generated
	 * @ordered
	 */
	TEE_INCONSITENT_YDS_HOLE(12, "TEE_INCONSITENT_YDS_HOLE", "TEE_INCONSITENT_YDS_HOLE");

	/**
	 * The '<em><b>MISSING GPS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MISSING_GPS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MISSING_GPS_VALUE = 0;

	/**
	 * The '<em><b>MISSING SCORECARD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MISSING_SCORECARD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MISSING_SCORECARD_VALUE = 1;

	/**
	 * The '<em><b>HOLE NUM NOT 9NOR 18</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HOLE_NUM_NOT_9NOR_18
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HOLE_NUM_NOT_9NOR_18_VALUE = 2;

	/**
	 * The '<em><b>SCORECARD INCONSITENT PAR HOLE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If the number of non-zero parHole values in the Scorecard is inconsitent with the number of holes of the golf course.
	 * <!-- end-model-doc -->
	 * @see #SCORECARD_INCONSITENT_PAR_HOLE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_INCONSITENT_PAR_HOLE_VALUE = 3;

	/**
	 * The '<em><b>SCORECARD INCONSISTENT HCP HOLE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If the number of non-zero hcpHole values in the Scorecard is inconsitent with the number of holes of the golf course.
	 * <!-- end-model-doc -->
	 * @see #SCORECARD_INCONSISTENT_HCP_HOLE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_INCONSISTENT_HCP_HOLE_VALUE = 4;

	/**
	 * The '<em><b>SCORECARD PAR TOTAL ZERO</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_TOTAL_ZERO
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_PAR_TOTAL_ZERO_VALUE = 5;

	/**
	 * The '<em><b>SCORECARD PAR TOTAL NULL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_TOTAL_NULL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_PAR_TOTAL_NULL_VALUE = 6;

	/**
	 * The '<em><b>SCORECARD PAR IN ZERO</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If parIn is set to zero even though the number of holes of the golf course is larger than 9.
	 * <!-- end-model-doc -->
	 * @see #SCORECARD_PAR_IN_ZERO
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_PAR_IN_ZERO_VALUE = 7;

	/**
	 * The '<em><b>SCORECARD PAR IN NULL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_IN_NULL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_PAR_IN_NULL_VALUE = 8;

	/**
	 * The '<em><b>SCORECARD PAR OUT ZERO</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_OUT_ZERO
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_PAR_OUT_ZERO_VALUE = 9;

	/**
	 * The '<em><b>SCORECARD PAR OUT NULL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCORECARD_PAR_OUT_NULL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCORECARD_PAR_OUT_NULL_VALUE = 10;

	/**
	 * The '<em><b>MISSING TEE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MISSING_TEE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MISSING_TEE_VALUE = 11;

	/**
	 * The '<em><b>TEE INCONSITENT YDS HOLE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * If the number of non-zero ydsHole values in the Tee is inconsitent with the number of holes of the golf course.
	 * <!-- end-model-doc -->
	 * @see #TEE_INCONSITENT_YDS_HOLE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TEE_INCONSITENT_YDS_HOLE_VALUE = 12;

	/**
	 * An array of all the '<em><b>Validation Error Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ValidationErrorType[] VALUES_ARRAY =
		new ValidationErrorType[] {
			MISSING_GPS,
			MISSING_SCORECARD,
			HOLE_NUM_NOT_9NOR_18,
			SCORECARD_INCONSITENT_PAR_HOLE,
			SCORECARD_INCONSISTENT_HCP_HOLE,
			SCORECARD_PAR_TOTAL_ZERO,
			SCORECARD_PAR_TOTAL_NULL,
			SCORECARD_PAR_IN_ZERO,
			SCORECARD_PAR_IN_NULL,
			SCORECARD_PAR_OUT_ZERO,
			SCORECARD_PAR_OUT_NULL,
			MISSING_TEE,
			TEE_INCONSITENT_YDS_HOLE,
		};

	/**
	 * A public read-only list of all the '<em><b>Validation Error Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ValidationErrorType> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Validation Error Type</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ValidationErrorType get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ValidationErrorType result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Validation Error Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ValidationErrorType getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ValidationErrorType result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Validation Error Type</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ValidationErrorType get(int value) {
		switch (value) {
			case MISSING_GPS_VALUE: return MISSING_GPS;
			case MISSING_SCORECARD_VALUE: return MISSING_SCORECARD;
			case HOLE_NUM_NOT_9NOR_18_VALUE: return HOLE_NUM_NOT_9NOR_18;
			case SCORECARD_INCONSITENT_PAR_HOLE_VALUE: return SCORECARD_INCONSITENT_PAR_HOLE;
			case SCORECARD_INCONSISTENT_HCP_HOLE_VALUE: return SCORECARD_INCONSISTENT_HCP_HOLE;
			case SCORECARD_PAR_TOTAL_ZERO_VALUE: return SCORECARD_PAR_TOTAL_ZERO;
			case SCORECARD_PAR_TOTAL_NULL_VALUE: return SCORECARD_PAR_TOTAL_NULL;
			case SCORECARD_PAR_IN_ZERO_VALUE: return SCORECARD_PAR_IN_ZERO;
			case SCORECARD_PAR_IN_NULL_VALUE: return SCORECARD_PAR_IN_NULL;
			case SCORECARD_PAR_OUT_ZERO_VALUE: return SCORECARD_PAR_OUT_ZERO;
			case SCORECARD_PAR_OUT_NULL_VALUE: return SCORECARD_PAR_OUT_NULL;
			case MISSING_TEE_VALUE: return MISSING_TEE;
			case TEE_INCONSITENT_YDS_HOLE_VALUE: return TEE_INCONSITENT_YDS_HOLE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ValidationErrorType(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ValidationErrorType
