/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.Address;
import com.playertour.backend.golfcourse.model.golfcourse.Contact;
import com.playertour.backend.golfcourse.model.golfcourse.CourseDetails;
import com.playertour.backend.golfcourse.model.golfcourse.DressCodeType;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourseType;
import com.playertour.backend.golfcourse.model.golfcourse.Location;
import com.playertour.backend.golfcourse.model.golfcourse.PriceTable;
import com.playertour.backend.golfcourse.model.golfcourse.WeekDay;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Course Details</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getCourseName <em>Course Name</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getHoleNum <em>Hole Num</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getCountryId <em>Country Id</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getStateId <em>State Id</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getAddress <em>Address</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getContact <em>Contact</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getType <em>Type</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#isSeasonal <em>Seasonal</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getDressCode <em>Dress Code</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getDayClosed <em>Day Closed</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getPricing <em>Pricing</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getLocation <em>Location</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getImageUrl <em>Image Url</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getCountryShortName <em>Country Short Name</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getCountryFullName <em>Country Full Name</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getStateShortName <em>State Short Name</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseDetailsImpl#getStateFullName <em>State Full Name</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CourseDetailsImpl extends MinimalEObjectImpl.Container implements CourseDetails {
	/**
	 * The default value of the '{@link #getCourseName() <em>Course Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseName()
	 * @generated
	 * @ordered
	 */
	protected static final String COURSE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCourseName() <em>Course Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseName()
	 * @generated
	 * @ordered
	 */
	protected String courseName = COURSE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getHoleNum() <em>Hole Num</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHoleNum()
	 * @generated
	 * @ordered
	 */
	protected static final int HOLE_NUM_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getHoleNum() <em>Hole Num</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHoleNum()
	 * @generated
	 * @ordered
	 */
	protected int holeNum = HOLE_NUM_EDEFAULT;

	/**
	 * The default value of the '{@link #getCountryId() <em>Country Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountryId()
	 * @generated
	 * @ordered
	 */
	protected static final String COUNTRY_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCountryId() <em>Country Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountryId()
	 * @generated
	 * @ordered
	 */
	protected String countryId = COUNTRY_ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getStateId() <em>State Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStateId()
	 * @generated
	 * @ordered
	 */
	protected static final String STATE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStateId() <em>State Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStateId()
	 * @generated
	 * @ordered
	 */
	protected String stateId = STATE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getAddress() <em>Address</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAddress()
	 * @generated
	 * @ordered
	 */
	protected Address address;

	/**
	 * The cached value of the '{@link #getContact() <em>Contact</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContact()
	 * @generated
	 * @ordered
	 */
	protected Contact contact;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final GolfCourseType TYPE_EDEFAULT = GolfCourseType.PUBLIC;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected GolfCourseType type = TYPE_EDEFAULT;

	/**
	 * The default value of the '{@link #isSeasonal() <em>Seasonal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSeasonal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean SEASONAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isSeasonal() <em>Seasonal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSeasonal()
	 * @generated
	 * @ordered
	 */
	protected boolean seasonal = SEASONAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getDressCode() <em>Dress Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDressCode()
	 * @generated
	 * @ordered
	 */
	protected static final DressCodeType DRESS_CODE_EDEFAULT = DressCodeType.NO_DENIM;

	/**
	 * The cached value of the '{@link #getDressCode() <em>Dress Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDressCode()
	 * @generated
	 * @ordered
	 */
	protected DressCodeType dressCode = DRESS_CODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getDayClosed() <em>Day Closed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDayClosed()
	 * @generated
	 * @ordered
	 */
	protected static final WeekDay DAY_CLOSED_EDEFAULT = WeekDay.SUN;

	/**
	 * The cached value of the '{@link #getDayClosed() <em>Day Closed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDayClosed()
	 * @generated
	 * @ordered
	 */
	protected WeekDay dayClosed = DAY_CLOSED_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPricing() <em>Pricing</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPricing()
	 * @generated
	 * @ordered
	 */
	protected PriceTable pricing;

	/**
	 * The cached value of the '{@link #getLocation() <em>Location</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocation()
	 * @generated
	 * @ordered
	 */
	protected Location location;

	/**
	 * The default value of the '{@link #getImageUrl() <em>Image Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImageUrl()
	 * @generated
	 * @ordered
	 */
	protected static final String IMAGE_URL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getImageUrl() <em>Image Url</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getImageUrl()
	 * @generated
	 * @ordered
	 */
	protected String imageUrl = IMAGE_URL_EDEFAULT;

	/**
	 * The default value of the '{@link #getCountryShortName() <em>Country Short Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountryShortName()
	 * @generated
	 * @ordered
	 */
	protected static final String COUNTRY_SHORT_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCountryShortName() <em>Country Short Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountryShortName()
	 * @generated
	 * @ordered
	 */
	protected String countryShortName = COUNTRY_SHORT_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getCountryFullName() <em>Country Full Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountryFullName()
	 * @generated
	 * @ordered
	 */
	protected static final String COUNTRY_FULL_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCountryFullName() <em>Country Full Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCountryFullName()
	 * @generated
	 * @ordered
	 */
	protected String countryFullName = COUNTRY_FULL_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStateShortName() <em>State Short Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStateShortName()
	 * @generated
	 * @ordered
	 */
	protected static final String STATE_SHORT_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStateShortName() <em>State Short Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStateShortName()
	 * @generated
	 * @ordered
	 */
	protected String stateShortName = STATE_SHORT_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getStateFullName() <em>State Full Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStateFullName()
	 * @generated
	 * @ordered
	 */
	protected static final String STATE_FULL_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getStateFullName() <em>State Full Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStateFullName()
	 * @generated
	 * @ordered
	 */
	protected String stateFullName = STATE_FULL_NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CourseDetailsImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.COURSE_DETAILS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCourseName() {
		return courseName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCourseName(String newCourseName) {
		String oldCourseName = courseName;
		courseName = newCourseName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__COURSE_NAME, oldCourseName, courseName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getHoleNum() {
		return holeNum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHoleNum(int newHoleNum) {
		int oldHoleNum = holeNum;
		holeNum = newHoleNum;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__HOLE_NUM, oldHoleNum, holeNum));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCountryId() {
		return countryId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCountryId(String newCountryId) {
		String oldCountryId = countryId;
		countryId = newCountryId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__COUNTRY_ID, oldCountryId, countryId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStateId() {
		return stateId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStateId(String newStateId) {
		String oldStateId = stateId;
		stateId = newStateId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__STATE_ID, oldStateId, stateId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Address getAddress() {
		return address;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetAddress(Address newAddress, NotificationChain msgs) {
		Address oldAddress = address;
		address = newAddress;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__ADDRESS, oldAddress, newAddress);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setAddress(Address newAddress) {
		if (newAddress != address) {
			NotificationChain msgs = null;
			if (address != null)
				msgs = ((InternalEObject)address).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__ADDRESS, null, msgs);
			if (newAddress != null)
				msgs = ((InternalEObject)newAddress).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__ADDRESS, null, msgs);
			msgs = basicSetAddress(newAddress, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__ADDRESS, newAddress, newAddress));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Contact getContact() {
		return contact;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetContact(Contact newContact, NotificationChain msgs) {
		Contact oldContact = contact;
		contact = newContact;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__CONTACT, oldContact, newContact);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setContact(Contact newContact) {
		if (newContact != contact) {
			NotificationChain msgs = null;
			if (contact != null)
				msgs = ((InternalEObject)contact).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__CONTACT, null, msgs);
			if (newContact != null)
				msgs = ((InternalEObject)newContact).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__CONTACT, null, msgs);
			msgs = basicSetContact(newContact, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__CONTACT, newContact, newContact));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GolfCourseType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setType(GolfCourseType newType) {
		GolfCourseType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isSeasonal() {
		return seasonal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSeasonal(boolean newSeasonal) {
		boolean oldSeasonal = seasonal;
		seasonal = newSeasonal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__SEASONAL, oldSeasonal, seasonal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public DressCodeType getDressCode() {
		return dressCode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDressCode(DressCodeType newDressCode) {
		DressCodeType oldDressCode = dressCode;
		dressCode = newDressCode == null ? DRESS_CODE_EDEFAULT : newDressCode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__DRESS_CODE, oldDressCode, dressCode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public WeekDay getDayClosed() {
		return dayClosed;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDayClosed(WeekDay newDayClosed) {
		WeekDay oldDayClosed = dayClosed;
		dayClosed = newDayClosed == null ? DAY_CLOSED_EDEFAULT : newDayClosed;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__DAY_CLOSED, oldDayClosed, dayClosed));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public PriceTable getPricing() {
		return pricing;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPricing(PriceTable newPricing, NotificationChain msgs) {
		PriceTable oldPricing = pricing;
		pricing = newPricing;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__PRICING, oldPricing, newPricing);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPricing(PriceTable newPricing) {
		if (newPricing != pricing) {
			NotificationChain msgs = null;
			if (pricing != null)
				msgs = ((InternalEObject)pricing).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__PRICING, null, msgs);
			if (newPricing != null)
				msgs = ((InternalEObject)newPricing).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__PRICING, null, msgs);
			msgs = basicSetPricing(newPricing, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__PRICING, newPricing, newPricing));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Location getLocation() {
		return location;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLocation(Location newLocation, NotificationChain msgs) {
		Location oldLocation = location;
		location = newLocation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__LOCATION, oldLocation, newLocation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLocation(Location newLocation) {
		if (newLocation != location) {
			NotificationChain msgs = null;
			if (location != null)
				msgs = ((InternalEObject)location).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__LOCATION, null, msgs);
			if (newLocation != null)
				msgs = ((InternalEObject)newLocation).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_DETAILS__LOCATION, null, msgs);
			msgs = basicSetLocation(newLocation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__LOCATION, newLocation, newLocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getImageUrl() {
		return imageUrl;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setImageUrl(String newImageUrl) {
		String oldImageUrl = imageUrl;
		imageUrl = newImageUrl;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__IMAGE_URL, oldImageUrl, imageUrl));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCountryShortName() {
		return countryShortName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCountryShortName(String newCountryShortName) {
		String oldCountryShortName = countryShortName;
		countryShortName = newCountryShortName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__COUNTRY_SHORT_NAME, oldCountryShortName, countryShortName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCountryFullName() {
		return countryFullName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCountryFullName(String newCountryFullName) {
		String oldCountryFullName = countryFullName;
		countryFullName = newCountryFullName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__COUNTRY_FULL_NAME, oldCountryFullName, countryFullName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStateShortName() {
		return stateShortName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStateShortName(String newStateShortName) {
		String oldStateShortName = stateShortName;
		stateShortName = newStateShortName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__STATE_SHORT_NAME, oldStateShortName, stateShortName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getStateFullName() {
		return stateFullName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setStateFullName(String newStateFullName) {
		String oldStateFullName = stateFullName;
		stateFullName = newStateFullName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_DETAILS__STATE_FULL_NAME, oldStateFullName, stateFullName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_DETAILS__ADDRESS:
				return basicSetAddress(null, msgs);
			case GolfCoursePackage.COURSE_DETAILS__CONTACT:
				return basicSetContact(null, msgs);
			case GolfCoursePackage.COURSE_DETAILS__PRICING:
				return basicSetPricing(null, msgs);
			case GolfCoursePackage.COURSE_DETAILS__LOCATION:
				return basicSetLocation(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_DETAILS__COURSE_NAME:
				return getCourseName();
			case GolfCoursePackage.COURSE_DETAILS__HOLE_NUM:
				return getHoleNum();
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_ID:
				return getCountryId();
			case GolfCoursePackage.COURSE_DETAILS__STATE_ID:
				return getStateId();
			case GolfCoursePackage.COURSE_DETAILS__ADDRESS:
				return getAddress();
			case GolfCoursePackage.COURSE_DETAILS__CONTACT:
				return getContact();
			case GolfCoursePackage.COURSE_DETAILS__TYPE:
				return getType();
			case GolfCoursePackage.COURSE_DETAILS__SEASONAL:
				return isSeasonal();
			case GolfCoursePackage.COURSE_DETAILS__DRESS_CODE:
				return getDressCode();
			case GolfCoursePackage.COURSE_DETAILS__DAY_CLOSED:
				return getDayClosed();
			case GolfCoursePackage.COURSE_DETAILS__PRICING:
				return getPricing();
			case GolfCoursePackage.COURSE_DETAILS__LOCATION:
				return getLocation();
			case GolfCoursePackage.COURSE_DETAILS__IMAGE_URL:
				return getImageUrl();
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_SHORT_NAME:
				return getCountryShortName();
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_FULL_NAME:
				return getCountryFullName();
			case GolfCoursePackage.COURSE_DETAILS__STATE_SHORT_NAME:
				return getStateShortName();
			case GolfCoursePackage.COURSE_DETAILS__STATE_FULL_NAME:
				return getStateFullName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_DETAILS__COURSE_NAME:
				setCourseName((String)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__HOLE_NUM:
				setHoleNum((Integer)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_ID:
				setCountryId((String)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__STATE_ID:
				setStateId((String)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__ADDRESS:
				setAddress((Address)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__CONTACT:
				setContact((Contact)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__TYPE:
				setType((GolfCourseType)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__SEASONAL:
				setSeasonal((Boolean)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__DRESS_CODE:
				setDressCode((DressCodeType)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__DAY_CLOSED:
				setDayClosed((WeekDay)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__PRICING:
				setPricing((PriceTable)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__LOCATION:
				setLocation((Location)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__IMAGE_URL:
				setImageUrl((String)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_SHORT_NAME:
				setCountryShortName((String)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_FULL_NAME:
				setCountryFullName((String)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__STATE_SHORT_NAME:
				setStateShortName((String)newValue);
				return;
			case GolfCoursePackage.COURSE_DETAILS__STATE_FULL_NAME:
				setStateFullName((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_DETAILS__COURSE_NAME:
				setCourseName(COURSE_NAME_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__HOLE_NUM:
				setHoleNum(HOLE_NUM_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_ID:
				setCountryId(COUNTRY_ID_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__STATE_ID:
				setStateId(STATE_ID_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__ADDRESS:
				setAddress((Address)null);
				return;
			case GolfCoursePackage.COURSE_DETAILS__CONTACT:
				setContact((Contact)null);
				return;
			case GolfCoursePackage.COURSE_DETAILS__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__SEASONAL:
				setSeasonal(SEASONAL_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__DRESS_CODE:
				setDressCode(DRESS_CODE_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__DAY_CLOSED:
				setDayClosed(DAY_CLOSED_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__PRICING:
				setPricing((PriceTable)null);
				return;
			case GolfCoursePackage.COURSE_DETAILS__LOCATION:
				setLocation((Location)null);
				return;
			case GolfCoursePackage.COURSE_DETAILS__IMAGE_URL:
				setImageUrl(IMAGE_URL_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_SHORT_NAME:
				setCountryShortName(COUNTRY_SHORT_NAME_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_FULL_NAME:
				setCountryFullName(COUNTRY_FULL_NAME_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__STATE_SHORT_NAME:
				setStateShortName(STATE_SHORT_NAME_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_DETAILS__STATE_FULL_NAME:
				setStateFullName(STATE_FULL_NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_DETAILS__COURSE_NAME:
				return COURSE_NAME_EDEFAULT == null ? courseName != null : !COURSE_NAME_EDEFAULT.equals(courseName);
			case GolfCoursePackage.COURSE_DETAILS__HOLE_NUM:
				return holeNum != HOLE_NUM_EDEFAULT;
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_ID:
				return COUNTRY_ID_EDEFAULT == null ? countryId != null : !COUNTRY_ID_EDEFAULT.equals(countryId);
			case GolfCoursePackage.COURSE_DETAILS__STATE_ID:
				return STATE_ID_EDEFAULT == null ? stateId != null : !STATE_ID_EDEFAULT.equals(stateId);
			case GolfCoursePackage.COURSE_DETAILS__ADDRESS:
				return address != null;
			case GolfCoursePackage.COURSE_DETAILS__CONTACT:
				return contact != null;
			case GolfCoursePackage.COURSE_DETAILS__TYPE:
				return type != TYPE_EDEFAULT;
			case GolfCoursePackage.COURSE_DETAILS__SEASONAL:
				return seasonal != SEASONAL_EDEFAULT;
			case GolfCoursePackage.COURSE_DETAILS__DRESS_CODE:
				return dressCode != DRESS_CODE_EDEFAULT;
			case GolfCoursePackage.COURSE_DETAILS__DAY_CLOSED:
				return dayClosed != DAY_CLOSED_EDEFAULT;
			case GolfCoursePackage.COURSE_DETAILS__PRICING:
				return pricing != null;
			case GolfCoursePackage.COURSE_DETAILS__LOCATION:
				return location != null;
			case GolfCoursePackage.COURSE_DETAILS__IMAGE_URL:
				return IMAGE_URL_EDEFAULT == null ? imageUrl != null : !IMAGE_URL_EDEFAULT.equals(imageUrl);
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_SHORT_NAME:
				return COUNTRY_SHORT_NAME_EDEFAULT == null ? countryShortName != null : !COUNTRY_SHORT_NAME_EDEFAULT.equals(countryShortName);
			case GolfCoursePackage.COURSE_DETAILS__COUNTRY_FULL_NAME:
				return COUNTRY_FULL_NAME_EDEFAULT == null ? countryFullName != null : !COUNTRY_FULL_NAME_EDEFAULT.equals(countryFullName);
			case GolfCoursePackage.COURSE_DETAILS__STATE_SHORT_NAME:
				return STATE_SHORT_NAME_EDEFAULT == null ? stateShortName != null : !STATE_SHORT_NAME_EDEFAULT.equals(stateShortName);
			case GolfCoursePackage.COURSE_DETAILS__STATE_FULL_NAME:
				return STATE_FULL_NAME_EDEFAULT == null ? stateFullName != null : !STATE_FULL_NAME_EDEFAULT.equals(stateFullName);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (courseName: ");
		result.append(courseName);
		result.append(", holeNum: ");
		result.append(holeNum);
		result.append(", countryId: ");
		result.append(countryId);
		result.append(", stateId: ");
		result.append(stateId);
		result.append(", type: ");
		result.append(type);
		result.append(", seasonal: ");
		result.append(seasonal);
		result.append(", dressCode: ");
		result.append(dressCode);
		result.append(", dayClosed: ");
		result.append(dayClosed);
		result.append(", imageUrl: ");
		result.append(imageUrl);
		result.append(", countryShortName: ");
		result.append(countryShortName);
		result.append(", countryFullName: ");
		result.append(countryFullName);
		result.append(", stateShortName: ");
		result.append(stateShortName);
		result.append(", stateFullName: ");
		result.append(stateFullName);
		result.append(')');
		return result.toString();
	}

} //CourseDetailsImpl
