/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.CourseGPSVector;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;
import com.playertour.backend.golfcourse.model.golfcourse.Hole;
import com.playertour.backend.golfcourse.model.golfcourse.ShapeObject;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Course GPS Vector</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getHoleCount <em>Hole Count</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getOcean <em>Ocean</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getBackgrund <em>Backgrund</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getBridge <em>Bridge</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getVegetation <em>Vegetation</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getCreek <em>Creek</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getPond <em>Pond</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getSand <em>Sand</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getRock <em>Rock</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getLake <em>Lake</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getWater <em>Water</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getTree <em>Tree</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getClubhouse <em>Clubhouse</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getLava <em>Lava</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getPath <em>Path</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseGPSVectorImpl#getHoles <em>Holes</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CourseGPSVectorImpl extends MinimalEObjectImpl.Container implements CourseGPSVector {
	/**
	 * The default value of the '{@link #getHoleCount() <em>Hole Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHoleCount()
	 * @generated
	 * @ordered
	 */
	protected static final int HOLE_COUNT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getHoleCount() <em>Hole Count</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHoleCount()
	 * @generated
	 * @ordered
	 */
	protected int holeCount = HOLE_COUNT_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOcean() <em>Ocean</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOcean()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject ocean;

	/**
	 * The cached value of the '{@link #getBackgrund() <em>Backgrund</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBackgrund()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject backgrund;

	/**
	 * The cached value of the '{@link #getBridge() <em>Bridge</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBridge()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject bridge;

	/**
	 * The cached value of the '{@link #getVegetation() <em>Vegetation</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVegetation()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject vegetation;

	/**
	 * The cached value of the '{@link #getCreek() <em>Creek</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCreek()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject creek;

	/**
	 * The cached value of the '{@link #getPond() <em>Pond</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPond()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject pond;

	/**
	 * The cached value of the '{@link #getSand() <em>Sand</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSand()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject sand;

	/**
	 * The cached value of the '{@link #getRock() <em>Rock</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRock()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject rock;

	/**
	 * The cached value of the '{@link #getLake() <em>Lake</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLake()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject lake;

	/**
	 * The cached value of the '{@link #getWater() <em>Water</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWater()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject water;

	/**
	 * The cached value of the '{@link #getTree() <em>Tree</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTree()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject tree;

	/**
	 * The cached value of the '{@link #getClubhouse() <em>Clubhouse</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClubhouse()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject clubhouse;

	/**
	 * The cached value of the '{@link #getLava() <em>Lava</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLava()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject lava;

	/**
	 * The cached value of the '{@link #getPath() <em>Path</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPath()
	 * @generated
	 * @ordered
	 */
	protected ShapeObject path;

	/**
	 * The cached value of the '{@link #getHoles() <em>Holes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHoles()
	 * @generated
	 * @ordered
	 */
	protected EList<Hole> holes;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CourseGPSVectorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.COURSE_GPS_VECTOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getHoleCount() {
		return holeCount;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHoleCount(int newHoleCount) {
		int oldHoleCount = holeCount;
		holeCount = newHoleCount;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__HOLE_COUNT, oldHoleCount, holeCount));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getOcean() {
		return ocean;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOcean(ShapeObject newOcean, NotificationChain msgs) {
		ShapeObject oldOcean = ocean;
		ocean = newOcean;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN, oldOcean, newOcean);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setOcean(ShapeObject newOcean) {
		if (newOcean != ocean) {
			NotificationChain msgs = null;
			if (ocean != null)
				msgs = ((InternalEObject)ocean).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN, null, msgs);
			if (newOcean != null)
				msgs = ((InternalEObject)newOcean).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN, null, msgs);
			msgs = basicSetOcean(newOcean, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN, newOcean, newOcean));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getBackgrund() {
		return backgrund;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBackgrund(ShapeObject newBackgrund, NotificationChain msgs) {
		ShapeObject oldBackgrund = backgrund;
		backgrund = newBackgrund;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND, oldBackgrund, newBackgrund);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBackgrund(ShapeObject newBackgrund) {
		if (newBackgrund != backgrund) {
			NotificationChain msgs = null;
			if (backgrund != null)
				msgs = ((InternalEObject)backgrund).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND, null, msgs);
			if (newBackgrund != null)
				msgs = ((InternalEObject)newBackgrund).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND, null, msgs);
			msgs = basicSetBackgrund(newBackgrund, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND, newBackgrund, newBackgrund));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getBridge() {
		return bridge;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBridge(ShapeObject newBridge, NotificationChain msgs) {
		ShapeObject oldBridge = bridge;
		bridge = newBridge;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE, oldBridge, newBridge);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setBridge(ShapeObject newBridge) {
		if (newBridge != bridge) {
			NotificationChain msgs = null;
			if (bridge != null)
				msgs = ((InternalEObject)bridge).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE, null, msgs);
			if (newBridge != null)
				msgs = ((InternalEObject)newBridge).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE, null, msgs);
			msgs = basicSetBridge(newBridge, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE, newBridge, newBridge));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getVegetation() {
		return vegetation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetVegetation(ShapeObject newVegetation, NotificationChain msgs) {
		ShapeObject oldVegetation = vegetation;
		vegetation = newVegetation;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION, oldVegetation, newVegetation);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setVegetation(ShapeObject newVegetation) {
		if (newVegetation != vegetation) {
			NotificationChain msgs = null;
			if (vegetation != null)
				msgs = ((InternalEObject)vegetation).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION, null, msgs);
			if (newVegetation != null)
				msgs = ((InternalEObject)newVegetation).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION, null, msgs);
			msgs = basicSetVegetation(newVegetation, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION, newVegetation, newVegetation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getCreek() {
		return creek;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCreek(ShapeObject newCreek, NotificationChain msgs) {
		ShapeObject oldCreek = creek;
		creek = newCreek;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__CREEK, oldCreek, newCreek);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCreek(ShapeObject newCreek) {
		if (newCreek != creek) {
			NotificationChain msgs = null;
			if (creek != null)
				msgs = ((InternalEObject)creek).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__CREEK, null, msgs);
			if (newCreek != null)
				msgs = ((InternalEObject)newCreek).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__CREEK, null, msgs);
			msgs = basicSetCreek(newCreek, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__CREEK, newCreek, newCreek));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getPond() {
		return pond;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPond(ShapeObject newPond, NotificationChain msgs) {
		ShapeObject oldPond = pond;
		pond = newPond;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__POND, oldPond, newPond);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPond(ShapeObject newPond) {
		if (newPond != pond) {
			NotificationChain msgs = null;
			if (pond != null)
				msgs = ((InternalEObject)pond).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__POND, null, msgs);
			if (newPond != null)
				msgs = ((InternalEObject)newPond).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__POND, null, msgs);
			msgs = basicSetPond(newPond, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__POND, newPond, newPond));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getSand() {
		return sand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSand(ShapeObject newSand, NotificationChain msgs) {
		ShapeObject oldSand = sand;
		sand = newSand;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__SAND, oldSand, newSand);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSand(ShapeObject newSand) {
		if (newSand != sand) {
			NotificationChain msgs = null;
			if (sand != null)
				msgs = ((InternalEObject)sand).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__SAND, null, msgs);
			if (newSand != null)
				msgs = ((InternalEObject)newSand).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__SAND, null, msgs);
			msgs = basicSetSand(newSand, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__SAND, newSand, newSand));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getRock() {
		return rock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRock(ShapeObject newRock, NotificationChain msgs) {
		ShapeObject oldRock = rock;
		rock = newRock;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__ROCK, oldRock, newRock);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRock(ShapeObject newRock) {
		if (newRock != rock) {
			NotificationChain msgs = null;
			if (rock != null)
				msgs = ((InternalEObject)rock).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__ROCK, null, msgs);
			if (newRock != null)
				msgs = ((InternalEObject)newRock).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__ROCK, null, msgs);
			msgs = basicSetRock(newRock, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__ROCK, newRock, newRock));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getLake() {
		return lake;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLake(ShapeObject newLake, NotificationChain msgs) {
		ShapeObject oldLake = lake;
		lake = newLake;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__LAKE, oldLake, newLake);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLake(ShapeObject newLake) {
		if (newLake != lake) {
			NotificationChain msgs = null;
			if (lake != null)
				msgs = ((InternalEObject)lake).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__LAKE, null, msgs);
			if (newLake != null)
				msgs = ((InternalEObject)newLake).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__LAKE, null, msgs);
			msgs = basicSetLake(newLake, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__LAKE, newLake, newLake));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getWater() {
		return water;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetWater(ShapeObject newWater, NotificationChain msgs) {
		ShapeObject oldWater = water;
		water = newWater;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__WATER, oldWater, newWater);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWater(ShapeObject newWater) {
		if (newWater != water) {
			NotificationChain msgs = null;
			if (water != null)
				msgs = ((InternalEObject)water).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__WATER, null, msgs);
			if (newWater != null)
				msgs = ((InternalEObject)newWater).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__WATER, null, msgs);
			msgs = basicSetWater(newWater, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__WATER, newWater, newWater));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getTree() {
		return tree;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTree(ShapeObject newTree, NotificationChain msgs) {
		ShapeObject oldTree = tree;
		tree = newTree;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__TREE, oldTree, newTree);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTree(ShapeObject newTree) {
		if (newTree != tree) {
			NotificationChain msgs = null;
			if (tree != null)
				msgs = ((InternalEObject)tree).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__TREE, null, msgs);
			if (newTree != null)
				msgs = ((InternalEObject)newTree).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__TREE, null, msgs);
			msgs = basicSetTree(newTree, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__TREE, newTree, newTree));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getClubhouse() {
		return clubhouse;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetClubhouse(ShapeObject newClubhouse, NotificationChain msgs) {
		ShapeObject oldClubhouse = clubhouse;
		clubhouse = newClubhouse;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE, oldClubhouse, newClubhouse);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setClubhouse(ShapeObject newClubhouse) {
		if (newClubhouse != clubhouse) {
			NotificationChain msgs = null;
			if (clubhouse != null)
				msgs = ((InternalEObject)clubhouse).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE, null, msgs);
			if (newClubhouse != null)
				msgs = ((InternalEObject)newClubhouse).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE, null, msgs);
			msgs = basicSetClubhouse(newClubhouse, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE, newClubhouse, newClubhouse));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getLava() {
		return lava;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLava(ShapeObject newLava, NotificationChain msgs) {
		ShapeObject oldLava = lava;
		lava = newLava;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__LAVA, oldLava, newLava);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLava(ShapeObject newLava) {
		if (newLava != lava) {
			NotificationChain msgs = null;
			if (lava != null)
				msgs = ((InternalEObject)lava).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__LAVA, null, msgs);
			if (newLava != null)
				msgs = ((InternalEObject)newLava).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__LAVA, null, msgs);
			msgs = basicSetLava(newLava, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__LAVA, newLava, newLava));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ShapeObject getPath() {
		return path;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetPath(ShapeObject newPath, NotificationChain msgs) {
		ShapeObject oldPath = path;
		path = newPath;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__PATH, oldPath, newPath);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setPath(ShapeObject newPath) {
		if (newPath != path) {
			NotificationChain msgs = null;
			if (path != null)
				msgs = ((InternalEObject)path).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__PATH, null, msgs);
			if (newPath != null)
				msgs = ((InternalEObject)newPath).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.COURSE_GPS_VECTOR__PATH, null, msgs);
			msgs = basicSetPath(newPath, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_GPS_VECTOR__PATH, newPath, newPath));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Hole> getHoles() {
		if (holes == null) {
			holes = new EObjectContainmentEList<Hole>(Hole.class, this, GolfCoursePackage.COURSE_GPS_VECTOR__HOLES);
		}
		return holes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN:
				return basicSetOcean(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND:
				return basicSetBackgrund(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE:
				return basicSetBridge(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION:
				return basicSetVegetation(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__CREEK:
				return basicSetCreek(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__POND:
				return basicSetPond(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__SAND:
				return basicSetSand(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__ROCK:
				return basicSetRock(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAKE:
				return basicSetLake(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__WATER:
				return basicSetWater(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__TREE:
				return basicSetTree(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE:
				return basicSetClubhouse(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAVA:
				return basicSetLava(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__PATH:
				return basicSetPath(null, msgs);
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLES:
				return ((InternalEList<?>)getHoles()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLE_COUNT:
				return getHoleCount();
			case GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN:
				return getOcean();
			case GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND:
				return getBackgrund();
			case GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE:
				return getBridge();
			case GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION:
				return getVegetation();
			case GolfCoursePackage.COURSE_GPS_VECTOR__CREEK:
				return getCreek();
			case GolfCoursePackage.COURSE_GPS_VECTOR__POND:
				return getPond();
			case GolfCoursePackage.COURSE_GPS_VECTOR__SAND:
				return getSand();
			case GolfCoursePackage.COURSE_GPS_VECTOR__ROCK:
				return getRock();
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAKE:
				return getLake();
			case GolfCoursePackage.COURSE_GPS_VECTOR__WATER:
				return getWater();
			case GolfCoursePackage.COURSE_GPS_VECTOR__TREE:
				return getTree();
			case GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE:
				return getClubhouse();
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAVA:
				return getLava();
			case GolfCoursePackage.COURSE_GPS_VECTOR__PATH:
				return getPath();
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLES:
				return getHoles();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLE_COUNT:
				setHoleCount((Integer)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN:
				setOcean((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND:
				setBackgrund((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE:
				setBridge((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION:
				setVegetation((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__CREEK:
				setCreek((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__POND:
				setPond((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__SAND:
				setSand((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__ROCK:
				setRock((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAKE:
				setLake((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__WATER:
				setWater((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__TREE:
				setTree((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE:
				setClubhouse((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAVA:
				setLava((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__PATH:
				setPath((ShapeObject)newValue);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLES:
				getHoles().clear();
				getHoles().addAll((Collection<? extends Hole>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLE_COUNT:
				setHoleCount(HOLE_COUNT_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN:
				setOcean((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND:
				setBackgrund((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE:
				setBridge((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION:
				setVegetation((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__CREEK:
				setCreek((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__POND:
				setPond((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__SAND:
				setSand((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__ROCK:
				setRock((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAKE:
				setLake((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__WATER:
				setWater((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__TREE:
				setTree((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE:
				setClubhouse((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAVA:
				setLava((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__PATH:
				setPath((ShapeObject)null);
				return;
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLES:
				getHoles().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLE_COUNT:
				return holeCount != HOLE_COUNT_EDEFAULT;
			case GolfCoursePackage.COURSE_GPS_VECTOR__OCEAN:
				return ocean != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__BACKGRUND:
				return backgrund != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__BRIDGE:
				return bridge != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__VEGETATION:
				return vegetation != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__CREEK:
				return creek != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__POND:
				return pond != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__SAND:
				return sand != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__ROCK:
				return rock != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAKE:
				return lake != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__WATER:
				return water != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__TREE:
				return tree != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__CLUBHOUSE:
				return clubhouse != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__LAVA:
				return lava != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__PATH:
				return path != null;
			case GolfCoursePackage.COURSE_GPS_VECTOR__HOLES:
				return holes != null && !holes.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (holeCount: ");
		result.append(holeCount);
		result.append(')');
		return result.toString();
	}

} //CourseGPSVectorImpl
