/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Course Scorecard Info</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getHcpHole <em>Hcp Hole</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getParHole <em>Par Hole</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getParIn <em>Par In</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getManualParIn <em>Manual Par In</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getParOut <em>Par Out</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getManualParOut <em>Manual Par Out</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getParTotal <em>Par Total</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardInfoImpl#getManualParTotal <em>Manual Par Total</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CourseScorecardInfoImpl extends MinimalEObjectImpl.Container implements CourseScorecardInfo {
	/**
	 * The cached value of the '{@link #getHcpHole() <em>Hcp Hole</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getHcpHole()
	 * @generated
	 * @ordered
	 */
	protected EList<Integer> hcpHole;

	/**
	 * The cached value of the '{@link #getParHole() <em>Par Hole</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParHole()
	 * @generated
	 * @ordered
	 */
	protected EList<Integer> parHole;

	/**
	 * The default value of the '{@link #getParIn() <em>Par In</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParIn()
	 * @generated
	 * @ordered
	 */
	protected static final Integer PAR_IN_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParIn() <em>Par In</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParIn()
	 * @generated
	 * @ordered
	 */
	protected Integer parIn = PAR_IN_EDEFAULT;

	/**
	 * The default value of the '{@link #getManualParIn() <em>Manual Par In</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManualParIn()
	 * @generated
	 * @ordered
	 */
	protected static final int MANUAL_PAR_IN_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getManualParIn() <em>Manual Par In</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManualParIn()
	 * @generated
	 * @ordered
	 */
	protected int manualParIn = MANUAL_PAR_IN_EDEFAULT;

	/**
	 * The default value of the '{@link #getParOut() <em>Par Out</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParOut()
	 * @generated
	 * @ordered
	 */
	protected static final Integer PAR_OUT_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParOut() <em>Par Out</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParOut()
	 * @generated
	 * @ordered
	 */
	protected Integer parOut = PAR_OUT_EDEFAULT;

	/**
	 * The default value of the '{@link #getManualParOut() <em>Manual Par Out</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManualParOut()
	 * @generated
	 * @ordered
	 */
	protected static final int MANUAL_PAR_OUT_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getManualParOut() <em>Manual Par Out</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManualParOut()
	 * @generated
	 * @ordered
	 */
	protected int manualParOut = MANUAL_PAR_OUT_EDEFAULT;

	/**
	 * The default value of the '{@link #getParTotal() <em>Par Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParTotal()
	 * @generated
	 * @ordered
	 */
	protected static final Integer PAR_TOTAL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getParTotal() <em>Par Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getParTotal()
	 * @generated
	 * @ordered
	 */
	protected Integer parTotal = PAR_TOTAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getManualParTotal() <em>Manual Par Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManualParTotal()
	 * @generated
	 * @ordered
	 */
	protected static final int MANUAL_PAR_TOTAL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getManualParTotal() <em>Manual Par Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getManualParTotal()
	 * @generated
	 * @ordered
	 */
	protected int manualParTotal = MANUAL_PAR_TOTAL_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CourseScorecardInfoImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.COURSE_SCORECARD_INFO;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Integer> getHcpHole() {
		if (hcpHole == null) {
			hcpHole = new EDataTypeEList<Integer>(Integer.class, this, GolfCoursePackage.COURSE_SCORECARD_INFO__HCP_HOLE);
		}
		return hcpHole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Integer> getParHole() {
		if (parHole == null) {
			parHole = new EDataTypeEList<Integer>(Integer.class, this, GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_HOLE);
		}
		return parHole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Integer getParIn() {
		return parIn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParIn(Integer newParIn) {
		Integer oldParIn = parIn;
		parIn = newParIn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_IN, oldParIn, parIn));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getManualParIn() {
		return manualParIn;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setManualParIn(int newManualParIn) {
		int oldManualParIn = manualParIn;
		manualParIn = newManualParIn;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_IN, oldManualParIn, manualParIn));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Integer getParOut() {
		return parOut;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParOut(Integer newParOut) {
		Integer oldParOut = parOut;
		parOut = newParOut;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_OUT, oldParOut, parOut));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getManualParOut() {
		return manualParOut;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setManualParOut(int newManualParOut) {
		int oldManualParOut = manualParOut;
		manualParOut = newManualParOut;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_OUT, oldManualParOut, manualParOut));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Integer getParTotal() {
		return parTotal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParTotal(Integer newParTotal) {
		Integer oldParTotal = parTotal;
		parTotal = newParTotal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_TOTAL, oldParTotal, parTotal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getManualParTotal() {
		return manualParTotal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setManualParTotal(int newManualParTotal) {
		int oldManualParTotal = manualParTotal;
		manualParTotal = newManualParTotal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_TOTAL, oldManualParTotal, manualParTotal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARD_INFO__HCP_HOLE:
				return getHcpHole();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_HOLE:
				return getParHole();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_IN:
				return getParIn();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_IN:
				return getManualParIn();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_OUT:
				return getParOut();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_OUT:
				return getManualParOut();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_TOTAL:
				return getParTotal();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_TOTAL:
				return getManualParTotal();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARD_INFO__HCP_HOLE:
				getHcpHole().clear();
				getHcpHole().addAll((Collection<? extends Integer>)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_HOLE:
				getParHole().clear();
				getParHole().addAll((Collection<? extends Integer>)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_IN:
				setParIn((Integer)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_IN:
				setManualParIn((Integer)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_OUT:
				setParOut((Integer)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_OUT:
				setManualParOut((Integer)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_TOTAL:
				setParTotal((Integer)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_TOTAL:
				setManualParTotal((Integer)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARD_INFO__HCP_HOLE:
				getHcpHole().clear();
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_HOLE:
				getParHole().clear();
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_IN:
				setParIn(PAR_IN_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_IN:
				setManualParIn(MANUAL_PAR_IN_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_OUT:
				setParOut(PAR_OUT_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_OUT:
				setManualParOut(MANUAL_PAR_OUT_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_TOTAL:
				setParTotal(PAR_TOTAL_EDEFAULT);
				return;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_TOTAL:
				setManualParTotal(MANUAL_PAR_TOTAL_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARD_INFO__HCP_HOLE:
				return hcpHole != null && !hcpHole.isEmpty();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_HOLE:
				return parHole != null && !parHole.isEmpty();
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_IN:
				return PAR_IN_EDEFAULT == null ? parIn != null : !PAR_IN_EDEFAULT.equals(parIn);
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_IN:
				return manualParIn != MANUAL_PAR_IN_EDEFAULT;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_OUT:
				return PAR_OUT_EDEFAULT == null ? parOut != null : !PAR_OUT_EDEFAULT.equals(parOut);
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_OUT:
				return manualParOut != MANUAL_PAR_OUT_EDEFAULT;
			case GolfCoursePackage.COURSE_SCORECARD_INFO__PAR_TOTAL:
				return PAR_TOTAL_EDEFAULT == null ? parTotal != null : !PAR_TOTAL_EDEFAULT.equals(parTotal);
			case GolfCoursePackage.COURSE_SCORECARD_INFO__MANUAL_PAR_TOTAL:
				return manualParTotal != MANUAL_PAR_TOTAL_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (hcpHole: ");
		result.append(hcpHole);
		result.append(", parHole: ");
		result.append(parHole);
		result.append(", parIn: ");
		result.append(parIn);
		result.append(", manualParIn: ");
		result.append(manualParIn);
		result.append(", parOut: ");
		result.append(parOut);
		result.append(", manualParOut: ");
		result.append(manualParOut);
		result.append(", parTotal: ");
		result.append(parTotal);
		result.append(", manualParTotal: ");
		result.append(manualParTotal);
		result.append(')');
		return result.toString();
	}

} //CourseScorecardInfoImpl
