/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo;
import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Course Scorecards</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardsImpl#getMenScorecard <em>Men Scorecard</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardsImpl#getWmnScorecard <em>Wmn Scorecard</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.CourseScorecardsImpl#getCourseId <em>Course Id</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CourseScorecardsImpl extends MinimalEObjectImpl.Container implements CourseScorecards {
	/**
	 * The cached value of the '{@link #getMenScorecard() <em>Men Scorecard</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMenScorecard()
	 * @generated
	 * @ordered
	 */
	protected EList<CourseScorecardInfo> menScorecard;

	/**
	 * The cached value of the '{@link #getWmnScorecard() <em>Wmn Scorecard</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWmnScorecard()
	 * @generated
	 * @ordered
	 */
	protected EList<CourseScorecardInfo> wmnScorecard;

	/**
	 * The default value of the '{@link #getCourseId() <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseId()
	 * @generated
	 * @ordered
	 */
	protected static final String COURSE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCourseId() <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseId()
	 * @generated
	 * @ordered
	 */
	protected String courseId = COURSE_ID_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CourseScorecardsImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.COURSE_SCORECARDS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<CourseScorecardInfo> getMenScorecard() {
		if (menScorecard == null) {
			menScorecard = new EObjectContainmentEList<CourseScorecardInfo>(CourseScorecardInfo.class, this, GolfCoursePackage.COURSE_SCORECARDS__MEN_SCORECARD);
		}
		return menScorecard;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<CourseScorecardInfo> getWmnScorecard() {
		if (wmnScorecard == null) {
			wmnScorecard = new EObjectContainmentEList<CourseScorecardInfo>(CourseScorecardInfo.class, this, GolfCoursePackage.COURSE_SCORECARDS__WMN_SCORECARD);
		}
		return wmnScorecard;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCourseId() {
		return courseId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCourseId(String newCourseId) {
		String oldCourseId = courseId;
		courseId = newCourseId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.COURSE_SCORECARDS__COURSE_ID, oldCourseId, courseId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARDS__MEN_SCORECARD:
				return ((InternalEList<?>)getMenScorecard()).basicRemove(otherEnd, msgs);
			case GolfCoursePackage.COURSE_SCORECARDS__WMN_SCORECARD:
				return ((InternalEList<?>)getWmnScorecard()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARDS__MEN_SCORECARD:
				return getMenScorecard();
			case GolfCoursePackage.COURSE_SCORECARDS__WMN_SCORECARD:
				return getWmnScorecard();
			case GolfCoursePackage.COURSE_SCORECARDS__COURSE_ID:
				return getCourseId();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARDS__MEN_SCORECARD:
				getMenScorecard().clear();
				getMenScorecard().addAll((Collection<? extends CourseScorecardInfo>)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARDS__WMN_SCORECARD:
				getWmnScorecard().clear();
				getWmnScorecard().addAll((Collection<? extends CourseScorecardInfo>)newValue);
				return;
			case GolfCoursePackage.COURSE_SCORECARDS__COURSE_ID:
				setCourseId((String)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARDS__MEN_SCORECARD:
				getMenScorecard().clear();
				return;
			case GolfCoursePackage.COURSE_SCORECARDS__WMN_SCORECARD:
				getWmnScorecard().clear();
				return;
			case GolfCoursePackage.COURSE_SCORECARDS__COURSE_ID:
				setCourseId(COURSE_ID_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.COURSE_SCORECARDS__MEN_SCORECARD:
				return menScorecard != null && !menScorecard.isEmpty();
			case GolfCoursePackage.COURSE_SCORECARDS__WMN_SCORECARD:
				return wmnScorecard != null && !wmnScorecard.isEmpty();
			case GolfCoursePackage.COURSE_SCORECARDS__COURSE_ID:
				return COURSE_ID_EDEFAULT == null ? courseId != null : !COURSE_ID_EDEFAULT.equals(courseId);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (courseId: ");
		result.append(courseId);
		result.append(')');
		return result.toString();
	}

} //CourseScorecardsImpl
