/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.CourseDetails;
import com.playertour.backend.golfcourse.model.golfcourse.CourseGPSVector;
import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourse;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;
import com.playertour.backend.golfcourse.model.golfcourse.Tee;
import com.playertour.backend.golfcourse.model.golfcourse.ValidationErrorType;

import java.util.Collection;
import java.util.Date;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Golf Course</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getId <em>Id</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getCourseId <em>Course Id</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getCourseDetails <em>Course Details</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getCourseGPSVector <em>Course GPS Vector</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getScorecards <em>Scorecards</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getTee <em>Tee</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getValidationError <em>Validation Error</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#isInvalid <em>Invalid</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#isTotallyInvalid <em>Totally Invalid</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#getLastValidationDate <em>Last Validation Date</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#isDeleted <em>Deleted</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.GolfCourseImpl#isHasOverlappingHoles <em>Has Overlapping Holes</em>}</li>
 * </ul>
 *
 * @generated
 */
public class GolfCourseImpl extends MinimalEObjectImpl.Container implements GolfCourse {
	/**
	 * The default value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected static final String ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getId() <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getId()
	 * @generated
	 * @ordered
	 */
	protected String id = ID_EDEFAULT;

	/**
	 * The default value of the '{@link #getCourseId() <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseId()
	 * @generated
	 * @ordered
	 */
	protected static final String COURSE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getCourseId() <em>Course Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseId()
	 * @generated
	 * @ordered
	 */
	protected String courseId = COURSE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getCourseDetails() <em>Course Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseDetails()
	 * @generated
	 * @ordered
	 */
	protected CourseDetails courseDetails;

	/**
	 * The cached value of the '{@link #getCourseGPSVector() <em>Course GPS Vector</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCourseGPSVector()
	 * @generated
	 * @ordered
	 */
	protected CourseGPSVector courseGPSVector;

	/**
	 * The cached value of the '{@link #getScorecards() <em>Scorecards</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getScorecards()
	 * @generated
	 * @ordered
	 */
	protected CourseScorecards scorecards;

	/**
	 * The cached value of the '{@link #getTee() <em>Tee</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTee()
	 * @generated
	 * @ordered
	 */
	protected EList<Tee> tee;

	/**
	 * The cached value of the '{@link #getValidationError() <em>Validation Error</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getValidationError()
	 * @generated
	 * @ordered
	 */
	protected EList<ValidationErrorType> validationError;

	/**
	 * The default value of the '{@link #isInvalid() <em>Invalid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInvalid()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INVALID_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInvalid() <em>Invalid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInvalid()
	 * @generated
	 * @ordered
	 */
	protected boolean invalid = INVALID_EDEFAULT;

	/**
	 * The default value of the '{@link #isTotallyInvalid() <em>Totally Invalid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isTotallyInvalid()
	 * @generated
	 * @ordered
	 */
	protected static final boolean TOTALLY_INVALID_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isTotallyInvalid() <em>Totally Invalid</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isTotallyInvalid()
	 * @generated
	 * @ordered
	 */
	protected boolean totallyInvalid = TOTALLY_INVALID_EDEFAULT;

	/**
	 * The default value of the '{@link #getLastValidationDate() <em>Last Validation Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastValidationDate()
	 * @generated
	 * @ordered
	 */
	protected static final Date LAST_VALIDATION_DATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getLastValidationDate() <em>Last Validation Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLastValidationDate()
	 * @generated
	 * @ordered
	 */
	protected Date lastValidationDate = LAST_VALIDATION_DATE_EDEFAULT;

	/**
	 * The default value of the '{@link #isDeleted() <em>Deleted</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDeleted()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DELETED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDeleted() <em>Deleted</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDeleted()
	 * @generated
	 * @ordered
	 */
	protected boolean deleted = DELETED_EDEFAULT;

	/**
	 * The default value of the '{@link #isHasOverlappingHoles() <em>Has Overlapping Holes</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHasOverlappingHoles()
	 * @generated
	 * @ordered
	 */
	protected static final boolean HAS_OVERLAPPING_HOLES_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isHasOverlappingHoles() <em>Has Overlapping Holes</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isHasOverlappingHoles()
	 * @generated
	 * @ordered
	 */
	protected boolean hasOverlappingHoles = HAS_OVERLAPPING_HOLES_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GolfCourseImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.GOLF_COURSE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getId() {
		return id;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setId(String newId) {
		String oldId = id;
		id = newId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__ID, oldId, id));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getCourseId() {
		return courseId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCourseId(String newCourseId) {
		String oldCourseId = courseId;
		courseId = newCourseId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__COURSE_ID, oldCourseId, courseId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CourseDetails getCourseDetails() {
		return courseDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCourseDetails(CourseDetails newCourseDetails, NotificationChain msgs) {
		CourseDetails oldCourseDetails = courseDetails;
		courseDetails = newCourseDetails;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS, oldCourseDetails, newCourseDetails);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCourseDetails(CourseDetails newCourseDetails) {
		if (newCourseDetails != courseDetails) {
			NotificationChain msgs = null;
			if (courseDetails != null)
				msgs = ((InternalEObject)courseDetails).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS, null, msgs);
			if (newCourseDetails != null)
				msgs = ((InternalEObject)newCourseDetails).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS, null, msgs);
			msgs = basicSetCourseDetails(newCourseDetails, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS, newCourseDetails, newCourseDetails));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CourseGPSVector getCourseGPSVector() {
		return courseGPSVector;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetCourseGPSVector(CourseGPSVector newCourseGPSVector, NotificationChain msgs) {
		CourseGPSVector oldCourseGPSVector = courseGPSVector;
		courseGPSVector = newCourseGPSVector;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR, oldCourseGPSVector, newCourseGPSVector);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setCourseGPSVector(CourseGPSVector newCourseGPSVector) {
		if (newCourseGPSVector != courseGPSVector) {
			NotificationChain msgs = null;
			if (courseGPSVector != null)
				msgs = ((InternalEObject)courseGPSVector).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR, null, msgs);
			if (newCourseGPSVector != null)
				msgs = ((InternalEObject)newCourseGPSVector).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR, null, msgs);
			msgs = basicSetCourseGPSVector(newCourseGPSVector, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR, newCourseGPSVector, newCourseGPSVector));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public CourseScorecards getScorecards() {
		return scorecards;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetScorecards(CourseScorecards newScorecards, NotificationChain msgs) {
		CourseScorecards oldScorecards = scorecards;
		scorecards = newScorecards;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__SCORECARDS, oldScorecards, newScorecards);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setScorecards(CourseScorecards newScorecards) {
		if (newScorecards != scorecards) {
			NotificationChain msgs = null;
			if (scorecards != null)
				msgs = ((InternalEObject)scorecards).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.GOLF_COURSE__SCORECARDS, null, msgs);
			if (newScorecards != null)
				msgs = ((InternalEObject)newScorecards).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - GolfCoursePackage.GOLF_COURSE__SCORECARDS, null, msgs);
			msgs = basicSetScorecards(newScorecards, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__SCORECARDS, newScorecards, newScorecards));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Tee> getTee() {
		if (tee == null) {
			tee = new EObjectContainmentEList<Tee>(Tee.class, this, GolfCoursePackage.GOLF_COURSE__TEE);
		}
		return tee;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<ValidationErrorType> getValidationError() {
		if (validationError == null) {
			validationError = new EDataTypeUniqueEList<ValidationErrorType>(ValidationErrorType.class, this, GolfCoursePackage.GOLF_COURSE__VALIDATION_ERROR);
		}
		return validationError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isInvalid() {
		return invalid;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setInvalid(boolean newInvalid) {
		boolean oldInvalid = invalid;
		invalid = newInvalid;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__INVALID, oldInvalid, invalid));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isTotallyInvalid() {
		return totallyInvalid;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTotallyInvalid(boolean newTotallyInvalid) {
		boolean oldTotallyInvalid = totallyInvalid;
		totallyInvalid = newTotallyInvalid;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__TOTALLY_INVALID, oldTotallyInvalid, totallyInvalid));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Date getLastValidationDate() {
		return lastValidationDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setLastValidationDate(Date newLastValidationDate) {
		Date oldLastValidationDate = lastValidationDate;
		lastValidationDate = newLastValidationDate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__LAST_VALIDATION_DATE, oldLastValidationDate, lastValidationDate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isDeleted() {
		return deleted;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setDeleted(boolean newDeleted) {
		boolean oldDeleted = deleted;
		deleted = newDeleted;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__DELETED, oldDeleted, deleted));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isHasOverlappingHoles() {
		return hasOverlappingHoles;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setHasOverlappingHoles(boolean newHasOverlappingHoles) {
		boolean oldHasOverlappingHoles = hasOverlappingHoles;
		hasOverlappingHoles = newHasOverlappingHoles;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.GOLF_COURSE__HAS_OVERLAPPING_HOLES, oldHasOverlappingHoles, hasOverlappingHoles));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS:
				return basicSetCourseDetails(null, msgs);
			case GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR:
				return basicSetCourseGPSVector(null, msgs);
			case GolfCoursePackage.GOLF_COURSE__SCORECARDS:
				return basicSetScorecards(null, msgs);
			case GolfCoursePackage.GOLF_COURSE__TEE:
				return ((InternalEList<?>)getTee()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.GOLF_COURSE__ID:
				return getId();
			case GolfCoursePackage.GOLF_COURSE__COURSE_ID:
				return getCourseId();
			case GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS:
				return getCourseDetails();
			case GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR:
				return getCourseGPSVector();
			case GolfCoursePackage.GOLF_COURSE__SCORECARDS:
				return getScorecards();
			case GolfCoursePackage.GOLF_COURSE__TEE:
				return getTee();
			case GolfCoursePackage.GOLF_COURSE__VALIDATION_ERROR:
				return getValidationError();
			case GolfCoursePackage.GOLF_COURSE__INVALID:
				return isInvalid();
			case GolfCoursePackage.GOLF_COURSE__TOTALLY_INVALID:
				return isTotallyInvalid();
			case GolfCoursePackage.GOLF_COURSE__LAST_VALIDATION_DATE:
				return getLastValidationDate();
			case GolfCoursePackage.GOLF_COURSE__DELETED:
				return isDeleted();
			case GolfCoursePackage.GOLF_COURSE__HAS_OVERLAPPING_HOLES:
				return isHasOverlappingHoles();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.GOLF_COURSE__ID:
				setId((String)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__COURSE_ID:
				setCourseId((String)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS:
				setCourseDetails((CourseDetails)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR:
				setCourseGPSVector((CourseGPSVector)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__SCORECARDS:
				setScorecards((CourseScorecards)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__TEE:
				getTee().clear();
				getTee().addAll((Collection<? extends Tee>)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__VALIDATION_ERROR:
				getValidationError().clear();
				getValidationError().addAll((Collection<? extends ValidationErrorType>)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__INVALID:
				setInvalid((Boolean)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__TOTALLY_INVALID:
				setTotallyInvalid((Boolean)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__LAST_VALIDATION_DATE:
				setLastValidationDate((Date)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__DELETED:
				setDeleted((Boolean)newValue);
				return;
			case GolfCoursePackage.GOLF_COURSE__HAS_OVERLAPPING_HOLES:
				setHasOverlappingHoles((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.GOLF_COURSE__ID:
				setId(ID_EDEFAULT);
				return;
			case GolfCoursePackage.GOLF_COURSE__COURSE_ID:
				setCourseId(COURSE_ID_EDEFAULT);
				return;
			case GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS:
				setCourseDetails((CourseDetails)null);
				return;
			case GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR:
				setCourseGPSVector((CourseGPSVector)null);
				return;
			case GolfCoursePackage.GOLF_COURSE__SCORECARDS:
				setScorecards((CourseScorecards)null);
				return;
			case GolfCoursePackage.GOLF_COURSE__TEE:
				getTee().clear();
				return;
			case GolfCoursePackage.GOLF_COURSE__VALIDATION_ERROR:
				getValidationError().clear();
				return;
			case GolfCoursePackage.GOLF_COURSE__INVALID:
				setInvalid(INVALID_EDEFAULT);
				return;
			case GolfCoursePackage.GOLF_COURSE__TOTALLY_INVALID:
				setTotallyInvalid(TOTALLY_INVALID_EDEFAULT);
				return;
			case GolfCoursePackage.GOLF_COURSE__LAST_VALIDATION_DATE:
				setLastValidationDate(LAST_VALIDATION_DATE_EDEFAULT);
				return;
			case GolfCoursePackage.GOLF_COURSE__DELETED:
				setDeleted(DELETED_EDEFAULT);
				return;
			case GolfCoursePackage.GOLF_COURSE__HAS_OVERLAPPING_HOLES:
				setHasOverlappingHoles(HAS_OVERLAPPING_HOLES_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.GOLF_COURSE__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case GolfCoursePackage.GOLF_COURSE__COURSE_ID:
				return COURSE_ID_EDEFAULT == null ? courseId != null : !COURSE_ID_EDEFAULT.equals(courseId);
			case GolfCoursePackage.GOLF_COURSE__COURSE_DETAILS:
				return courseDetails != null;
			case GolfCoursePackage.GOLF_COURSE__COURSE_GPS_VECTOR:
				return courseGPSVector != null;
			case GolfCoursePackage.GOLF_COURSE__SCORECARDS:
				return scorecards != null;
			case GolfCoursePackage.GOLF_COURSE__TEE:
				return tee != null && !tee.isEmpty();
			case GolfCoursePackage.GOLF_COURSE__VALIDATION_ERROR:
				return validationError != null && !validationError.isEmpty();
			case GolfCoursePackage.GOLF_COURSE__INVALID:
				return invalid != INVALID_EDEFAULT;
			case GolfCoursePackage.GOLF_COURSE__TOTALLY_INVALID:
				return totallyInvalid != TOTALLY_INVALID_EDEFAULT;
			case GolfCoursePackage.GOLF_COURSE__LAST_VALIDATION_DATE:
				return LAST_VALIDATION_DATE_EDEFAULT == null ? lastValidationDate != null : !LAST_VALIDATION_DATE_EDEFAULT.equals(lastValidationDate);
			case GolfCoursePackage.GOLF_COURSE__DELETED:
				return deleted != DELETED_EDEFAULT;
			case GolfCoursePackage.GOLF_COURSE__HAS_OVERLAPPING_HOLES:
				return hasOverlappingHoles != HAS_OVERLAPPING_HOLES_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (id: ");
		result.append(id);
		result.append(", courseId: ");
		result.append(courseId);
		result.append(", validationError: ");
		result.append(validationError);
		result.append(", invalid: ");
		result.append(invalid);
		result.append(", totallyInvalid: ");
		result.append(totallyInvalid);
		result.append(", lastValidationDate: ");
		result.append(lastValidationDate);
		result.append(", deleted: ");
		result.append(deleted);
		result.append(", hasOverlappingHoles: ");
		result.append(hasOverlappingHoles);
		result.append(')');
		return result.toString();
	}

} //GolfCourseImpl
