/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.Address;
import com.playertour.backend.golfcourse.model.golfcourse.Attributes;
import com.playertour.backend.golfcourse.model.golfcourse.Contact;
import com.playertour.backend.golfcourse.model.golfcourse.CourseDetails;
import com.playertour.backend.golfcourse.model.golfcourse.CourseGPSVector;
import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo;
import com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards;
import com.playertour.backend.golfcourse.model.golfcourse.DescriptionType;
import com.playertour.backend.golfcourse.model.golfcourse.DressCodeType;
import com.playertour.backend.golfcourse.model.golfcourse.GenderType;
import com.playertour.backend.golfcourse.model.golfcourse.GeometryType;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourse;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourseFactory;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCourseType;
import com.playertour.backend.golfcourse.model.golfcourse.Hole;
import com.playertour.backend.golfcourse.model.golfcourse.Location;
import com.playertour.backend.golfcourse.model.golfcourse.PriceTable;
import com.playertour.backend.golfcourse.model.golfcourse.Shape;
import com.playertour.backend.golfcourse.model.golfcourse.ShapeObject;
import com.playertour.backend.golfcourse.model.golfcourse.ShapeWrapper;
import com.playertour.backend.golfcourse.model.golfcourse.SizeType;
import com.playertour.backend.golfcourse.model.golfcourse.Tee;
import com.playertour.backend.golfcourse.model.golfcourse.ValidationErrorType;
import com.playertour.backend.golfcourse.model.golfcourse.VegetationType;
import com.playertour.backend.golfcourse.model.golfcourse.WeekDay;

import geojson.GeojsonPackage;

import geojson.impl.GeojsonPackageImpl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import org.eclipse.emf.ecore.impl.EPackageImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class GolfCoursePackageImpl extends EPackageImpl implements GolfCoursePackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass golfCourseEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass courseDetailsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass courseGPSVectorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass addressEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass contactEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass locationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass priceTableEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass shapeObjectEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass shapeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass attributesEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass shapeWrapperEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass holeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass courseScorecardInfoEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass courseScorecardsEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass teeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum geometryTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum sizeTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum descriptionTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum vegetationTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum golfCourseTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum dressCodeTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum weekDayEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum genderTypeEEnum = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum validationErrorTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private GolfCoursePackageImpl() {
		super(eNS_URI, GolfCourseFactory.eINSTANCE);
	}
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>This method is used to initialize {@link GolfCoursePackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static GolfCoursePackage init() {
		if (isInited) return (GolfCoursePackage)EPackage.Registry.INSTANCE.getEPackage(GolfCoursePackage.eNS_URI);

		// Obtain or create and register package
		Object registeredGolfCoursePackage = EPackage.Registry.INSTANCE.get(eNS_URI);
		GolfCoursePackageImpl theGolfCoursePackage = registeredGolfCoursePackage instanceof GolfCoursePackageImpl ? (GolfCoursePackageImpl)registeredGolfCoursePackage : new GolfCoursePackageImpl();

		isInited = true;

		// Obtain or create and register interdependencies
		Object registeredPackage = EPackage.Registry.INSTANCE.getEPackage(GeojsonPackage.eNS_URI);
		GeojsonPackageImpl theGeojsonPackage = (GeojsonPackageImpl)(registeredPackage instanceof GeojsonPackageImpl ? registeredPackage : GeojsonPackage.eINSTANCE);

		// Create package meta-data objects
		theGolfCoursePackage.createPackageContents();
		theGeojsonPackage.createPackageContents();

		// Initialize created meta-data
		theGolfCoursePackage.initializePackageContents();
		theGeojsonPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theGolfCoursePackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(GolfCoursePackage.eNS_URI, theGolfCoursePackage);
		return theGolfCoursePackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getGolfCourse() {
		return golfCourseEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_Id() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_CourseId() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGolfCourse_CourseDetails() {
		return (EReference)golfCourseEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGolfCourse_CourseGPSVector() {
		return (EReference)golfCourseEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGolfCourse_Scorecards() {
		return (EReference)golfCourseEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getGolfCourse_Tee() {
		return (EReference)golfCourseEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_ValidationError() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_Invalid() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_TotallyInvalid() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_LastValidationDate() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_Deleted() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getGolfCourse_HasOverlappingHoles() {
		return (EAttribute)golfCourseEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCourseDetails() {
		return courseDetailsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_CourseName() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_HoleNum() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_CountryId() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_StateId() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseDetails_Address() {
		return (EReference)courseDetailsEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseDetails_Contact() {
		return (EReference)courseDetailsEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_Type() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_Seasonal() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_DressCode() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_DayClosed() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseDetails_Pricing() {
		return (EReference)courseDetailsEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseDetails_Location() {
		return (EReference)courseDetailsEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_ImageUrl() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_CountryShortName() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_CountryFullName() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_StateShortName() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(15);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseDetails_StateFullName() {
		return (EAttribute)courseDetailsEClass.getEStructuralFeatures().get(16);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCourseGPSVector() {
		return courseGPSVectorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseGPSVector_HoleCount() {
		return (EAttribute)courseGPSVectorEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Ocean() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Backgrund() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Bridge() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Vegetation() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Creek() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Pond() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Sand() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Rock() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Lake() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Water() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Tree() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Clubhouse() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Lava() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Path() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseGPSVector_Holes() {
		return (EReference)courseGPSVectorEClass.getEStructuralFeatures().get(15);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAddress() {
		return addressEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAddress_Route() {
		return (EAttribute)addressEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAddress_ZipCode() {
		return (EAttribute)addressEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAddress_City() {
		return (EAttribute)addressEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAddress_State() {
		return (EAttribute)addressEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAddress_Country() {
		return (EAttribute)addressEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getContact() {
		return contactEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContact_Email() {
		return (EAttribute)contactEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContact_Phone() {
		return (EAttribute)contactEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContact_Url() {
		return (EAttribute)contactEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getContact_Fax() {
		return (EAttribute)contactEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getLocation() {
		return locationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLocation_Latitude() {
		return (EAttribute)locationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getLocation_Longitude() {
		return (EAttribute)locationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getPriceTable() {
		return priceTableEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPriceTable_Weekend9() {
		return (EAttribute)priceTableEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPriceTable_Weekend18() {
		return (EAttribute)priceTableEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPriceTable_Weekday9() {
		return (EAttribute)priceTableEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPriceTable_Weekday18() {
		return (EAttribute)priceTableEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getPriceTable_Twilight() {
		return (EAttribute)priceTableEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getShapeObject() {
		return shapeObjectEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getShapeObject_ShapeCount() {
		return (EAttribute)shapeObjectEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getShapeObject_Shapes() {
		return (EReference)shapeObjectEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getShapeObject_FeatureCollection() {
		return (EReference)shapeObjectEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getShape() {
		return shapeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getShape_Attributes() {
		return (EReference)shapeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getShape_Wrapper() {
		return (EReference)shapeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getAttributes() {
		return attributesEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAttributes_Vegetation() {
		return (EAttribute)attributesEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAttributes_Size() {
		return (EAttribute)attributesEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getAttributes_Description() {
		return (EAttribute)attributesEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getShapeWrapper() {
		return shapeWrapperEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getShapeWrapper_IgolfString() {
		return (EAttribute)shapeWrapperEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getShapeWrapper_Points() {
		return (EReference)shapeWrapperEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getHole() {
		return holeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getHole_HoleNumber() {
		return (EAttribute)holeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_GreenCenter() {
		return (EReference)holeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_Bunker() {
		return (EReference)holeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_CentralPath() {
		return (EReference)holeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_TeeboxCenter() {
		return (EReference)holeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_Perimeter() {
		return (EReference)holeEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_Green() {
		return (EReference)holeEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_Fairway() {
		return (EReference)holeEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getHole_Teebox() {
		return (EReference)holeEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCourseScorecardInfo() {
		return courseScorecardInfoEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_HcpHole() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_ParHole() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_ParIn() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_ManualParIn() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_ParOut() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_ManualParOut() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_ParTotal() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecardInfo_ManualParTotal() {
		return (EAttribute)courseScorecardInfoEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getCourseScorecards() {
		return courseScorecardsEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseScorecards_MenScorecard() {
		return (EReference)courseScorecardsEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EReference getCourseScorecards_WmnScorecard() {
		return (EReference)courseScorecardsEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getCourseScorecards_CourseId() {
		return (EAttribute)courseScorecardsEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EClass getTee() {
		return teeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Name() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Color() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_ColorValue() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Gender() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Rating() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Slope() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_YdsTotal() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Yds1to9() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Yds10to18() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Yds1to18() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_YdsHole() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_MetersTotal() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(11);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Meters1to9() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(12);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Meters10to18() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(13);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_Meters1to18() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(14);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EAttribute getTee_MetersHole() {
		return (EAttribute)teeEClass.getEStructuralFeatures().get(15);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getGeometryType() {
		return geometryTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getSizeType() {
		return sizeTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getDescriptionType() {
		return descriptionTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getVegetationType() {
		return vegetationTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getGolfCourseType() {
		return golfCourseTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getDressCodeType() {
		return dressCodeTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getWeekDay() {
		return weekDayEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getGenderType() {
		return genderTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EEnum getValidationErrorType() {
		return validationErrorTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GolfCourseFactory getGolfCourseFactory() {
		return (GolfCourseFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		golfCourseEClass = createEClass(GOLF_COURSE);
		createEAttribute(golfCourseEClass, GOLF_COURSE__ID);
		createEAttribute(golfCourseEClass, GOLF_COURSE__COURSE_ID);
		createEReference(golfCourseEClass, GOLF_COURSE__COURSE_DETAILS);
		createEReference(golfCourseEClass, GOLF_COURSE__COURSE_GPS_VECTOR);
		createEReference(golfCourseEClass, GOLF_COURSE__SCORECARDS);
		createEReference(golfCourseEClass, GOLF_COURSE__TEE);
		createEAttribute(golfCourseEClass, GOLF_COURSE__VALIDATION_ERROR);
		createEAttribute(golfCourseEClass, GOLF_COURSE__INVALID);
		createEAttribute(golfCourseEClass, GOLF_COURSE__TOTALLY_INVALID);
		createEAttribute(golfCourseEClass, GOLF_COURSE__LAST_VALIDATION_DATE);
		createEAttribute(golfCourseEClass, GOLF_COURSE__DELETED);
		createEAttribute(golfCourseEClass, GOLF_COURSE__HAS_OVERLAPPING_HOLES);

		courseDetailsEClass = createEClass(COURSE_DETAILS);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__COURSE_NAME);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__HOLE_NUM);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__COUNTRY_ID);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__STATE_ID);
		createEReference(courseDetailsEClass, COURSE_DETAILS__ADDRESS);
		createEReference(courseDetailsEClass, COURSE_DETAILS__CONTACT);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__TYPE);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__SEASONAL);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__DRESS_CODE);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__DAY_CLOSED);
		createEReference(courseDetailsEClass, COURSE_DETAILS__PRICING);
		createEReference(courseDetailsEClass, COURSE_DETAILS__LOCATION);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__IMAGE_URL);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__COUNTRY_SHORT_NAME);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__COUNTRY_FULL_NAME);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__STATE_SHORT_NAME);
		createEAttribute(courseDetailsEClass, COURSE_DETAILS__STATE_FULL_NAME);

		courseGPSVectorEClass = createEClass(COURSE_GPS_VECTOR);
		createEAttribute(courseGPSVectorEClass, COURSE_GPS_VECTOR__HOLE_COUNT);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__OCEAN);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__BACKGRUND);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__BRIDGE);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__VEGETATION);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__CREEK);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__POND);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__SAND);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__ROCK);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__LAKE);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__WATER);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__TREE);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__CLUBHOUSE);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__LAVA);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__PATH);
		createEReference(courseGPSVectorEClass, COURSE_GPS_VECTOR__HOLES);

		addressEClass = createEClass(ADDRESS);
		createEAttribute(addressEClass, ADDRESS__ROUTE);
		createEAttribute(addressEClass, ADDRESS__ZIP_CODE);
		createEAttribute(addressEClass, ADDRESS__CITY);
		createEAttribute(addressEClass, ADDRESS__STATE);
		createEAttribute(addressEClass, ADDRESS__COUNTRY);

		contactEClass = createEClass(CONTACT);
		createEAttribute(contactEClass, CONTACT__EMAIL);
		createEAttribute(contactEClass, CONTACT__PHONE);
		createEAttribute(contactEClass, CONTACT__URL);
		createEAttribute(contactEClass, CONTACT__FAX);

		locationEClass = createEClass(LOCATION);
		createEAttribute(locationEClass, LOCATION__LATITUDE);
		createEAttribute(locationEClass, LOCATION__LONGITUDE);

		priceTableEClass = createEClass(PRICE_TABLE);
		createEAttribute(priceTableEClass, PRICE_TABLE__WEEKEND9);
		createEAttribute(priceTableEClass, PRICE_TABLE__WEEKEND18);
		createEAttribute(priceTableEClass, PRICE_TABLE__WEEKDAY9);
		createEAttribute(priceTableEClass, PRICE_TABLE__WEEKDAY18);
		createEAttribute(priceTableEClass, PRICE_TABLE__TWILIGHT);

		shapeObjectEClass = createEClass(SHAPE_OBJECT);
		createEAttribute(shapeObjectEClass, SHAPE_OBJECT__SHAPE_COUNT);
		createEReference(shapeObjectEClass, SHAPE_OBJECT__SHAPES);
		createEReference(shapeObjectEClass, SHAPE_OBJECT__FEATURE_COLLECTION);

		shapeEClass = createEClass(SHAPE);
		createEReference(shapeEClass, SHAPE__ATTRIBUTES);
		createEReference(shapeEClass, SHAPE__WRAPPER);

		attributesEClass = createEClass(ATTRIBUTES);
		createEAttribute(attributesEClass, ATTRIBUTES__VEGETATION);
		createEAttribute(attributesEClass, ATTRIBUTES__SIZE);
		createEAttribute(attributesEClass, ATTRIBUTES__DESCRIPTION);

		shapeWrapperEClass = createEClass(SHAPE_WRAPPER);
		createEAttribute(shapeWrapperEClass, SHAPE_WRAPPER__IGOLF_STRING);
		createEReference(shapeWrapperEClass, SHAPE_WRAPPER__POINTS);

		holeEClass = createEClass(HOLE);
		createEAttribute(holeEClass, HOLE__HOLE_NUMBER);
		createEReference(holeEClass, HOLE__GREEN_CENTER);
		createEReference(holeEClass, HOLE__BUNKER);
		createEReference(holeEClass, HOLE__CENTRAL_PATH);
		createEReference(holeEClass, HOLE__TEEBOX_CENTER);
		createEReference(holeEClass, HOLE__PERIMETER);
		createEReference(holeEClass, HOLE__GREEN);
		createEReference(holeEClass, HOLE__FAIRWAY);
		createEReference(holeEClass, HOLE__TEEBOX);

		courseScorecardInfoEClass = createEClass(COURSE_SCORECARD_INFO);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__HCP_HOLE);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__PAR_HOLE);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__PAR_IN);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__MANUAL_PAR_IN);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__PAR_OUT);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__MANUAL_PAR_OUT);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__PAR_TOTAL);
		createEAttribute(courseScorecardInfoEClass, COURSE_SCORECARD_INFO__MANUAL_PAR_TOTAL);

		courseScorecardsEClass = createEClass(COURSE_SCORECARDS);
		createEReference(courseScorecardsEClass, COURSE_SCORECARDS__MEN_SCORECARD);
		createEReference(courseScorecardsEClass, COURSE_SCORECARDS__WMN_SCORECARD);
		createEAttribute(courseScorecardsEClass, COURSE_SCORECARDS__COURSE_ID);

		teeEClass = createEClass(TEE);
		createEAttribute(teeEClass, TEE__NAME);
		createEAttribute(teeEClass, TEE__COLOR);
		createEAttribute(teeEClass, TEE__COLOR_VALUE);
		createEAttribute(teeEClass, TEE__GENDER);
		createEAttribute(teeEClass, TEE__RATING);
		createEAttribute(teeEClass, TEE__SLOPE);
		createEAttribute(teeEClass, TEE__YDS_TOTAL);
		createEAttribute(teeEClass, TEE__YDS1TO9);
		createEAttribute(teeEClass, TEE__YDS10TO18);
		createEAttribute(teeEClass, TEE__YDS1TO18);
		createEAttribute(teeEClass, TEE__YDS_HOLE);
		createEAttribute(teeEClass, TEE__METERS_TOTAL);
		createEAttribute(teeEClass, TEE__METERS1TO9);
		createEAttribute(teeEClass, TEE__METERS10TO18);
		createEAttribute(teeEClass, TEE__METERS1TO18);
		createEAttribute(teeEClass, TEE__METERS_HOLE);

		// Create enums
		geometryTypeEEnum = createEEnum(GEOMETRY_TYPE);
		sizeTypeEEnum = createEEnum(SIZE_TYPE);
		descriptionTypeEEnum = createEEnum(DESCRIPTION_TYPE);
		vegetationTypeEEnum = createEEnum(VEGETATION_TYPE);
		golfCourseTypeEEnum = createEEnum(GOLF_COURSE_TYPE);
		dressCodeTypeEEnum = createEEnum(DRESS_CODE_TYPE);
		weekDayEEnum = createEEnum(WEEK_DAY);
		genderTypeEEnum = createEEnum(GENDER_TYPE);
		validationErrorTypeEEnum = createEEnum(VALIDATION_ERROR_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		GeojsonPackage theGeojsonPackage = (GeojsonPackage)EPackage.Registry.INSTANCE.getEPackage(GeojsonPackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes

		// Initialize classes, features, and operations; add parameters
		initEClass(golfCourseEClass, GolfCourse.class, "GolfCourse", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getGolfCourse_Id(), ecorePackage.getEString(), "id", null, 1, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_CourseId(), ecorePackage.getEString(), "courseId", null, 1, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGolfCourse_CourseDetails(), this.getCourseDetails(), null, "courseDetails", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGolfCourse_CourseGPSVector(), this.getCourseGPSVector(), null, "courseGPSVector", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGolfCourse_Scorecards(), this.getCourseScorecards(), null, "scorecards", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getGolfCourse_Tee(), this.getTee(), null, "tee", null, 0, -1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_ValidationError(), this.getValidationErrorType(), "validationError", null, 0, -1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_Invalid(), ecorePackage.getEBoolean(), "invalid", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_TotallyInvalid(), ecorePackage.getEBoolean(), "totallyInvalid", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_LastValidationDate(), ecorePackage.getEDate(), "lastValidationDate", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_Deleted(), ecorePackage.getEBoolean(), "deleted", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getGolfCourse_HasOverlappingHoles(), ecorePackage.getEBoolean(), "hasOverlappingHoles", null, 0, 1, GolfCourse.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(courseDetailsEClass, CourseDetails.class, "CourseDetails", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCourseDetails_CourseName(), ecorePackage.getEString(), "courseName", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_HoleNum(), ecorePackage.getEInt(), "holeNum", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_CountryId(), ecorePackage.getEString(), "countryId", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_StateId(), ecorePackage.getEString(), "stateId", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseDetails_Address(), this.getAddress(), null, "address", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseDetails_Contact(), this.getContact(), null, "contact", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_Type(), this.getGolfCourseType(), "type", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_Seasonal(), ecorePackage.getEBoolean(), "seasonal", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_DressCode(), this.getDressCodeType(), "dressCode", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_DayClosed(), this.getWeekDay(), "dayClosed", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseDetails_Pricing(), this.getPriceTable(), null, "pricing", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseDetails_Location(), this.getLocation(), null, "location", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_ImageUrl(), ecorePackage.getEString(), "imageUrl", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_CountryShortName(), ecorePackage.getEString(), "countryShortName", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_CountryFullName(), ecorePackage.getEString(), "countryFullName", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_StateShortName(), ecorePackage.getEString(), "stateShortName", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseDetails_StateFullName(), ecorePackage.getEString(), "stateFullName", null, 0, 1, CourseDetails.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(courseGPSVectorEClass, CourseGPSVector.class, "CourseGPSVector", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCourseGPSVector_HoleCount(), ecorePackage.getEInt(), "holeCount", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Ocean(), this.getShapeObject(), null, "ocean", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Backgrund(), this.getShapeObject(), null, "backgrund", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Bridge(), this.getShapeObject(), null, "bridge", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Vegetation(), this.getShapeObject(), null, "vegetation", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Creek(), this.getShapeObject(), null, "creek", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Pond(), this.getShapeObject(), null, "pond", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Sand(), this.getShapeObject(), null, "sand", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Rock(), this.getShapeObject(), null, "rock", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Lake(), this.getShapeObject(), null, "lake", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Water(), this.getShapeObject(), null, "water", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Tree(), this.getShapeObject(), null, "tree", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Clubhouse(), this.getShapeObject(), null, "clubhouse", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Lava(), this.getShapeObject(), null, "lava", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Path(), this.getShapeObject(), null, "path", null, 0, 1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseGPSVector_Holes(), this.getHole(), null, "holes", null, 0, -1, CourseGPSVector.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(addressEClass, Address.class, "Address", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAddress_Route(), ecorePackage.getEString(), "route", null, 0, 1, Address.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAddress_ZipCode(), ecorePackage.getEString(), "zipCode", null, 0, 1, Address.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAddress_City(), ecorePackage.getEString(), "city", null, 0, 1, Address.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAddress_State(), ecorePackage.getEString(), "state", null, 0, 1, Address.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAddress_Country(), ecorePackage.getEString(), "country", null, 0, 1, Address.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(contactEClass, Contact.class, "Contact", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getContact_Email(), ecorePackage.getEString(), "email", null, 0, 1, Contact.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContact_Phone(), ecorePackage.getEString(), "phone", null, 0, 1, Contact.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContact_Url(), ecorePackage.getEString(), "url", null, 0, 1, Contact.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getContact_Fax(), ecorePackage.getEString(), "fax", null, 0, 1, Contact.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(locationEClass, Location.class, "Location", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getLocation_Latitude(), ecorePackage.getEDouble(), "latitude", null, 0, 1, Location.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getLocation_Longitude(), ecorePackage.getEDouble(), "longitude", null, 0, 1, Location.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(priceTableEClass, PriceTable.class, "PriceTable", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getPriceTable_Weekend9(), ecorePackage.getEDouble(), "weekend9", null, 0, 1, PriceTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPriceTable_Weekend18(), ecorePackage.getEDouble(), "weekend18", null, 0, 1, PriceTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPriceTable_Weekday9(), ecorePackage.getEDouble(), "weekday9", null, 0, 1, PriceTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPriceTable_Weekday18(), ecorePackage.getEDouble(), "weekday18", null, 0, 1, PriceTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getPriceTable_Twilight(), ecorePackage.getEDouble(), "twilight", null, 0, 1, PriceTable.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(shapeObjectEClass, ShapeObject.class, "ShapeObject", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getShapeObject_ShapeCount(), ecorePackage.getEInt(), "shapeCount", null, 0, 1, ShapeObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getShapeObject_Shapes(), this.getShape(), null, "shapes", null, 0, -1, ShapeObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getShapeObject_FeatureCollection(), theGeojsonPackage.getFeatureCollection(), null, "featureCollection", null, 0, 1, ShapeObject.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(shapeEClass, Shape.class, "Shape", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getShape_Attributes(), this.getAttributes(), null, "attributes", null, 0, 1, Shape.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getShape_Wrapper(), this.getShapeWrapper(), null, "wrapper", null, 0, 1, Shape.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(attributesEClass, Attributes.class, "Attributes", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAttributes_Vegetation(), this.getVegetationType(), "vegetation", null, 0, 1, Attributes.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributes_Size(), this.getSizeType(), "size", null, 0, 1, Attributes.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAttributes_Description(), this.getDescriptionType(), "description", null, 0, 1, Attributes.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(shapeWrapperEClass, ShapeWrapper.class, "ShapeWrapper", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getShapeWrapper_IgolfString(), ecorePackage.getEString(), "igolfString", null, 0, 1, ShapeWrapper.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getShapeWrapper_Points(), this.getLocation(), null, "points", null, 0, -1, ShapeWrapper.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(holeEClass, Hole.class, "Hole", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getHole_HoleNumber(), ecorePackage.getEInt(), "holeNumber", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_GreenCenter(), this.getShapeObject(), null, "greenCenter", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_Bunker(), this.getShapeObject(), null, "bunker", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_CentralPath(), this.getShapeObject(), null, "centralPath", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_TeeboxCenter(), this.getShapeObject(), null, "teeboxCenter", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_Perimeter(), this.getShapeObject(), null, "perimeter", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_Green(), this.getShapeObject(), null, "green", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_Fairway(), this.getShapeObject(), null, "fairway", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getHole_Teebox(), this.getShapeObject(), null, "teebox", null, 0, 1, Hole.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(courseScorecardInfoEClass, CourseScorecardInfo.class, "CourseScorecardInfo", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getCourseScorecardInfo_HcpHole(), ecorePackage.getEIntegerObject(), "hcpHole", null, 0, -1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecardInfo_ParHole(), ecorePackage.getEIntegerObject(), "parHole", null, 0, -1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecardInfo_ParIn(), ecorePackage.getEIntegerObject(), "parIn", null, 0, 1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecardInfo_ManualParIn(), ecorePackage.getEInt(), "manualParIn", null, 0, 1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecardInfo_ParOut(), ecorePackage.getEIntegerObject(), "parOut", null, 0, 1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecardInfo_ManualParOut(), ecorePackage.getEInt(), "manualParOut", null, 0, 1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecardInfo_ParTotal(), ecorePackage.getEIntegerObject(), "parTotal", null, 0, 1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecardInfo_ManualParTotal(), ecorePackage.getEInt(), "manualParTotal", null, 0, 1, CourseScorecardInfo.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(courseScorecardsEClass, CourseScorecards.class, "CourseScorecards", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getCourseScorecards_MenScorecard(), this.getCourseScorecardInfo(), null, "menScorecard", null, 0, -1, CourseScorecards.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getCourseScorecards_WmnScorecard(), this.getCourseScorecardInfo(), null, "wmnScorecard", null, 0, -1, CourseScorecards.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getCourseScorecards_CourseId(), ecorePackage.getEString(), "courseId", null, 1, 1, CourseScorecards.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(teeEClass, Tee.class, "Tee", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTee_Name(), ecorePackage.getEString(), "name", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Color(), ecorePackage.getEString(), "color", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_ColorValue(), ecorePackage.getEString(), "colorValue", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Gender(), this.getGenderType(), "gender", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Rating(), ecorePackage.getEDouble(), "rating", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Slope(), ecorePackage.getEIntegerObject(), "slope", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_YdsTotal(), ecorePackage.getEIntegerObject(), "ydsTotal", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Yds1to9(), ecorePackage.getEString(), "yds1to9", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Yds10to18(), ecorePackage.getEString(), "yds10to18", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Yds1to18(), ecorePackage.getEString(), "yds1to18", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_YdsHole(), ecorePackage.getEIntegerObject(), "ydsHole", null, 0, -1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_MetersTotal(), ecorePackage.getEIntegerObject(), "metersTotal", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Meters1to9(), ecorePackage.getEString(), "meters1to9", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Meters10to18(), ecorePackage.getEString(), "meters10to18", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_Meters1to18(), ecorePackage.getEString(), "meters1to18", null, 0, 1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTee_MetersHole(), ecorePackage.getEIntegerObject(), "metersHole", null, 0, -1, Tee.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, !IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(geometryTypeEEnum, GeometryType.class, "GeometryType");
		addEEnumLiteral(geometryTypeEEnum, GeometryType.POINT);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.LINE_STRING);
		addEEnumLiteral(geometryTypeEEnum, GeometryType.POLYGON);

		initEEnum(sizeTypeEEnum, SizeType.class, "SizeType");
		addEEnumLiteral(sizeTypeEEnum, SizeType.NOT_APPLICABLE);
		addEEnumLiteral(sizeTypeEEnum, SizeType.SMALL);
		addEEnumLiteral(sizeTypeEEnum, SizeType.MEDIUM);
		addEEnumLiteral(sizeTypeEEnum, SizeType.LARGE);

		initEEnum(descriptionTypeEEnum, DescriptionType.class, "DescriptionType");
		addEEnumLiteral(descriptionTypeEEnum, DescriptionType.NOT_APPLICABLE);
		addEEnumLiteral(descriptionTypeEEnum, DescriptionType.ROUGH);
		addEEnumLiteral(descriptionTypeEEnum, DescriptionType.DESERT);

		initEEnum(vegetationTypeEEnum, VegetationType.class, "VegetationType");
		addEEnumLiteral(vegetationTypeEEnum, VegetationType.NOT_APPLICABLE);
		addEEnumLiteral(vegetationTypeEEnum, VegetationType.THIN);
		addEEnumLiteral(vegetationTypeEEnum, VegetationType.WIDE);

		initEEnum(golfCourseTypeEEnum, GolfCourseType.class, "GolfCourseType");
		addEEnumLiteral(golfCourseTypeEEnum, GolfCourseType.PUBLIC);
		addEEnumLiteral(golfCourseTypeEEnum, GolfCourseType.PRIVATE);
		addEEnumLiteral(golfCourseTypeEEnum, GolfCourseType.SEMI_PRIVATE);
		addEEnumLiteral(golfCourseTypeEEnum, GolfCourseType.MILITARY);
		addEEnumLiteral(golfCourseTypeEEnum, GolfCourseType.RESORT);
		addEEnumLiteral(golfCourseTypeEEnum, GolfCourseType.OTHER);

		initEEnum(dressCodeTypeEEnum, DressCodeType.class, "DressCodeType");
		addEEnumLiteral(dressCodeTypeEEnum, DressCodeType.NO_DENIM);
		addEEnumLiteral(dressCodeTypeEEnum, DressCodeType.DENIM_OK);
		addEEnumLiteral(dressCodeTypeEEnum, DressCodeType.OTHER);

		initEEnum(weekDayEEnum, WeekDay.class, "WeekDay");
		addEEnumLiteral(weekDayEEnum, WeekDay.SUN);
		addEEnumLiteral(weekDayEEnum, WeekDay.MON);
		addEEnumLiteral(weekDayEEnum, WeekDay.TUE);
		addEEnumLiteral(weekDayEEnum, WeekDay.WED);
		addEEnumLiteral(weekDayEEnum, WeekDay.THU);
		addEEnumLiteral(weekDayEEnum, WeekDay.FRI);
		addEEnumLiteral(weekDayEEnum, WeekDay.SAT);

		initEEnum(genderTypeEEnum, GenderType.class, "GenderType");
		addEEnumLiteral(genderTypeEEnum, GenderType.MEN);
		addEEnumLiteral(genderTypeEEnum, GenderType.WOMEN);

		initEEnum(validationErrorTypeEEnum, ValidationErrorType.class, "ValidationErrorType");
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.MISSING_GPS);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.MISSING_SCORECARD);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.HOLE_NUM_NOT_9NOR_18);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_INCONSITENT_PAR_HOLE);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_INCONSISTENT_HCP_HOLE);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_PAR_TOTAL_ZERO);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_PAR_TOTAL_NULL);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_PAR_IN_ZERO);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_PAR_IN_NULL);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_PAR_OUT_ZERO);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.SCORECARD_PAR_OUT_NULL);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.MISSING_TEE);
		addEEnumLiteral(validationErrorTypeEEnum, ValidationErrorType.TEE_INCONSITENT_YDS_HOLE);

		// Create resource
		createResource(eNS_URI);

		// Create annotations
		// http://www.eclipse.org/emf/2002/GenModel
		createGenModelAnnotations();
	}

	/**
	 * Initializes the annotations for <b>http://www.eclipse.org/emf/2002/GenModel</b>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void createGenModelAnnotations() {
		String source = "http://www.eclipse.org/emf/2002/GenModel";
		addAnnotation
		  (getGolfCourse_Invalid(),
		   source,
		   new String[] {
			   "documentation", "A GolfCourse is considered invalid if it has missing, incomplete or inconsistent information "
		   });
		addAnnotation
		  (getGolfCourse_TotallyInvalid(),
		   source,
		   new String[] {
			   "documentation", "A GolfCourse is considered totallyInvalid if it is missing GPS info, or Scorecard info, or if the information on the Scorecards are not consistent with the number of holes"
		   });
		addAnnotation
		  (getGolfCourse_HasOverlappingHoles(),
		   source,
		   new String[] {
			   "documentation", "This attribute is set to true when the course is marked as an 18 holes but is actually a 9 holes course, where holes 10-18 are the same as holes 1-9"
		   });
		addAnnotation
		  (getCourseDetails_HoleNum(),
		   source,
		   new String[] {
			   "documentation", "This is adjusted during validation, in case the GPS info from iGolf were missing, and so we do not have the holeCount form iGolf."
		   });
		addAnnotation
		  (getPriceTable_Weekend9(),
		   source,
		   new String[] {
			   "documentation", "Price for a weekend 9 hole round"
		   });
		addAnnotation
		  (getPriceTable_Weekend18(),
		   source,
		   new String[] {
			   "documentation", "Price for a weekend 18  hole round"
		   });
		addAnnotation
		  (getPriceTable_Weekday9(),
		   source,
		   new String[] {
			   "documentation", "Price for a weekday 9 hole round"
		   });
		addAnnotation
		  (getPriceTable_Weekday18(),
		   source,
		   new String[] {
			   "documentation", "Price for a weekday 18 hole round"
		   });
		addAnnotation
		  (getPriceTable_Twilight(),
		   source,
		   new String[] {
			   "documentation", "Price for a twilight round"
		   });
		addAnnotation
		  (getCourseScorecardInfo_HcpHole(),
		   source,
		   new String[] {
			   "documentation", "A hole handicap is a measure of its difficulty."
		   });
		addAnnotation
		  (getCourseScorecardInfo_ParIn(),
		   source,
		   new String[] {
			   "documentation", "Sum of parHole for holes which go from the outside to the clubhouse. They usually are holes from 10 to 18."
		   });
		addAnnotation
		  (getCourseScorecardInfo_ManualParIn(),
		   source,
		   new String[] {
			   "documentation", "This is computed at validation time, if parIn from iGolf is set to zero or null and the number of holes of the golf course are more than 9. This is the sum of parHole for holes from 9 to 18."
		   });
		addAnnotation
		  (getCourseScorecardInfo_ParOut(),
		   source,
		   new String[] {
			   "documentation", "Sum of parHole for holes which go from the clubhouse to ouside. They usually are holes from 1 to 9."
		   });
		addAnnotation
		  (getCourseScorecardInfo_ManualParOut(),
		   source,
		   new String[] {
			   "documentation", "This is computed at validation time, if parOut from iGolf is set to zero or null. This is simply the sum of parHole for holes from 1 to 9."
		   });
		addAnnotation
		  (getCourseScorecardInfo_ParTotal(),
		   source,
		   new String[] {
			   "documentation", "Sum of parIn plus parOut"
		   });
		addAnnotation
		  (getCourseScorecardInfo_ManualParTotal(),
		   source,
		   new String[] {
			   "documentation", "This is computed at validation time, in case the parTotal from iGolf is null or zero. The computation is simply the sum of all the non-zero parHole values."
		   });
		addAnnotation
		  (validationErrorTypeEEnum.getELiterals().get(3),
		   source,
		   new String[] {
			   "documentation", "If the number of non-zero parHole values in the Scorecard is inconsitent with the number of holes of the golf course."
		   });
		addAnnotation
		  (validationErrorTypeEEnum.getELiterals().get(4),
		   source,
		   new String[] {
			   "documentation", "If the number of non-zero hcpHole values in the Scorecard is inconsitent with the number of holes of the golf course."
		   });
		addAnnotation
		  (validationErrorTypeEEnum.getELiterals().get(7),
		   source,
		   new String[] {
			   "documentation", "If parIn is set to zero even though the number of holes of the golf course is larger than 9."
		   });
		addAnnotation
		  (validationErrorTypeEEnum.getELiterals().get(12),
		   source,
		   new String[] {
			   "documentation", "If the number of non-zero ydsHole values in the Tee is inconsitent with the number of holes of the golf course."
		   });
	}

} //GolfCoursePackageImpl
