/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;
import com.playertour.backend.golfcourse.model.golfcourse.PriceTable;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Price Table</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.PriceTableImpl#getWeekend9 <em>Weekend9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.PriceTableImpl#getWeekend18 <em>Weekend18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.PriceTableImpl#getWeekday9 <em>Weekday9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.PriceTableImpl#getWeekday18 <em>Weekday18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.PriceTableImpl#getTwilight <em>Twilight</em>}</li>
 * </ul>
 *
 * @generated
 */
public class PriceTableImpl extends MinimalEObjectImpl.Container implements PriceTable {
	/**
	 * The default value of the '{@link #getWeekend9() <em>Weekend9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekend9()
	 * @generated
	 * @ordered
	 */
	protected static final double WEEKEND9_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getWeekend9() <em>Weekend9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekend9()
	 * @generated
	 * @ordered
	 */
	protected double weekend9 = WEEKEND9_EDEFAULT;

	/**
	 * The default value of the '{@link #getWeekend18() <em>Weekend18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekend18()
	 * @generated
	 * @ordered
	 */
	protected static final double WEEKEND18_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getWeekend18() <em>Weekend18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekend18()
	 * @generated
	 * @ordered
	 */
	protected double weekend18 = WEEKEND18_EDEFAULT;

	/**
	 * The default value of the '{@link #getWeekday9() <em>Weekday9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekday9()
	 * @generated
	 * @ordered
	 */
	protected static final double WEEKDAY9_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getWeekday9() <em>Weekday9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekday9()
	 * @generated
	 * @ordered
	 */
	protected double weekday9 = WEEKDAY9_EDEFAULT;

	/**
	 * The default value of the '{@link #getWeekday18() <em>Weekday18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekday18()
	 * @generated
	 * @ordered
	 */
	protected static final double WEEKDAY18_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getWeekday18() <em>Weekday18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getWeekday18()
	 * @generated
	 * @ordered
	 */
	protected double weekday18 = WEEKDAY18_EDEFAULT;

	/**
	 * The default value of the '{@link #getTwilight() <em>Twilight</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTwilight()
	 * @generated
	 * @ordered
	 */
	protected static final double TWILIGHT_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getTwilight() <em>Twilight</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTwilight()
	 * @generated
	 * @ordered
	 */
	protected double twilight = TWILIGHT_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PriceTableImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.PRICE_TABLE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getWeekend9() {
		return weekend9;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWeekend9(double newWeekend9) {
		double oldWeekend9 = weekend9;
		weekend9 = newWeekend9;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.PRICE_TABLE__WEEKEND9, oldWeekend9, weekend9));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getWeekend18() {
		return weekend18;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWeekend18(double newWeekend18) {
		double oldWeekend18 = weekend18;
		weekend18 = newWeekend18;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.PRICE_TABLE__WEEKEND18, oldWeekend18, weekend18));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getWeekday9() {
		return weekday9;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWeekday9(double newWeekday9) {
		double oldWeekday9 = weekday9;
		weekday9 = newWeekday9;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.PRICE_TABLE__WEEKDAY9, oldWeekday9, weekday9));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getWeekday18() {
		return weekday18;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setWeekday18(double newWeekday18) {
		double oldWeekday18 = weekday18;
		weekday18 = newWeekday18;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.PRICE_TABLE__WEEKDAY18, oldWeekday18, weekday18));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getTwilight() {
		return twilight;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setTwilight(double newTwilight) {
		double oldTwilight = twilight;
		twilight = newTwilight;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.PRICE_TABLE__TWILIGHT, oldTwilight, twilight));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.PRICE_TABLE__WEEKEND9:
				return getWeekend9();
			case GolfCoursePackage.PRICE_TABLE__WEEKEND18:
				return getWeekend18();
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY9:
				return getWeekday9();
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY18:
				return getWeekday18();
			case GolfCoursePackage.PRICE_TABLE__TWILIGHT:
				return getTwilight();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.PRICE_TABLE__WEEKEND9:
				setWeekend9((Double)newValue);
				return;
			case GolfCoursePackage.PRICE_TABLE__WEEKEND18:
				setWeekend18((Double)newValue);
				return;
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY9:
				setWeekday9((Double)newValue);
				return;
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY18:
				setWeekday18((Double)newValue);
				return;
			case GolfCoursePackage.PRICE_TABLE__TWILIGHT:
				setTwilight((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.PRICE_TABLE__WEEKEND9:
				setWeekend9(WEEKEND9_EDEFAULT);
				return;
			case GolfCoursePackage.PRICE_TABLE__WEEKEND18:
				setWeekend18(WEEKEND18_EDEFAULT);
				return;
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY9:
				setWeekday9(WEEKDAY9_EDEFAULT);
				return;
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY18:
				setWeekday18(WEEKDAY18_EDEFAULT);
				return;
			case GolfCoursePackage.PRICE_TABLE__TWILIGHT:
				setTwilight(TWILIGHT_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.PRICE_TABLE__WEEKEND9:
				return weekend9 != WEEKEND9_EDEFAULT;
			case GolfCoursePackage.PRICE_TABLE__WEEKEND18:
				return weekend18 != WEEKEND18_EDEFAULT;
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY9:
				return weekday9 != WEEKDAY9_EDEFAULT;
			case GolfCoursePackage.PRICE_TABLE__WEEKDAY18:
				return weekday18 != WEEKDAY18_EDEFAULT;
			case GolfCoursePackage.PRICE_TABLE__TWILIGHT:
				return twilight != TWILIGHT_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (weekend9: ");
		result.append(weekend9);
		result.append(", weekend18: ");
		result.append(weekend18);
		result.append(", weekday9: ");
		result.append(weekday9);
		result.append(", weekday18: ");
		result.append(weekday18);
		result.append(", twilight: ");
		result.append(twilight);
		result.append(')');
		return result.toString();
	}

} //PriceTableImpl
