/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;
import com.playertour.backend.golfcourse.model.golfcourse.Location;
import com.playertour.backend.golfcourse.model.golfcourse.ShapeWrapper;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Shape Wrapper</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.ShapeWrapperImpl#getIgolfString <em>Igolf String</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.ShapeWrapperImpl#getPoints <em>Points</em>}</li>
 * </ul>
 *
 * @generated
 */
public class ShapeWrapperImpl extends MinimalEObjectImpl.Container implements ShapeWrapper {
	/**
	 * The default value of the '{@link #getIgolfString() <em>Igolf String</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIgolfString()
	 * @generated
	 * @ordered
	 */
	protected static final String IGOLF_STRING_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIgolfString() <em>Igolf String</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIgolfString()
	 * @generated
	 * @ordered
	 */
	protected String igolfString = IGOLF_STRING_EDEFAULT;

	/**
	 * The cached value of the '{@link #getPoints() <em>Points</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPoints()
	 * @generated
	 * @ordered
	 */
	protected EList<Location> points;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ShapeWrapperImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.SHAPE_WRAPPER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getIgolfString() {
		return igolfString;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setIgolfString(String newIgolfString) {
		String oldIgolfString = igolfString;
		igolfString = newIgolfString;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.SHAPE_WRAPPER__IGOLF_STRING, oldIgolfString, igolfString));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Location> getPoints() {
		if (points == null) {
			points = new EObjectContainmentEList<Location>(Location.class, this, GolfCoursePackage.SHAPE_WRAPPER__POINTS);
		}
		return points;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case GolfCoursePackage.SHAPE_WRAPPER__POINTS:
				return ((InternalEList<?>)getPoints()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.SHAPE_WRAPPER__IGOLF_STRING:
				return getIgolfString();
			case GolfCoursePackage.SHAPE_WRAPPER__POINTS:
				return getPoints();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.SHAPE_WRAPPER__IGOLF_STRING:
				setIgolfString((String)newValue);
				return;
			case GolfCoursePackage.SHAPE_WRAPPER__POINTS:
				getPoints().clear();
				getPoints().addAll((Collection<? extends Location>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.SHAPE_WRAPPER__IGOLF_STRING:
				setIgolfString(IGOLF_STRING_EDEFAULT);
				return;
			case GolfCoursePackage.SHAPE_WRAPPER__POINTS:
				getPoints().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.SHAPE_WRAPPER__IGOLF_STRING:
				return IGOLF_STRING_EDEFAULT == null ? igolfString != null : !IGOLF_STRING_EDEFAULT.equals(igolfString);
			case GolfCoursePackage.SHAPE_WRAPPER__POINTS:
				return points != null && !points.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (igolfString: ");
		result.append(igolfString);
		result.append(')');
		return result.toString();
	}

} //ShapeWrapperImpl
