/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.impl;

import com.playertour.backend.golfcourse.model.golfcourse.GenderType;
import com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage;
import com.playertour.backend.golfcourse.model.golfcourse.Tee;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;

import org.eclipse.emf.ecore.util.EDataTypeEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Tee</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getName <em>Name</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getColor <em>Color</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getColorValue <em>Color Value</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getGender <em>Gender</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getRating <em>Rating</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getSlope <em>Slope</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getYdsTotal <em>Yds Total</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getYds1to9 <em>Yds1to9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getYds10to18 <em>Yds10to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getYds1to18 <em>Yds1to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getYdsHole <em>Yds Hole</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getMetersTotal <em>Meters Total</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getMeters1to9 <em>Meters1to9</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getMeters10to18 <em>Meters10to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getMeters1to18 <em>Meters1to18</em>}</li>
 *   <li>{@link com.playertour.backend.golfcourse.model.golfcourse.impl.TeeImpl#getMetersHole <em>Meters Hole</em>}</li>
 * </ul>
 *
 * @generated
 */
public class TeeImpl extends MinimalEObjectImpl.Container implements Tee {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected static final String COLOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColor() <em>Color</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColor()
	 * @generated
	 * @ordered
	 */
	protected String color = COLOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getColorValue() <em>Color Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColorValue()
	 * @generated
	 * @ordered
	 */
	protected static final String COLOR_VALUE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getColorValue() <em>Color Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getColorValue()
	 * @generated
	 * @ordered
	 */
	protected String colorValue = COLOR_VALUE_EDEFAULT;

	/**
	 * The default value of the '{@link #getGender() <em>Gender</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGender()
	 * @generated
	 * @ordered
	 */
	protected static final GenderType GENDER_EDEFAULT = GenderType.MEN;

	/**
	 * The cached value of the '{@link #getGender() <em>Gender</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGender()
	 * @generated
	 * @ordered
	 */
	protected GenderType gender = GENDER_EDEFAULT;

	/**
	 * The default value of the '{@link #getRating() <em>Rating</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRating()
	 * @generated
	 * @ordered
	 */
	protected static final double RATING_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getRating() <em>Rating</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRating()
	 * @generated
	 * @ordered
	 */
	protected double rating = RATING_EDEFAULT;

	/**
	 * The default value of the '{@link #getSlope() <em>Slope</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSlope()
	 * @generated
	 * @ordered
	 */
	protected static final Integer SLOPE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSlope() <em>Slope</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSlope()
	 * @generated
	 * @ordered
	 */
	protected Integer slope = SLOPE_EDEFAULT;

	/**
	 * The default value of the '{@link #getYdsTotal() <em>Yds Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYdsTotal()
	 * @generated
	 * @ordered
	 */
	protected static final Integer YDS_TOTAL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getYdsTotal() <em>Yds Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYdsTotal()
	 * @generated
	 * @ordered
	 */
	protected Integer ydsTotal = YDS_TOTAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getYds1to9() <em>Yds1to9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYds1to9()
	 * @generated
	 * @ordered
	 */
	protected static final String YDS1TO9_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getYds1to9() <em>Yds1to9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYds1to9()
	 * @generated
	 * @ordered
	 */
	protected String yds1to9 = YDS1TO9_EDEFAULT;

	/**
	 * The default value of the '{@link #getYds10to18() <em>Yds10to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYds10to18()
	 * @generated
	 * @ordered
	 */
	protected static final String YDS10TO18_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getYds10to18() <em>Yds10to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYds10to18()
	 * @generated
	 * @ordered
	 */
	protected String yds10to18 = YDS10TO18_EDEFAULT;

	/**
	 * The default value of the '{@link #getYds1to18() <em>Yds1to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYds1to18()
	 * @generated
	 * @ordered
	 */
	protected static final String YDS1TO18_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getYds1to18() <em>Yds1to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYds1to18()
	 * @generated
	 * @ordered
	 */
	protected String yds1to18 = YDS1TO18_EDEFAULT;

	/**
	 * The cached value of the '{@link #getYdsHole() <em>Yds Hole</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getYdsHole()
	 * @generated
	 * @ordered
	 */
	protected EList<Integer> ydsHole;

	/**
	 * The default value of the '{@link #getMetersTotal() <em>Meters Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetersTotal()
	 * @generated
	 * @ordered
	 */
	protected static final Integer METERS_TOTAL_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMetersTotal() <em>Meters Total</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetersTotal()
	 * @generated
	 * @ordered
	 */
	protected Integer metersTotal = METERS_TOTAL_EDEFAULT;

	/**
	 * The default value of the '{@link #getMeters1to9() <em>Meters1to9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeters1to9()
	 * @generated
	 * @ordered
	 */
	protected static final String METERS1TO9_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMeters1to9() <em>Meters1to9</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeters1to9()
	 * @generated
	 * @ordered
	 */
	protected String meters1to9 = METERS1TO9_EDEFAULT;

	/**
	 * The default value of the '{@link #getMeters10to18() <em>Meters10to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeters10to18()
	 * @generated
	 * @ordered
	 */
	protected static final String METERS10TO18_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMeters10to18() <em>Meters10to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeters10to18()
	 * @generated
	 * @ordered
	 */
	protected String meters10to18 = METERS10TO18_EDEFAULT;

	/**
	 * The default value of the '{@link #getMeters1to18() <em>Meters1to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeters1to18()
	 * @generated
	 * @ordered
	 */
	protected static final String METERS1TO18_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getMeters1to18() <em>Meters1to18</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMeters1to18()
	 * @generated
	 * @ordered
	 */
	protected String meters1to18 = METERS1TO18_EDEFAULT;

	/**
	 * The cached value of the '{@link #getMetersHole() <em>Meters Hole</em>}' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMetersHole()
	 * @generated
	 * @ordered
	 */
	protected EList<Integer> metersHole;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TeeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return GolfCoursePackage.Literals.TEE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getColor() {
		return color;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setColor(String newColor) {
		String oldColor = color;
		color = newColor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__COLOR, oldColor, color));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getColorValue() {
		return colorValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setColorValue(String newColorValue) {
		String oldColorValue = colorValue;
		colorValue = newColorValue;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__COLOR_VALUE, oldColorValue, colorValue));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public GenderType getGender() {
		return gender;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setGender(GenderType newGender) {
		GenderType oldGender = gender;
		gender = newGender == null ? GENDER_EDEFAULT : newGender;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__GENDER, oldGender, gender));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public double getRating() {
		return rating;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRating(double newRating) {
		double oldRating = rating;
		rating = newRating;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__RATING, oldRating, rating));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Integer getSlope() {
		return slope;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setSlope(Integer newSlope) {
		Integer oldSlope = slope;
		slope = newSlope;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__SLOPE, oldSlope, slope));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Integer getYdsTotal() {
		return ydsTotal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setYdsTotal(Integer newYdsTotal) {
		Integer oldYdsTotal = ydsTotal;
		ydsTotal = newYdsTotal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__YDS_TOTAL, oldYdsTotal, ydsTotal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getYds1to9() {
		return yds1to9;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setYds1to9(String newYds1to9) {
		String oldYds1to9 = yds1to9;
		yds1to9 = newYds1to9;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__YDS1TO9, oldYds1to9, yds1to9));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getYds10to18() {
		return yds10to18;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setYds10to18(String newYds10to18) {
		String oldYds10to18 = yds10to18;
		yds10to18 = newYds10to18;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__YDS10TO18, oldYds10to18, yds10to18));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getYds1to18() {
		return yds1to18;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setYds1to18(String newYds1to18) {
		String oldYds1to18 = yds1to18;
		yds1to18 = newYds1to18;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__YDS1TO18, oldYds1to18, yds1to18));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Integer> getYdsHole() {
		if (ydsHole == null) {
			ydsHole = new EDataTypeEList<Integer>(Integer.class, this, GolfCoursePackage.TEE__YDS_HOLE);
		}
		return ydsHole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Integer getMetersTotal() {
		return metersTotal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMetersTotal(Integer newMetersTotal) {
		Integer oldMetersTotal = metersTotal;
		metersTotal = newMetersTotal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__METERS_TOTAL, oldMetersTotal, metersTotal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getMeters1to9() {
		return meters1to9;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMeters1to9(String newMeters1to9) {
		String oldMeters1to9 = meters1to9;
		meters1to9 = newMeters1to9;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__METERS1TO9, oldMeters1to9, meters1to9));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getMeters10to18() {
		return meters10to18;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMeters10to18(String newMeters10to18) {
		String oldMeters10to18 = meters10to18;
		meters10to18 = newMeters10to18;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__METERS10TO18, oldMeters10to18, meters10to18));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getMeters1to18() {
		return meters1to18;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setMeters1to18(String newMeters1to18) {
		String oldMeters1to18 = meters1to18;
		meters1to18 = newMeters1to18;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, GolfCoursePackage.TEE__METERS1TO18, oldMeters1to18, meters1to18));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EList<Integer> getMetersHole() {
		if (metersHole == null) {
			metersHole = new EDataTypeEList<Integer>(Integer.class, this, GolfCoursePackage.TEE__METERS_HOLE);
		}
		return metersHole;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case GolfCoursePackage.TEE__NAME:
				return getName();
			case GolfCoursePackage.TEE__COLOR:
				return getColor();
			case GolfCoursePackage.TEE__COLOR_VALUE:
				return getColorValue();
			case GolfCoursePackage.TEE__GENDER:
				return getGender();
			case GolfCoursePackage.TEE__RATING:
				return getRating();
			case GolfCoursePackage.TEE__SLOPE:
				return getSlope();
			case GolfCoursePackage.TEE__YDS_TOTAL:
				return getYdsTotal();
			case GolfCoursePackage.TEE__YDS1TO9:
				return getYds1to9();
			case GolfCoursePackage.TEE__YDS10TO18:
				return getYds10to18();
			case GolfCoursePackage.TEE__YDS1TO18:
				return getYds1to18();
			case GolfCoursePackage.TEE__YDS_HOLE:
				return getYdsHole();
			case GolfCoursePackage.TEE__METERS_TOTAL:
				return getMetersTotal();
			case GolfCoursePackage.TEE__METERS1TO9:
				return getMeters1to9();
			case GolfCoursePackage.TEE__METERS10TO18:
				return getMeters10to18();
			case GolfCoursePackage.TEE__METERS1TO18:
				return getMeters1to18();
			case GolfCoursePackage.TEE__METERS_HOLE:
				return getMetersHole();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case GolfCoursePackage.TEE__NAME:
				setName((String)newValue);
				return;
			case GolfCoursePackage.TEE__COLOR:
				setColor((String)newValue);
				return;
			case GolfCoursePackage.TEE__COLOR_VALUE:
				setColorValue((String)newValue);
				return;
			case GolfCoursePackage.TEE__GENDER:
				setGender((GenderType)newValue);
				return;
			case GolfCoursePackage.TEE__RATING:
				setRating((Double)newValue);
				return;
			case GolfCoursePackage.TEE__SLOPE:
				setSlope((Integer)newValue);
				return;
			case GolfCoursePackage.TEE__YDS_TOTAL:
				setYdsTotal((Integer)newValue);
				return;
			case GolfCoursePackage.TEE__YDS1TO9:
				setYds1to9((String)newValue);
				return;
			case GolfCoursePackage.TEE__YDS10TO18:
				setYds10to18((String)newValue);
				return;
			case GolfCoursePackage.TEE__YDS1TO18:
				setYds1to18((String)newValue);
				return;
			case GolfCoursePackage.TEE__YDS_HOLE:
				getYdsHole().clear();
				getYdsHole().addAll((Collection<? extends Integer>)newValue);
				return;
			case GolfCoursePackage.TEE__METERS_TOTAL:
				setMetersTotal((Integer)newValue);
				return;
			case GolfCoursePackage.TEE__METERS1TO9:
				setMeters1to9((String)newValue);
				return;
			case GolfCoursePackage.TEE__METERS10TO18:
				setMeters10to18((String)newValue);
				return;
			case GolfCoursePackage.TEE__METERS1TO18:
				setMeters1to18((String)newValue);
				return;
			case GolfCoursePackage.TEE__METERS_HOLE:
				getMetersHole().clear();
				getMetersHole().addAll((Collection<? extends Integer>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.TEE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__COLOR:
				setColor(COLOR_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__COLOR_VALUE:
				setColorValue(COLOR_VALUE_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__GENDER:
				setGender(GENDER_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__RATING:
				setRating(RATING_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__SLOPE:
				setSlope(SLOPE_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__YDS_TOTAL:
				setYdsTotal(YDS_TOTAL_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__YDS1TO9:
				setYds1to9(YDS1TO9_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__YDS10TO18:
				setYds10to18(YDS10TO18_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__YDS1TO18:
				setYds1to18(YDS1TO18_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__YDS_HOLE:
				getYdsHole().clear();
				return;
			case GolfCoursePackage.TEE__METERS_TOTAL:
				setMetersTotal(METERS_TOTAL_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__METERS1TO9:
				setMeters1to9(METERS1TO9_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__METERS10TO18:
				setMeters10to18(METERS10TO18_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__METERS1TO18:
				setMeters1to18(METERS1TO18_EDEFAULT);
				return;
			case GolfCoursePackage.TEE__METERS_HOLE:
				getMetersHole().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case GolfCoursePackage.TEE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case GolfCoursePackage.TEE__COLOR:
				return COLOR_EDEFAULT == null ? color != null : !COLOR_EDEFAULT.equals(color);
			case GolfCoursePackage.TEE__COLOR_VALUE:
				return COLOR_VALUE_EDEFAULT == null ? colorValue != null : !COLOR_VALUE_EDEFAULT.equals(colorValue);
			case GolfCoursePackage.TEE__GENDER:
				return gender != GENDER_EDEFAULT;
			case GolfCoursePackage.TEE__RATING:
				return rating != RATING_EDEFAULT;
			case GolfCoursePackage.TEE__SLOPE:
				return SLOPE_EDEFAULT == null ? slope != null : !SLOPE_EDEFAULT.equals(slope);
			case GolfCoursePackage.TEE__YDS_TOTAL:
				return YDS_TOTAL_EDEFAULT == null ? ydsTotal != null : !YDS_TOTAL_EDEFAULT.equals(ydsTotal);
			case GolfCoursePackage.TEE__YDS1TO9:
				return YDS1TO9_EDEFAULT == null ? yds1to9 != null : !YDS1TO9_EDEFAULT.equals(yds1to9);
			case GolfCoursePackage.TEE__YDS10TO18:
				return YDS10TO18_EDEFAULT == null ? yds10to18 != null : !YDS10TO18_EDEFAULT.equals(yds10to18);
			case GolfCoursePackage.TEE__YDS1TO18:
				return YDS1TO18_EDEFAULT == null ? yds1to18 != null : !YDS1TO18_EDEFAULT.equals(yds1to18);
			case GolfCoursePackage.TEE__YDS_HOLE:
				return ydsHole != null && !ydsHole.isEmpty();
			case GolfCoursePackage.TEE__METERS_TOTAL:
				return METERS_TOTAL_EDEFAULT == null ? metersTotal != null : !METERS_TOTAL_EDEFAULT.equals(metersTotal);
			case GolfCoursePackage.TEE__METERS1TO9:
				return METERS1TO9_EDEFAULT == null ? meters1to9 != null : !METERS1TO9_EDEFAULT.equals(meters1to9);
			case GolfCoursePackage.TEE__METERS10TO18:
				return METERS10TO18_EDEFAULT == null ? meters10to18 != null : !METERS10TO18_EDEFAULT.equals(meters10to18);
			case GolfCoursePackage.TEE__METERS1TO18:
				return METERS1TO18_EDEFAULT == null ? meters1to18 != null : !METERS1TO18_EDEFAULT.equals(meters1to18);
			case GolfCoursePackage.TEE__METERS_HOLE:
				return metersHole != null && !metersHole.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuilder result = new StringBuilder(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", color: ");
		result.append(color);
		result.append(", colorValue: ");
		result.append(colorValue);
		result.append(", gender: ");
		result.append(gender);
		result.append(", rating: ");
		result.append(rating);
		result.append(", slope: ");
		result.append(slope);
		result.append(", ydsTotal: ");
		result.append(ydsTotal);
		result.append(", yds1to9: ");
		result.append(yds1to9);
		result.append(", yds10to18: ");
		result.append(yds10to18);
		result.append(", yds1to18: ");
		result.append(yds1to18);
		result.append(", ydsHole: ");
		result.append(ydsHole);
		result.append(", metersTotal: ");
		result.append(metersTotal);
		result.append(", meters1to9: ");
		result.append(meters1to9);
		result.append(", meters10to18: ");
		result.append(meters10to18);
		result.append(", meters1to18: ");
		result.append(meters1to18);
		result.append(", metersHole: ");
		result.append(metersHole);
		result.append(')');
		return result.toString();
	}

} //TeeImpl
