/**
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *      Mark Hoffmann - initial API and implementation
 */
package com.playertour.backend.golfcourse.model.golfcourse.util;

import com.playertour.backend.golfcourse.model.golfcourse.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCoursePackage
 * @generated
 */
public class GolfCourseAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static GolfCoursePackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GolfCourseAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = GolfCoursePackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GolfCourseSwitch<Adapter> modelSwitch =
		new GolfCourseSwitch<Adapter>() {
			@Override
			public Adapter caseGolfCourse(GolfCourse object) {
				return createGolfCourseAdapter();
			}
			@Override
			public Adapter caseCourseDetails(CourseDetails object) {
				return createCourseDetailsAdapter();
			}
			@Override
			public Adapter caseCourseGPSVector(CourseGPSVector object) {
				return createCourseGPSVectorAdapter();
			}
			@Override
			public Adapter caseAddress(Address object) {
				return createAddressAdapter();
			}
			@Override
			public Adapter caseContact(Contact object) {
				return createContactAdapter();
			}
			@Override
			public Adapter caseLocation(Location object) {
				return createLocationAdapter();
			}
			@Override
			public Adapter casePriceTable(PriceTable object) {
				return createPriceTableAdapter();
			}
			@Override
			public Adapter caseShapeObject(ShapeObject object) {
				return createShapeObjectAdapter();
			}
			@Override
			public Adapter caseShape(Shape object) {
				return createShapeAdapter();
			}
			@Override
			public Adapter caseAttributes(Attributes object) {
				return createAttributesAdapter();
			}
			@Override
			public Adapter caseShapeWrapper(ShapeWrapper object) {
				return createShapeWrapperAdapter();
			}
			@Override
			public Adapter caseHole(Hole object) {
				return createHoleAdapter();
			}
			@Override
			public Adapter caseCourseScorecardInfo(CourseScorecardInfo object) {
				return createCourseScorecardInfoAdapter();
			}
			@Override
			public Adapter caseCourseScorecards(CourseScorecards object) {
				return createCourseScorecardsAdapter();
			}
			@Override
			public Adapter caseTee(Tee object) {
				return createTeeAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.GolfCourse <em>Golf Course</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.GolfCourse
	 * @generated
	 */
	public Adapter createGolfCourseAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseDetails <em>Course Details</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.CourseDetails
	 * @generated
	 */
	public Adapter createCourseDetailsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseGPSVector <em>Course GPS Vector</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.CourseGPSVector
	 * @generated
	 */
	public Adapter createCourseGPSVectorAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.Address <em>Address</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.Address
	 * @generated
	 */
	public Adapter createAddressAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.Contact <em>Contact</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.Contact
	 * @generated
	 */
	public Adapter createContactAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.Location <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.Location
	 * @generated
	 */
	public Adapter createLocationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.PriceTable <em>Price Table</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.PriceTable
	 * @generated
	 */
	public Adapter createPriceTableAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.ShapeObject <em>Shape Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.ShapeObject
	 * @generated
	 */
	public Adapter createShapeObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.Shape <em>Shape</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.Shape
	 * @generated
	 */
	public Adapter createShapeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.Attributes <em>Attributes</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.Attributes
	 * @generated
	 */
	public Adapter createAttributesAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.ShapeWrapper <em>Shape Wrapper</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.ShapeWrapper
	 * @generated
	 */
	public Adapter createShapeWrapperAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.Hole <em>Hole</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.Hole
	 * @generated
	 */
	public Adapter createHoleAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo <em>Course Scorecard Info</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.CourseScorecardInfo
	 * @generated
	 */
	public Adapter createCourseScorecardInfoAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards <em>Course Scorecards</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.CourseScorecards
	 * @generated
	 */
	public Adapter createCourseScorecardsAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link com.playertour.backend.golfcourse.model.golfcourse.Tee <em>Tee</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see com.playertour.backend.golfcourse.model.golfcourse.Tee
	 * @generated
	 */
	public Adapter createTeeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //GolfCourseAdapterFactory
