/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.rental;


import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;

import org.gecko.emf.osgi.annotation.provide.EPackage;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each operation of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.gecko.mac.rental.GolfRentalFactory
 * @model kind="package"
 *        annotation="Version value='1.0'"
 *        annotation="http://www.eclipse.org/emf/2002/GenModel oSGiCompatible='true' resource='XMI' copyrightText='Copyright (c) 2012 - 2025 Data In Motion and others.\nAll rights reserved.\n\nThis program and the accompanying materials are made\navailable under the terms of the Eclipse Public License 2.0\nwhich is available at https://www.eclipse.org/legal/epl-2.0/\n\nSPDX-License-Identifier: EPL-2.0\n\nContributors:\n    Data In Motioni - initial API and implementation' basePackage='org.gecko.mac'"
 * @generated
 */
@ProviderType
@EPackage(uri = GolfRentalPackage.eNS_URI, genModel = "/model/golf-rental.genmodel", genModelSourceLocations = {"model/golf-rental.genmodel","org.gecko.mac.golf.rental.model/model/golf-rental.genmodel"}, ecore="/model/golf-rental.ecore", ecoreSourceLocations="/model/golf-rental.ecore")
public interface GolfRentalPackage extends org.eclipse.emf.ecore.EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "rental";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://datainmotion.com/mac/golf/rental/1.0.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "rental";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	GolfRentalPackage eINSTANCE = org.gecko.mac.rental.impl.GolfRentalPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.gecko.mac.rental.impl.RentalImpl <em>Rental</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.rental.impl.RentalImpl
	 * @see org.gecko.mac.rental.impl.GolfRentalPackageImpl#getRental()
	 * @generated
	 */
	int RENTAL = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__ID = 0;

	/**
	 * The feature id for the '<em><b>Equipment Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__EQUIPMENT_ID = 1;

	/**
	 * The feature id for the '<em><b>Player Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__PLAYER_ID = 2;

	/**
	 * The feature id for the '<em><b>Rental Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__RENTAL_START = 3;

	/**
	 * The feature id for the '<em><b>Rental End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__RENTAL_END = 4;

	/**
	 * The feature id for the '<em><b>Total Cost</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__TOTAL_COST = 5;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__STATUS = 6;

	/**
	 * The feature id for the '<em><b>Transaction Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL__TRANSACTION_ID = 7;

	/**
	 * The number of structural features of the '<em>Rental</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL_FEATURE_COUNT = 8;

	/**
	 * The number of operations of the '<em>Rental</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RENTAL_OPERATION_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.gecko.mac.rental.RentalStatus <em>Rental Status</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.gecko.mac.rental.RentalStatus
	 * @see org.gecko.mac.rental.impl.GolfRentalPackageImpl#getRentalStatus()
	 * @generated
	 */
	int RENTAL_STATUS = 1;


	/**
	 * Returns the meta object for class '{@link org.gecko.mac.rental.Rental <em>Rental</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Rental</em>'.
	 * @see org.gecko.mac.rental.Rental
	 * @generated
	 */
	EClass getRental();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getId <em>Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Id</em>'.
	 * @see org.gecko.mac.rental.Rental#getId()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_Id();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getEquipmentId <em>Equipment Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Equipment Id</em>'.
	 * @see org.gecko.mac.rental.Rental#getEquipmentId()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_EquipmentId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getPlayerId <em>Player Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Player Id</em>'.
	 * @see org.gecko.mac.rental.Rental#getPlayerId()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_PlayerId();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getRentalStart <em>Rental Start</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rental Start</em>'.
	 * @see org.gecko.mac.rental.Rental#getRentalStart()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_RentalStart();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getRentalEnd <em>Rental End</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Rental End</em>'.
	 * @see org.gecko.mac.rental.Rental#getRentalEnd()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_RentalEnd();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getTotalCost <em>Total Cost</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Total Cost</em>'.
	 * @see org.gecko.mac.rental.Rental#getTotalCost()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_TotalCost();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getStatus <em>Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Status</em>'.
	 * @see org.gecko.mac.rental.Rental#getStatus()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_Status();

	/**
	 * Returns the meta object for the attribute '{@link org.gecko.mac.rental.Rental#getTransactionId <em>Transaction Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Transaction Id</em>'.
	 * @see org.gecko.mac.rental.Rental#getTransactionId()
	 * @see #getRental()
	 * @generated
	 */
	EAttribute getRental_TransactionId();

	/**
	 * Returns the meta object for enum '{@link org.gecko.mac.rental.RentalStatus <em>Rental Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Rental Status</em>'.
	 * @see org.gecko.mac.rental.RentalStatus
	 * @generated
	 */
	EEnum getRentalStatus();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	GolfRentalFactory getGolfRentalFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each operation of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.gecko.mac.rental.impl.RentalImpl <em>Rental</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.rental.impl.RentalImpl
		 * @see org.gecko.mac.rental.impl.GolfRentalPackageImpl#getRental()
		 * @generated
		 */
		EClass RENTAL = eINSTANCE.getRental();

		/**
		 * The meta object literal for the '<em><b>Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__ID = eINSTANCE.getRental_Id();

		/**
		 * The meta object literal for the '<em><b>Equipment Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__EQUIPMENT_ID = eINSTANCE.getRental_EquipmentId();

		/**
		 * The meta object literal for the '<em><b>Player Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__PLAYER_ID = eINSTANCE.getRental_PlayerId();

		/**
		 * The meta object literal for the '<em><b>Rental Start</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__RENTAL_START = eINSTANCE.getRental_RentalStart();

		/**
		 * The meta object literal for the '<em><b>Rental End</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__RENTAL_END = eINSTANCE.getRental_RentalEnd();

		/**
		 * The meta object literal for the '<em><b>Total Cost</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__TOTAL_COST = eINSTANCE.getRental_TotalCost();

		/**
		 * The meta object literal for the '<em><b>Status</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__STATUS = eINSTANCE.getRental_Status();

		/**
		 * The meta object literal for the '<em><b>Transaction Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RENTAL__TRANSACTION_ID = eINSTANCE.getRental_TransactionId();

		/**
		 * The meta object literal for the '{@link org.gecko.mac.rental.RentalStatus <em>Rental Status</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.gecko.mac.rental.RentalStatus
		 * @see org.gecko.mac.rental.impl.GolfRentalPackageImpl#getRentalStatus()
		 * @generated
		 */
		EEnum RENTAL_STATUS = eINSTANCE.getRentalStatus();

	}

} //GolfRentalPackage
