/*
 * Copyright (c) 2012 - 2025 Data In Motion and others.
 * All rights reserved.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Data In Motioni - initial API and implementation
 */
package org.gecko.mac.rental;

import java.util.Date;

import org.eclipse.emf.ecore.EObject;

import org.osgi.annotation.versioning.ProviderType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Rental</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.gecko.mac.rental.Rental#getId <em>Id</em>}</li>
 *   <li>{@link org.gecko.mac.rental.Rental#getEquipmentId <em>Equipment Id</em>}</li>
 *   <li>{@link org.gecko.mac.rental.Rental#getPlayerId <em>Player Id</em>}</li>
 *   <li>{@link org.gecko.mac.rental.Rental#getRentalStart <em>Rental Start</em>}</li>
 *   <li>{@link org.gecko.mac.rental.Rental#getRentalEnd <em>Rental End</em>}</li>
 *   <li>{@link org.gecko.mac.rental.Rental#getTotalCost <em>Total Cost</em>}</li>
 *   <li>{@link org.gecko.mac.rental.Rental#getStatus <em>Status</em>}</li>
 *   <li>{@link org.gecko.mac.rental.Rental#getTransactionId <em>Transaction Id</em>}</li>
 * </ul>
 *
 * @see org.gecko.mac.rental.GolfRentalPackage#getRental()
 * @model
 * @generated
 */
@ProviderType
public interface Rental extends EObject {
	/**
	 * Returns the value of the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Id</em>' attribute.
	 * @see #setId(String)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_Id()
	 * @model id="true" required="true"
	 * @generated
	 */
	String getId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getId <em>Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Id</em>' attribute.
	 * @see #getId()
	 * @generated
	 */
	void setId(String value);

	/**
	 * Returns the value of the '<em><b>Equipment Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Equipment Id</em>' attribute.
	 * @see #setEquipmentId(String)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_EquipmentId()
	 * @model required="true"
	 * @generated
	 */
	String getEquipmentId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getEquipmentId <em>Equipment Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Equipment Id</em>' attribute.
	 * @see #getEquipmentId()
	 * @generated
	 */
	void setEquipmentId(String value);

	/**
	 * Returns the value of the '<em><b>Player Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Player Id</em>' attribute.
	 * @see #setPlayerId(String)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_PlayerId()
	 * @model required="true"
	 * @generated
	 */
	String getPlayerId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getPlayerId <em>Player Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Player Id</em>' attribute.
	 * @see #getPlayerId()
	 * @generated
	 */
	void setPlayerId(String value);

	/**
	 * Returns the value of the '<em><b>Rental Start</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Date and time the equipment was picked up.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Rental Start</em>' attribute.
	 * @see #setRentalStart(Date)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_RentalStart()
	 * @model
	 * @generated
	 */
	Date getRentalStart();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getRentalStart <em>Rental Start</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rental Start</em>' attribute.
	 * @see #getRentalStart()
	 * @generated
	 */
	void setRentalStart(Date value);

	/**
	 * Returns the value of the '<em><b>Rental End</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Date and time the equipment was returned.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Rental End</em>' attribute.
	 * @see #setRentalEnd(Date)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_RentalEnd()
	 * @model
	 * @generated
	 */
	Date getRentalEnd();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getRentalEnd <em>Rental End</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rental End</em>' attribute.
	 * @see #getRentalEnd()
	 * @generated
	 */
	void setRentalEnd(Date value);

	/**
	 * Returns the value of the '<em><b>Total Cost</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Total Cost</em>' attribute.
	 * @see #setTotalCost(double)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_TotalCost()
	 * @model
	 * @generated
	 */
	double getTotalCost();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getTotalCost <em>Total Cost</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Total Cost</em>' attribute.
	 * @see #getTotalCost()
	 * @generated
	 */
	void setTotalCost(double value);

	/**
	 * Returns the value of the '<em><b>Status</b></em>' attribute.
	 * The literals are from the enumeration {@link org.gecko.mac.rental.RentalStatus}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Status</em>' attribute.
	 * @see org.gecko.mac.rental.RentalStatus
	 * @see #setStatus(RentalStatus)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_Status()
	 * @model
	 * @generated
	 */
	RentalStatus getStatus();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getStatus <em>Status</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Status</em>' attribute.
	 * @see org.gecko.mac.rental.RentalStatus
	 * @see #getStatus()
	 * @generated
	 */
	void setStatus(RentalStatus value);

	/**
	 * Returns the value of the '<em><b>Transaction Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Links to the associated Transaction for payment processing.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Transaction Id</em>' attribute.
	 * @see #setTransactionId(String)
	 * @see org.gecko.mac.rental.GolfRentalPackage#getRental_TransactionId()
	 * @model
	 * @generated
	 */
	String getTransactionId();

	/**
	 * Sets the value of the '{@link org.gecko.mac.rental.Rental#getTransactionId <em>Transaction Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Transaction Id</em>' attribute.
	 * @see #getTransactionId()
	 * @generated
	 */
	void setTransactionId(String value);

} // Rental
